/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.ADefaultCellAttribute;
import atlantis.gui.AMultiSpanCellTableUI;
import atlantis.gui.AParamGUIDataModel;
import atlantis.gui.ATreeExpansionListener;
import atlantis.parameters.AParameter;
import atlantis.parameters.AParametersGroup;
import atlantis.parameters.AStatusRootParameter;
import atlantis.utils.AUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public class AParametersTable
extends JTable {
    private TableColumn column;
    private AParamGUIDataModel dataModel;
    public static final String SET_GLOBAL = "Set Global";
    public static final String SET_LOCAL = "Set Local";
    public static final String SET_ALL_GLOBAL = "Set All Global";
    public static final String SET_ALL_LOCAL = "Set All Local";

    public AParametersTable(AParametersGroup g) {
        this.dataModel = new AParamGUIDataModel(g);
        this.setModel(this.dataModel);
        for (int i = 0; i < this.dataModel.getRowCount(); ++i) {
            this.setRowHeight(i, this.dataModel.getRowHeight(i));
        }
        if (this.dataModel.hasTree()) {
            JTree theTree = this.dataModel.getTree();
            theTree.addTreeExpansionListener(new ATreeExpansionListener(theTree, this, this.dataModel.getTreeRow()));
        }
        this.column = this.getColumnModel().getColumn(0);
        this.column.setHeaderValue("Name");
        this.column.setCellEditor(this.dataModel);
        this.column.setCellRenderer(this.dataModel);
        this.column.setPreferredWidth(110);
        this.column = this.getColumnModel().getColumn(1);
        this.column.setHeaderValue("Value");
        this.column.setCellEditor(this.dataModel);
        this.column.setCellRenderer(this.dataModel);
        this.column.setPreferredWidth(100);
        this.setUI(new AMultiSpanCellTableUI());
        this.setCellSelectionEnabled(true);
        this.addMouseListener(new MouseAdapter(){
            private int pressedX;
            private int pressedY;

            public void mousePressed(MouseEvent e) {
                int clickedRow = AParametersTable.this.rowAtPoint(e.getPoint());
                int clickedCol = AParametersTable.this.columnAtPoint(e.getPoint());
                final AParameter p = ((AParamGUIDataModel)AParametersTable.this.getModel()).getParameter(clickedRow);
                if (p instanceof AStatusRootParameter && clickedCol == 0) {
                    MouseListener[] theMLs = ((JTree)p.getNameComponent()).getMouseListeners();
                    for (int i = 0; i < theMLs.length; ++i) {
                        if (!(theMLs[i] instanceof AStatusRootParameter.NodeSelectionListener)) continue;
                        Rectangle clickedRec = AParametersTable.this.getCellRect(clickedRow, clickedCol, false);
                        ((AStatusRootParameter.NodeSelectionListener)theMLs[i]).setOffset(clickedRec.x, clickedRec.y);
                        e.translatePoint(-clickedRec.x, -clickedRec.y);
                        if (AUtilities.isRightMouseButton(e)) {
                            theMLs[i].mousePressed(e);
                            continue;
                        }
                        this.pressedX = e.getX();
                        this.pressedY = e.getY();
                    }
                    return;
                }
                if (AUtilities.isRightMouseButton(e) && clickedCol == 0) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    if (p.getScope() == 1) {
                        popupMenu.add(AParametersTable.SET_GLOBAL).addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                p.changeScope(2);
                                AParametersTable.this.refresh();
                            }
                        });
                    } else {
                        popupMenu.add(AParametersTable.SET_LOCAL).addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                p.changeScope(1);
                                AParametersTable.this.refresh();
                            }
                        });
                    }
                    popupMenu.show(AParametersTable.this, e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                int clickedRow = AParametersTable.this.rowAtPoint(e.getPoint());
                if (clickedRow < 0) {
                    return;
                }
                int clickedCol = AParametersTable.this.columnAtPoint(e.getPoint());
                AParameter p = ((AParamGUIDataModel)AParametersTable.this.getModel()).getParameter(clickedRow);
                if (p instanceof AStatusRootParameter && clickedCol == 0) {
                    MouseListener[] theMLs = ((JTree)p.getNameComponent()).getMouseListeners();
                    for (int i = 0; i < theMLs.length; ++i) {
                        if (!(theMLs[i] instanceof AStatusRootParameter.NodeSelectionListener)) continue;
                        Rectangle clickedRec = AParametersTable.this.getCellRect(clickedRow, clickedCol, false);
                        ((AStatusRootParameter.NodeSelectionListener)theMLs[i]).setOffset(clickedRec.x, clickedRec.y);
                        e.translatePoint(-clickedRec.x, -clickedRec.y);
                        if (this.pressedX != e.getX() || this.pressedY != e.getY()) continue;
                        theMLs[i].mouseClicked(e);
                    }
                    return;
                }
            }
        });
        this.refresh();
    }

    public void refresh() {
        this.dataModel.refresh();
        this.setEditingColumn(2);
        this.setEditingRow(0);
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle sRect = super.getCellRect(row, column, includeSpacing);
        if (row < 0 || column < 0 || this.getRowCount() <= row || this.getColumnCount() <= column) {
            return sRect;
        }
        ADefaultCellAttribute cellAtt = ((AParamGUIDataModel)this.getModel()).getCellAttribute();
        if (!cellAtt.isVisible(row, column)) {
            int temp_row = row;
            int temp_column = column;
            row += cellAtt.getSpan(temp_row, temp_column)[0];
            column += cellAtt.getSpan(temp_row, temp_column)[1];
        }
        int[] n = cellAtt.getSpan(row, column);
        int index = 0;
        int columnMargin = this.getColumnModel().getColumnMargin();
        Rectangle cellFrame = new Rectangle();
        int aCellHeight = sRect.height + this.rowMargin;
        cellFrame.y = sRect.y;
        cellFrame.height = n[0] * aCellHeight;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width = aColumn.getWidth() + columnMargin;
            if (index == column) break;
            cellFrame.x += cellFrame.width;
            ++index;
        }
        for (int i = 0; i < n[1] - 1; ++i) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width += aColumn.getWidth() + columnMargin;
        }
        if (!includeSpacing) {
            Dimension spacing = this.getIntercellSpacing();
            cellFrame.setBounds(cellFrame.x + spacing.width / 2, cellFrame.y + spacing.height / 2, cellFrame.width - spacing.width, cellFrame.height - spacing.height);
        }
        return cellFrame;
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent e) {
        int i;
        int firstIndex = e.getFirstIndex();
        int lastIndex = e.getLastIndex();
        if (firstIndex == -1 && lastIndex == -1) {
            this.repaint();
        }
        Rectangle dirtyRegion = this.getCellRect(firstIndex, 0, false);
        int numCoumns = this.getColumnCount();
        int index = firstIndex;
        for (i = 0; i < numCoumns; ++i) {
            dirtyRegion.add(this.getCellRect(index, i, false));
        }
        index = lastIndex;
        for (i = 0; i < numCoumns; ++i) {
            dirtyRegion.add(this.getCellRect(index, i, false));
        }
        this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
    }
}

