/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.utils.ALogger;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class APasswordDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ALogger logger = ALogger.getLogger(APasswordDialog.class);
    protected JTextField userField;
    protected JPasswordField passwordField;
    protected PasswordAuthentication pwAuth;

    protected APasswordDialog(Frame frame, String prompt) {
        super(frame, "Password Dialogue", true);
        Container contentPane = this.getContentPane();
        JPanel mainPanel = new JPanel();
        JPanel labelPanel = new JPanel();
        JPanel inputPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JLabel label = new JLabel(prompt);
        JLabel userLabel = new JLabel("User name");
        JLabel passwordLabel = new JLabel("Password");
        this.userField = new JTextField(15);
        this.passwordField = new JPasswordField(15);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        userLabel.setLabelFor(this.userField);
        passwordLabel.setLabelFor(this.passwordField);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        contentPane.add(label);
        contentPane.add(mainPanel);
        contentPane.add(buttonPanel);
        mainPanel.add(labelPanel);
        mainPanel.add(inputPanel);
        labelPanel.add(userLabel);
        labelPanel.add(passwordLabel);
        inputPanel.add(this.userField);
        inputPanel.add(this.passwordField);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String userName = APasswordDialog.this.userField.getText();
                char[] password = APasswordDialog.this.passwordField.getPassword();
                APasswordDialog.this.pwAuth = new PasswordAuthentication(userName, password);
                APasswordDialog.this.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                APasswordDialog.this.pwAuth = null;
                APasswordDialog.this.dispose();
            }
        });
        this.pack();
        int guiWidth = frame.getWidth();
        int guiHeight = frame.getHeight();
        int guiX = frame.getX();
        int dialogWidth = (int)this.getPreferredSize().getWidth();
        int dialogHeight = (int)this.getPreferredSize().getHeight();
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > screenWidth) {
            this.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, (guiHeight - dialogHeight) / 3));
        } else {
            this.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, (guiHeight - dialogHeight) / 3));
        }
    }

    protected APasswordDialog(Frame frame) {
        this(frame, "Authentication required");
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return this.pwAuth;
    }

    public static PasswordAuthentication showDialog(Frame frame, String prompt) {
        APasswordDialog d = new APasswordDialog(frame, prompt);
        d.setVisible(true);
        return d.getPasswordAuthentication();
    }

    public static PasswordAuthentication showDialog(Frame frame) {
        APasswordDialog d = new APasswordDialog(frame);
        d.setVisible(true);
        return d.getPasswordAuthentication();
    }

    public static Authenticator getAuthenticator(Frame f) {
        return new PasswordAuthenticator(f);
    }

    private static class PasswordAuthenticator
    extends Authenticator {
        protected Frame f;

        public PasswordAuthenticator(Frame frame) {
            this.f = frame;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            logger.info("Authentication required: requesting host:" + this.getRequestingHost());
            logger.info("Authentication required: requesting site:" + this.getRequestingSite());
            logger.info("Authentication required: requesting protocol:" + this.getRequestingProtocol());
            logger.info("Authentication required: requesting prompt:" + this.getRequestingPrompt());
            logger.info("Authentication required: requesting scheme:" + this.getRequestingScheme());
            String prompt = "Authentication required by host " + this.getRequestingHost() + " with prompt \"" + this.getRequestingPrompt() + "\"";
            return APasswordDialog.showDialog(this.f, prompt);
        }
    }
}

