/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.APreferencesControl;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class APointerPositionWindow
extends JFrame
implements WindowListener,
ActionListener,
MouseListener {
    private static JLabel infoLabel;
    private static JPopupMenu popupMenu;
    private static JMenuItem menuItemClearTextPane;
    private static JTextPane textPane;
    private static JScrollPane scrollPane;
    private static APointerPositionWindow instance;

    public static APointerPositionWindow getInstance() {
        if (instance == null) {
            instance = new APointerPositionWindow();
        }
        return instance;
    }

    private APointerPositionWindow() {
        this.setTitle("Your Pointer Position");
        AUtilities.setIconImage(this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        infoLabel = new JLabel();
        infoLabel.setText("To output your pointer position use: O + Right click\n");
        popupMenu = new JPopupMenu();
        menuItemClearTextPane = new JMenuItem("Erase output");
        menuItemClearTextPane.addActionListener(this);
        popupMenu.add(menuItemClearTextPane);
        textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBackground(Color.white);
        textPane.setText("Coordinates will be displayed here\n");
        textPane.addMouseListener(this);
        scrollPane = new JScrollPane(textPane);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)infoLabel, "North");
        this.add((Component)scrollPane, "Center");
        int guiWidth = HTrackMomentaWindow.getGUI().getWidth();
        int guiHeight = HTrackMomentaWindow.getGUI().getHeight();
        int guiX = HTrackMomentaWindow.getGUI().getX();
        int dialogWidth = (int)this.getPreferredSize().getWidth();
        int dialogHeight = (int)this.getPreferredSize().getHeight();
        int screenWidth = Math.round((float)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        if (guiX + guiWidth + (dialogWidth - guiWidth) / 2 > screenWidth) {
            this.setLocation(Math.max(0, screenWidth - dialogWidth), Math.max(0, (guiHeight - dialogHeight) / 3));
        } else {
            this.setLocation(Math.max(0, guiX + (guiWidth - dialogWidth) / 2), Math.max(0, (guiHeight - dialogHeight) / 3));
        }
        this.pack();
    }

    public static void append(String s) {
        String text = textPane.getText();
        int size = text.length();
        if (size > 51200) {
            textPane.setText("");
            text = text.substring(size / 2, size - 1) + "\n";
        }
        s = text + "\n" + s;
        textPane.setText(s);
    }

    void clearTextPane(ActionEvent e) {
        textPane.setText("Coordinates will be displayed here\n");
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        this.clearTextPane(e);
    }

    public void windowClosed(WindowEvent e) {
        APreferencesControl.setPosMenuItem(false);
    }

    public void mousePressed(MouseEvent evt) {
        this.showPopupMenu(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.showPopupMenu(evt);
    }

    private void showPopupMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    static {
        instance = null;
    }
}

