/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.gui.AColorMap;
import atlantis.gui.AColorMapDialog;
import atlantis.gui.AColorMapEditor;
import atlantis.gui.AConfigWriter;
import atlantis.gui.ALayoutDialog;
import atlantis.gui.ALegendWindow;
import atlantis.gui.APointerPositionWindow;
import atlantis.gui.AReadColorMapChooser;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.parameters.APar;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class APreferencesControl
extends JMenu
implements ActionListener,
ItemListener {
    private static ALogger logger = ALogger.getLogger(APreferencesControl.class);
    private static final String LAYOUT = "Change Canvas Layout";
    private static final String SELECT_COLOR_MAP = "Select Color Map";
    private static final String COLOR_MAP_EDITOR = "Color Map Editor";
    private static final String READ_COLOR_MAP = "Read Color Map";
    private static final String WRITE_COLOR_MAP = "Save Current Color Map";
    private static final String WRITE_CONFIG = "Save Current Configuration";
    private static final String POINTER_POSITION = "Show Pointer Position Window";
    private static final String LEGEND = "Show Legend Window";
    private static final String CANVAS_TITLE = "Show Canvas Title";
    private static final String WINDOW_TITLES = "Show Window Titles";
    private static final String FISHEYE_LOGO = "Show Fisheye Indicator";
    private static final String HIDE_SCALES = "Hide Scales";
    private static final String ATLAS_LOGO = "Show ATLAS logo on saved images";
    private static final String ANTI_ALIASING = "Use Anti-Aliasing";
    private static final String OPEN_GL = "Use OpenGL";
    private static JCheckBoxMenuItem posMenuItem;
    private static JCheckBoxMenuItem legMenuItem;
    private static JCheckBoxMenuItem canvasTitleMenuItem;
    private static JCheckBoxMenuItem windowTitleMenuItem;
    private static JCheckBoxMenuItem fisheyeIndicatorMenuItem;
    private static JCheckBoxMenuItem hideScalesMenuItem;
    private static JCheckBoxMenuItem atlasLogoMenuItem;
    private static JCheckBoxMenuItem aliasMenuItem;
    private static JCheckBoxMenuItem openglMenuItem;

    public APreferencesControl() {
        super("Preferences");
        this.setToolTipText("Preferences");
        this.add(SELECT_COLOR_MAP).addActionListener(this);
        this.add(COLOR_MAP_EDITOR).addActionListener(this);
        this.add(READ_COLOR_MAP).addActionListener(this);
        this.add(WRITE_COLOR_MAP).addActionListener(this);
        this.add(new JSeparator());
        this.add(LAYOUT).addActionListener(this);
        this.add(WRITE_CONFIG).addActionListener(this);
        this.add(new JSeparator());
        posMenuItem = new JCheckBoxMenuItem(POINTER_POSITION, false);
        posMenuItem.addItemListener(this);
        this.add(posMenuItem);
        legMenuItem = new JCheckBoxMenuItem(LEGEND, false);
        legMenuItem.addItemListener(this);
        this.add(legMenuItem);
        this.add(new JSeparator());
        canvasTitleMenuItem = new JCheckBoxMenuItem(CANVAS_TITLE, APar.get("Prefs", "CanvasTitle").getStatus());
        canvasTitleMenuItem.addItemListener(this);
        this.add(canvasTitleMenuItem);
        windowTitleMenuItem = new JCheckBoxMenuItem(WINDOW_TITLES, APar.get("Prefs", "WindowTitle").getStatus());
        windowTitleMenuItem.addItemListener(this);
        this.add(windowTitleMenuItem);
        fisheyeIndicatorMenuItem = new JCheckBoxMenuItem(FISHEYE_LOGO, APar.get("Prefs", "FisheyeIndicator").getStatus());
        fisheyeIndicatorMenuItem.addItemListener(this);
        this.add(fisheyeIndicatorMenuItem);
        hideScalesMenuItem = new JCheckBoxMenuItem(HIDE_SCALES, APar.get("Prefs", "HideScales").getStatus());
        hideScalesMenuItem.addItemListener(this);
        this.add(hideScalesMenuItem);
        atlasLogoMenuItem = new JCheckBoxMenuItem(ATLAS_LOGO, APar.get("Prefs", "AtlasLogo").getStatus());
        atlasLogoMenuItem.addItemListener(this);
        this.add(atlasLogoMenuItem);
        this.add(new JSeparator());
        aliasMenuItem = new JCheckBoxMenuItem(ANTI_ALIASING, APar.get("Prefs", "AntiAlias").getStatus());
        aliasMenuItem.addItemListener(this);
        this.add(aliasMenuItem);
        openglMenuItem = new JCheckBoxMenuItem(OPEN_GL, APar.get("Prefs", "OpenGL").getStatus());
        openglMenuItem.addItemListener(this);
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    public void itemStateChanged(ItemEvent e) {
        if (((JCheckBoxMenuItem)e.getSource()).getText().equals(CANVAS_TITLE)) {
            if (e.getStateChange() == 1) {
                APar.get("Prefs", "CanvasTitle").setStatus(true);
                ACanvas.getCanvas().getTitleBar().setVisible(true);
            } else {
                APar.get("Prefs", "CanvasTitle").setStatus(false);
                ACanvas.getCanvas().getTitleBar().setVisible(false);
            }
            ACanvas.getCanvas().validate();
            ACanvas.getCanvas().repaint();
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(POINTER_POSITION)) {
            if (e.getStateChange() == 1) {
                APointerPositionWindow.getInstance().setVisible(true);
            } else {
                APointerPositionWindow.getInstance().dispose();
            }
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(LEGEND)) {
            if (e.getStateChange() == 1) {
                ALegendWindow.getInstance().setVisible(true);
                ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
            } else {
                ALegendWindow.getInstance().dispose();
            }
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(WINDOW_TITLES)) {
            if (e.getStateChange() == 1) {
                APar.get("Prefs", "WindowTitle").setStatus(true);
            } else {
                APar.get("Prefs", "WindowTitle").setStatus(false);
            }
            ACanvas.getCanvas().repaintAllFromScratch();
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(FISHEYE_LOGO)) {
            if (e.getStateChange() == 1) {
                APar.get("Prefs", "FisheyeIndicator").setStatus(true);
            } else {
                APar.get("Prefs", "FisheyeIndicator").setStatus(false);
            }
            ACanvas.getCanvas().repaintAllFromScratch();
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(HIDE_SCALES)) {
            if (e.getStateChange() == 1) {
                APar.get("Prefs", "HideScales").setStatus(true);
            } else {
                APar.get("Prefs", "HideScales").setStatus(false);
            }
            ACanvas.getCanvas().repaintAllFromScratch();
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(ATLAS_LOGO)) {
            if (e.getStateChange() == 1) {
                APar.get("Prefs", "AtlasLogo").setStatus(true);
            } else {
                APar.get("Prefs", "AtlasLogo").setStatus(false);
            }
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(ANTI_ALIASING)) {
            if (e.getStateChange() == 1) {
                APar.get("Prefs", "AntiAlias").setStatus(true);
            } else {
                APar.get("Prefs", "AntiAlias").setStatus(false);
            }
            ACanvas.getCanvas().repaintAllFromScratch();
        } else if (((JCheckBoxMenuItem)e.getSource()).getText().equals(OPEN_GL)) {
            if (e.getStateChange() == 1) {
                APar.get("Prefs", "OpenGL").setStatus(true);
            } else {
                APar.get("Prefs", "OpenGL").setStatus(false);
            }
            System.out.println("No effect at present");
        }
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (LAYOUT.equals(action)) {
            new ALayoutDialog();
        } else if (SELECT_COLOR_MAP.equals(action)) {
            new AColorMapDialog();
        } else if (COLOR_MAP_EDITOR.equals(action)) {
            AColorMapEditor.getInstance().setVisible(true);
        } else if (READ_COLOR_MAP.equals(action)) {
            new AReadColorMapChooser().showMyDialog();
        } else if (WRITE_COLOR_MAP.equals(action)) {
            APreferencesControl.writeColorMap();
        } else if (WRITE_CONFIG.equals(action)) {
            APreferencesControl.writeConfiguration();
        }
    }

    private static void writeColorMap() {
        String fileName = ".Atlantis-colormap.xml";
        String title = "Saving current color map";
        logger.debug("Going to write customised color map file ...");
        String data = AColorMap.getColorMapXML();
        try {
            AUtilities.chooseFileAndWrite(HTrackMomentaWindow.getGUI(), Atlantis.USER_HOME_DIR, fileName, data.getBytes(), title, "xml");
            logger.debug("Current color map written (or cancelled by user).");
        }
        catch (AAtlantisException ex) {
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), ex.getMessage(), title, 0);
            logger.debug(ex.getMessage(), ex);
        }
    }

    private static void writeConfiguration() {
        String fileName = Atlantis.USER_CONFIG_FILE_PATH;
        String title = "Saving current configuration";
        String fileNameFull = Atlantis.USER_HOME_DIR + Atlantis.FILE_SEPAR + fileName;
        String sourceFileNameFull = "";
        logger.debug("Writing customised configuration ...");
        File user = new File(fileNameFull);
        if (user.canRead()) {
            sourceFileNameFull = fileNameFull;
            logger.debug("User has already got " + fileNameFull + " this will be used as source.");
        } else {
            sourceFileNameFull = Atlantis.getHomeDirectory() + "configuration" + Atlantis.FILE_SEPAR + "config.xml";
            logger.debug(sourceFileNameFull + " will be used as source.");
        }
        String data = AConfigWriter.getConfiguration(sourceFileNameFull);
        if (data == null) {
            String msg = "Error when reading source configuration from file\n" + sourceFileNameFull;
            logger.error(msg);
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, title, 1);
            return;
        }
        try {
            logger.debug("Current customised configuration made, going to save it ...");
            AUtilities.chooseFileAndWrite(HTrackMomentaWindow.getGUI(), Atlantis.USER_HOME_DIR, fileName, data.getBytes(), title, "xml");
            logger.debug("Saving customised configuration successful (or cancelled by user).");
        }
        catch (AAtlantisException ex) {
            String m = ex.getMessage();
            JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), m, title, 0);
            logger.error(m);
            logger.debug(m, ex);
        }
    }

    public static void setPosMenuItem(boolean selected) {
        posMenuItem.setSelected(selected);
    }

    public static void setLegMenuItem(boolean selected) {
        legMenuItem.setSelected(selected);
    }

    public static void setWindowTitleMenuItem(boolean selected) {
        windowTitleMenuItem.setSelected(selected);
        APar.get("Prefs", "WindowTitle").setStatus(selected);
    }

    public static void setFisheyeIndicatorMenuItem(boolean selected) {
        fisheyeIndicatorMenuItem.setSelected(selected);
        APar.get("Prefs", "FisheyeIndicator").setStatus(selected);
    }

    public static void setHideScalesMenuItem(boolean selected) {
        hideScalesMenuItem.setSelected(selected);
        APar.get("Prefs", "HideScales").setStatus(selected);
    }

    public static void setAtlasLogoMenuItem(boolean selected) {
        atlasLogoMenuItem.setSelected(selected);
        APar.get("Prefs", "AtlasLogo").setStatus(selected);
    }

    public static void setAliasMenuItem(boolean selected) {
        if (!Atlantis.isAtlantisHeadless()) {
            aliasMenuItem.setSelected(selected);
        }
        APar.get("Prefs", "AntiAlias").setStatus(selected);
    }

    public static boolean getLegMenuItem() {
        if (legMenuItem != null) {
            return legMenuItem.isSelected();
        }
        return false;
    }

    public static boolean getWindowTitleMenuItem() {
        if (windowTitleMenuItem != null) {
            return windowTitleMenuItem.isSelected();
        }
        return APar.get("Prefs", "WindowTitle").getStatus();
    }

    public static boolean getFisheyeIndicatorMenuItem() {
        if (fisheyeIndicatorMenuItem != null) {
            return fisheyeIndicatorMenuItem.isSelected();
        }
        return APar.get("Prefs", "FisheyeIndicator").getStatus();
    }

    public static boolean getHideScalesMenuItem() {
        if (hideScalesMenuItem != null) {
            return hideScalesMenuItem.isSelected();
        }
        return APar.get("Prefs", "HideScales").getStatus();
    }

    public static boolean getAtlasLogoMenuItem() {
        if (atlasLogoMenuItem != null) {
            return atlasLogoMenuItem.isSelected();
        }
        return APar.get("Prefs", "AtlasLogo").getStatus();
    }

    public static boolean getAliasMenuItem() {
        return APar.get("Prefs", "AntiAlias").getStatus();
    }
}

