/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.config.ADefaultValues;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class AReadFileChooser
extends JFileChooser {
    private JCheckBox defaultLoc = null;
    private Component parent = null;

    public AReadFileChooser(String path) {
        super(path);
        JPanel p = new JPanel();
        this.defaultLoc = new JCheckBox("default location");
        p.setLayout(new BorderLayout());
        p.add((Component)this.defaultLoc, "South");
        this.setAccessory(p);
        this.setFileFilter(new XMLFilter());
    }

    public int showOpenDialog(Component parent) {
        int state = super.showOpenDialog(parent);
        if (state == 0 && this.defaultLoc.isSelected()) {
            ADefaultValues.set("LastEventFilesSourceDir", this.getSelectedFile().getParent() + Atlantis.FILE_SEPAR);
        }
        return state;
    }

    private static class XMLFilter
    extends FileFilter {
        private XMLFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase();
            if (name.endsWith(".xml")) {
                return true;
            }
            if (name.endsWith(".zip")) {
                return true;
            }
            if (name.endsWith(".gzip")) {
                return true;
            }
            return name.endsWith(".gz");
        }

        public String getDescription() {
            return ".xml, .zip, .gzip, .gz";
        }
    }
}

