/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.data.ACalorimeterData;
import atlantis.geometry.AAtlasDetector;
import atlantis.geometry.ABarrelSiliconDetector;
import atlantis.geometry.ABarrelTRTDetector;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.geometry.AEndcapSiliconDetector;
import atlantis.geometry.AEndcapTRTDetector;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.xml.AXMLGeometryChooser;
import java.io.File;
import javax.swing.JOptionPane;

public class AReadGeometryChooser
extends AXMLGeometryChooser {
    public void fileChosen(int state) {
        while (state == 0) {
            File file = this.getSelectedFile();
            if (file != null) {
                if (file.canRead()) {
                    this.processSelectedFile(file);
                    break;
                }
                JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), "Unable to open " + file, "IO Error", 0);
            }
            state = this.showOpenDialog(HTrackMomentaWindow.getGUI());
        }
    }

    public boolean processSelectedFile(File file) {
        if (file.canRead()) {
            ACalorimeterDetector.clear();
            ABarrelSiliconDetector.clear();
            AEndcapSiliconDetector.clear();
            ABarrelTRTDetector.clear();
            AEndcapTRTDetector.clear();
            String muonname = file.getParent() + Atlantis.FILE_SEPAR + file.getName().substring(0, 1) + "Muon" + file.getName().substring(1);
            File mufile = new File(muonname);
            if (mufile.canRead()) {
                Atlantis.setDetector(new AAtlasDetector(file.getAbsolutePath(), muonname));
            } else {
                Atlantis.setDetector(new AAtlasDetector(file.getAbsolutePath()));
            }
            ACalorimeterData.remakeHitToGeometryMapping();
            ACanvas.getCanvas().repaintAllFromScratch();
            return true;
        }
        return false;
    }
}

