/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.config.ADefaultValues;
import atlantis.event.AEvent;
import atlantis.graphics.encoders.AImageEncoder;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.utils.AAtlantisException;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RasterFormatException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

public class ASaveCanvasDialog
extends JFileChooser
implements PropertyChangeListener {
    private final ALogger logger = ALogger.getLogger(ASaveCanvasDialog.class);
    private AResolutionChooser resolutionChooser;
    private final int[] IMAGE_WIDTHS = new int[]{512, 800, 1024, 2400};
    private final int DEFAULT_IMAGE_WIDTH = 2;
    private String defaultFileName = null;
    private final AImageEncoder imageEncoder = new AImageEncoder();

    public ASaveCanvasDialog() {
        super(ADefaultValues.get("LastCanvasPlotSaveDir"));
        this.setDialogTitle("Save Canvas");
        this.addChoosableFileFilter(new AFileFilter("eps", "Encapsulated Postscript (*.eps)"));
        this.addChoosableFileFilter(new AFileFilter("png", "Portable Network Graphics (*.png)"));
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(this.getChoosableFileFilters()[0]);
        this.resolutionChooser = new AResolutionChooser();
        this.setAccessory(this.resolutionChooser);
        this.addPropertyChangeListener(this);
        this.defaultFileName = ASaveCanvasDialog.makeEventFileName() + "-" + AUtilities.getDateTimeString();
        String ext = ((AFileFilter)this.getFileFilter()).getExtension();
        this.setSelectedFile(new File(this.defaultFileName + "." + ext));
    }

    public void showDialog() {
        this.showSaveDialog(HTrackMomentaWindow.getGUI());
    }

    public String getDefaultFileName() {
        return this.defaultFileName;
    }

    public int getImageWidth() {
        return this.resolutionChooser.getImageWidth();
    }

    public int getImageHeight() {
        return this.resolutionChooser.getImageHeight();
    }

    public void approveSelection() {
        File file;
        block6: {
            file = new File(this.getSelectedFile().getAbsolutePath());
            if (file.exists() && JOptionPane.showConfirmDialog(HTrackMomentaWindow.getGUI(), "File exists, overwrite?", "File exists", 0) != 0) {
                return;
            }
            try {
                String type = ((AFileFilter)this.getFileFilter()).getExtension();
                if (type.equals("eps")) {
                    int width = this.IMAGE_WIDTHS[2];
                    int height = ACanvas.getCanvas().getRespectiveHeight(width);
                    this.imageEncoder.saveEPS(width, height, file);
                    break block6;
                }
                if (type.equals("png")) {
                    int width = this.resolutionChooser.getImageWidth();
                    int height = this.resolutionChooser.getImageHeight();
                    byte[] data = this.imageEncoder.getPNGData(width, height);
                    BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file.getAbsolutePath()));
                    ((OutputStream)stream).write(data);
                    ((OutputStream)stream).close();
                    break block6;
                }
                throw new AAtlantisException("Unknown image type: '" + type + "'");
            }
            catch (RasterFormatException e) {
                JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), "The chosen resolution for canvas is too high, try a lower option!", "Error saving canvas", 1);
                Atlantis.restoreDefaults();
                this.cancelSelection();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), e.getMessage(), "Error saving canvas", 0);
                return;
            }
        }
        super.approveSelection();
        ADefaultValues.set("LastCanvasPlotSaveDir", file.getParent() + Atlantis.FILE_SEPAR);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("fileFilterChanged")) {
            String oldExt = ((AFileFilter)e.getOldValue()).getExtension();
            String newExt = ((AFileFilter)e.getNewValue()).getExtension();
            if (oldExt.equals("eps") && !newExt.equals("eps")) {
                for (int i = 0; i < this.resolutionChooser.getComponentCount(); ++i) {
                    this.resolutionChooser.getComponent(i).setEnabled(true);
                }
            } else if (!oldExt.equals("eps") && newExt.equals("eps")) {
                for (int i = 0; i < this.resolutionChooser.getComponentCount(); ++i) {
                    this.resolutionChooser.getComponent(i).setEnabled(false);
                }
            }
            if (this.getSelectedFile() == null) {
                this.setSelectedFile(new File(this.defaultFileName + "." + newExt));
                this.updateUI();
                this.rescanCurrentDirectory();
            }
        }
    }

    private static String makeEventFileName() {
        String name = "Untitled";
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        if (ev != null) {
            name = ev.getSourceName();
            if (name.toLowerCase().endsWith(".xml")) {
                name = name.substring(0, name.length() - 4);
            } else if (!"n/a".equals(ev.getRunNumber()) || !"n/a".equals(ev.getEventNumber())) {
                name = name + "_" + ev.getRunNumber() + "_" + ev.getEventNumber();
            }
        }
        ACanvas canvas = ACanvas.getCanvas();
        String[] windows = canvas.getCurrentLayout().getWindowNames();
        for (int i = 0; i < windows.length; ++i) {
            if (!canvas.isReallyOnScreen(canvas.getWindow(windows[i]))) continue;
            name = name + "-" + canvas.getWindow(windows[i]).getProjection().getName();
        }
        return name;
    }

    private class AFileFilter
    extends FileFilter {
        private String extension;
        private String description;

        public AFileFilter(String extension, String description) {
            this.extension = extension;
            this.description = description;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(this.extension);
        }

        public String getExtension() {
            return this.extension;
        }

        public String getDescription() {
            return this.description;
        }
    }

    class AResolutionChooser
    extends JPanel
    implements ActionListener {
        private AResolutionButton selectedButton;

        public AResolutionChooser() {
            super(new GridLayout(ASaveCanvasDialog.this.IMAGE_WIDTHS.length + 1, 1));
            this.setBorder(BorderFactory.createTitledBorder(" Resolution: "));
            ButtonGroup group = new ButtonGroup();
            for (int i = 0; i < ASaveCanvasDialog.this.IMAGE_WIDTHS.length; ++i) {
                int width = ASaveCanvasDialog.this.IMAGE_WIDTHS[i];
                int height = ACanvas.getCanvas().getRespectiveHeight(ASaveCanvasDialog.this.IMAGE_WIDTHS[i]);
                AResolutionButton button = new AResolutionButton(width, height);
                button.addActionListener(this);
                if (i == 2) {
                    this.selectedButton = button;
                    button.setSelected(true);
                }
                group.add(button);
                this.add(button);
            }
        }

        public int getImageWidth() {
            return this.selectedButton.getImageWidth();
        }

        public int getImageHeight() {
            return this.selectedButton.getImageHeight();
        }

        public void updateResolutions() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!(this.getComponent(i) instanceof AResolutionButton)) continue;
                AResolutionButton button = (AResolutionButton)this.getComponent(i);
                int height = ACanvas.getCanvas().getRespectiveHeight(button.getImageWidth());
                button.setImageHeight(height);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.selectedButton = (AResolutionButton)e.getSource();
        }

        public class AResolutionButton
        extends JRadioButton {
            int imageWidth;
            int imageHeight;

            public AResolutionButton(int imageWidth, int imageHeight) {
                super(imageWidth + "x" + imageHeight);
                this.imageWidth = imageWidth;
                this.imageHeight = imageHeight;
            }

            public int getImageWidth() {
                return this.imageWidth;
            }

            public int getImageHeight() {
                return this.imageHeight;
            }

            public void setImageHeight(int imageHeight) {
                this.imageHeight = imageHeight;
                this.setText(this.imageWidth + "x" + imageHeight);
            }
        }
    }
}

