/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.Atlantis;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class AStartupWindow {
    private final ALogger logger = ALogger.getLogger(AStartupWindow.class);
    private final JFrame frame = Atlantis.isAtlantisHeadless() ? null : new JFrame();
    private final int progressUpdateDiff;
    private JLabel text = null;
    private JProgressBar progress = null;

    public AStartupWindow(int numUpdates) {
        this.progressUpdateDiff = 100 / numUpdates;
        if (Atlantis.isAtlantisHeadless()) {
            return;
        }
        this.frame.getContentPane().setLayout(new BorderLayout());
        String fileName = Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "hypatia.jpg";
        ImageIcon icon = AUtilities.getFileAsImageIcon(fileName);
        this.frame.getContentPane().add((Component)new JLabel(icon), "Center");
        this.text = new JLabel("Welcome to HYPATIA", 0);
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        p.add(this.text);
        this.progress = new JProgressBar(0, 100);
        this.progress.setStringPainted(true);
        p.add(this.progress);
        this.frame.getContentPane().add((Component)p, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(screenSize.width / 5, screenSize.height / 3);
        this.frame.setUndecorated(true);
        AUtilities.setIconImage(this.frame);
        this.frame.setTitle("Hypatia starting up...");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void updateText(String newText) {
        this.logger.info(newText);
        if (Atlantis.isAtlantisHeadless()) {
            return;
        }
        this.text.setText(newText);
        this.progress.setValue(this.progress.getValue() + this.progressUpdateDiff);
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }
}

