/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.canvas.ACanvas;
import atlantis.canvas.ALayout;
import atlantis.canvas.ALayoutChangeListener;
import atlantis.canvas.AWindow;
import atlantis.gui.ADnDLabel;
import atlantis.gui.ADragListener;
import atlantis.gui.AEventQueue;
import atlantis.gui.AFlowLayout;
import atlantis.gui.AGridLayout;
import atlantis.gui.AHelpSystem;
import atlantis.parameters.ACommandProcessor;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AWindowControl
extends JPanel
implements ALayoutChangeListener,
ADragListener {
    private String selectedWindowName;
    private Vector pages = new Vector(10);

    public AWindowControl getPanel() {
        return this;
    }

    public AWindowControl() {
        this.setLayout(new AFlowLayout(10, 10));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (AUtilities.isRightMouseButton(e)) {
                    AHelpSystem.getInstance().showPage("WindowControl");
                }
            }
        });
        ACanvas.getCanvas().addLockChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                for (int i = 0; i < AWindowControl.this.pages.size(); ++i) {
                    Hashtable page = (Hashtable)AWindowControl.this.pages.elementAt(i);
                    Enumeration labels = page.elements();
                    while (labels.hasMoreElements()) {
                        ADnDLabel label = (ADnDLabel)labels.nextElement();
                        if (ACanvas.getCanvas().getWindow(label.getName()).isLocked()) {
                            label.setForeground(Color.red);
                            continue;
                        }
                        label.setForeground(Color.black);
                    }
                }
            }
        });
        ACanvas.getCanvas().addLayoutChangeListener(this);
        ACanvas.getCanvas().addWindowChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ADnDLabel label;
                Hashtable page;
                int i;
                if (AWindowControl.this.selectedWindowName != null) {
                    for (i = 0; i < AWindowControl.this.pages.size(); ++i) {
                        page = (Hashtable)AWindowControl.this.pages.elementAt(i);
                        label = (ADnDLabel)page.get(AWindowControl.this.selectedWindowName);
                        if (label == null) continue;
                        label.setBackground(new Color(207, 207, 207));
                    }
                }
                AWindowControl.this.selectedWindowName = ACanvas.getCanvas().getCurrentWindow().getName();
                for (i = 0; i < AWindowControl.this.pages.size(); ++i) {
                    page = (Hashtable)AWindowControl.this.pages.elementAt(i);
                    label = (ADnDLabel)page.get(AWindowControl.this.selectedWindowName);
                    if (label == null) continue;
                    label.setBackground(Color.white);
                }
            }
        });
    }

    public void layoutChanged(ACanvas c) {
        this.removeAll();
        ALayout layout = c.getCurrentLayout();
        Dimension d = layout.getSize();
        WindowMouseListener windowMouseListener = new WindowMouseListener();
        this.pages.clear();
        String[] pageNames = layout.getPageNames();
        for (int i = 0; i < pageNames.length; ++i) {
            String[] wNames = layout.getPageContent(pageNames[i]);
            JPanel page = new JPanel(new AGridLayout(d, 15));
            Hashtable<String, ADnDLabel> pageHashtable = new Hashtable<String, ADnDLabel>();
            for (int k = 0; k < wNames.length; ++k) {
                Rectangle constraint = layout.getWindowConstraints(wNames[k]);
                ADnDLabel w = new ADnDLabel(wNames[k], wNames, true);
                w.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)));
                pageHashtable.put(wNames[k], w);
                page.add((Component)w, constraint);
                w.addMouseListener(windowMouseListener);
                w.addDragListener(this);
            }
            this.pages.addElement(pageHashtable);
            this.add(page);
            this.setToolTipText("Current Layout - " + layout.getName());
            this.revalidate();
            this.repaint();
        }
    }

    public void dragPerformed(Object from, Object to, int action) {
        if (from instanceof ADnDLabel && to instanceof ADnDLabel) {
            ACanvas.getCanvas().copyWindowSettings(((ADnDLabel)from).getText(), ((ADnDLabel)to).getText());
        }
    }

    private Hashtable findPage(String[] wNames) {
        for (int i = 0; i < this.pages.size(); ++i) {
            int matches = 0;
            Hashtable page = (Hashtable)this.pages.get(i);
            for (int j = 0; j < wNames.length && page.containsKey(wNames[j]); ++j) {
                ++matches;
            }
            if (matches != wNames.length) continue;
            return page;
        }
        return null;
    }

    class WindowMouseListener
    extends MouseAdapter {
        WindowMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            ADnDLabel label = (ADnDLabel)e.getSource();
            if (AUtilities.isRightMouseButton(e)) {
                if (AEventQueue.getKeyboardState() == 65) {
                    String[] pageName = label.returnPageName();
                    Hashtable page = AWindowControl.this.findPage(pageName);
                    if (page == null) {
                        return;
                    }
                    Enumeration labels = page.elements();
                    while (labels.hasMoreElements()) {
                        label = (ADnDLabel)labels.nextElement();
                        if (label == null) continue;
                        ACommandProcessor.receive("W" + label.getName());
                    }
                } else {
                    AWindow.getPopupMenu().show(label, e.getX(), e.getY());
                    ACommandProcessor.receive("W" + label.getName());
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            ADnDLabel label = (ADnDLabel)e.getSource();
            if (SwingUtilities.isLeftMouseButton(e)) {
                ACommandProcessor.receive("W" + label.getName());
            }
        }
    }
}

