/*
 * Decompiled with CFR 0.152.
 */
package atlantis.gui;

import atlantis.gui.AAnimationControl;
import atlantis.utils.ALogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

class AnimatedEventComponent
extends JComponent
implements Runnable {
    private static ALogger logger = ALogger.getLogger(AnimatedEventComponent.class);
    private int picWidth = 0;
    private int picHeight = 0;
    private int xCenter = 0;
    private int yCenter = 0;
    private static byte[] noDataArray = null;
    private static byte[] hitsOnlyArray = null;
    private static byte[] tracksOnlyArray = null;
    private static byte[] recoArray = null;
    private double radius;
    private transient BufferedImage bkg;
    private transient BufferedImage trks;
    private transient BufferedImage hits;
    private transient BufferedImage recon;
    private transient double rinner;
    private static AffineTransform identity = new AffineTransform();
    private boolean finalPic = false;
    private volatile Thread thread = null;

    public void startAnimation() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stopAnimation() {
        this.thread = null;
    }

    public AnimatedEventComponent(int width, int height, byte[] bkgArray, byte[] hitsArray, byte[] trksArray, byte[] recoArray) {
        this.setDoubleBuffered(true);
        this.picWidth = width;
        this.picHeight = height;
        this.xCenter = (this.picWidth + 27) / 2;
        this.yCenter = (this.picHeight + 5) / 2;
        noDataArray = bkgArray;
        hitsOnlyArray = hitsArray;
        tracksOnlyArray = trksArray;
        AnimatedEventComponent.recoArray = recoArray;
        this.initialize();
    }

    private void initialize() {
        String msg = null;
        msg = "detector, background only with no data displayed";
        this.bkg = AnimatedEventComponent.createBufferedImage(noDataArray, msg);
        msg = "detector and tracks only";
        this.trks = AnimatedEventComponent.createBufferedImage(tracksOnlyArray, msg);
        msg = "detector and hits only";
        this.hits = AnimatedEventComponent.createBufferedImage(hitsOnlyArray, msg);
        msg = "everything - detector, hits, tracks and reconstructed objects";
        this.recon = AnimatedEventComponent.createBufferedImage(recoArray, msg);
        this.setRadius(0.0);
    }

    private static BufferedImage createBufferedImage(byte[] imgArray, String descr) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        ImageIcon imageIcon = new ImageIcon(imgArray, descr);
        int imageWidth = imageIcon.getIconWidth();
        int imageHeight = imageIcon.getIconHeight();
        BufferedImage bufferedImage = gc.createCompatibleImage(imageWidth, imageHeight, 1);
        Graphics g = bufferedImage.getGraphics();
        imageIcon.paintIcon(null, g, 0, 0);
        return bufferedImage;
    }

    public void setRadius(double r) {
        this.radius = Math.max(0.0, r);
        this.rinner = Math.max(this.radius - 10.0, 0.0);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Ellipse2D.Double inner = new Ellipse2D.Double((double)this.xCenter - this.rinner, (double)this.yCenter - this.rinner, 2.0 * this.rinner, 2.0 * this.rinner);
        Ellipse2D.Double outer = new Ellipse2D.Double((double)this.xCenter - this.radius, (double)this.yCenter - this.radius, 2.0 * this.radius, 2.0 * this.radius);
        g2d.drawRenderedImage(this.bkg, identity);
        g2d.setClip(outer);
        g2d.drawRenderedImage(this.trks, identity);
        g2d.setClip(inner);
        g2d.drawRenderedImage(this.hits, identity);
        if (this.finalPic) {
            g2d.drawRenderedImage(this.recon, identity);
            return;
        }
    }

    public void run() {
        double timeStep = 0.0;
        Thread thisThread = Thread.currentThread();
        while (thisThread == this.thread) {
            int sleepTime;
            block7: {
                sleepTime = 30;
                if (timeStep >= 490.0) {
                    sleepTime = 300;
                    this.finalPic = true;
                }
                this.setRadius(timeStep);
                DecimalFormat format = new DecimalFormat("####");
                format.setMinimumIntegerDigits(4);
                try {
                    this.repaint();
                }
                catch (Throwable t) {
                    if (t instanceof OutOfMemoryError) {
                        logger.fatal("Atlantis exhausted memory while animating the event, exit.", t);
                        AAnimationControl.clenupActions();
                        break;
                    }
                    if (!(t instanceof Exception)) break block7;
                    logger.fatal("Error while saving images of the sequence", t);
                    AAnimationControl.clenupActions();
                    break;
                }
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!((timeStep += 3.5) > 500.0)) continue;
            timeStep = 0.0;
            this.finalPic = false;
        }
    }
}

