/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.ALayoutChangeListener;
import atlantis.canvas.AWindow;
import atlantis.gui.ADnDLabel;
import atlantis.gui.ADragListener;
import atlantis.gui.AHelpSystem;
import atlantis.gui.AInteractionToolBar;
import atlantis.gui.AItemTabbedPane;
import atlantis.gui.AParametersPage;
import atlantis.gui.AWindowControl;
import atlantis.parameters.ACommandProcessor;
import atlantis.parameters.APar;
import atlantis.parameters.AParametersGroup;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HControlWindow
extends JFrame
implements ChangeListener,
ALayoutChangeListener {
    private static HControlWindow instance;
    private static JTabbedPane mainTabbedPane;
    static final String PARAMETERCONTROL = "Parameter Control";
    static final String INTERACTIONANDWINDOWCONTROL = "Interaction and Window Control";
    static final String OUTPUTDISPLAY = "Output Display";
    private static JPanel parameterControl;
    private static JPanel interactionAndWindowControl;
    private static JPanel outputDisplay;
    private static AItemTabbedPane[] tabbedPane;
    private static AParametersPage[][] pages;
    private static AParametersGroup[][] groups;
    private static ChangeListener[] tabChangeListener;
    private static ChangeListener outerTabChangeListener;
    private static JTabbedPane outerTabbedPane;
    private static AInteractionToolBar interactionToolBar;

    public HControlWindow() {
        super("HYPATIA - Control Window");
        AUtilities.setIconImage(this);
        instance = this;
        mainTabbedPane = new JTabbedPane();
        parameterControl = new JPanel(new BorderLayout());
        groups = APar.getUIGroups();
        pages = new AParametersPage[groups.length][];
        tabbedPane = new AItemTabbedPane[groups.length];
        tabChangeListener = new TabChangeListener[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            HControlWindow.pages[i] = new AParametersPage[groups[i].length];
            HControlWindow.tabbedPane[i] = new AItemTabbedPane(2);
            for (int j = 0; j < groups[i].length; ++j) {
                HControlWindow.pages[i][j] = new AParametersPage(groups[i][j]);
                tabbedPane[i].addTab(groups[i][j].getScreenName(), null, pages[i][j], groups[i][j].getToolTip());
                if (!groups[i][j].getScreenName().equals("Residual") && !groups[i][j].getScreenName().equals("Physics")) continue;
                tabbedPane[i].setEnabledAt(tabbedPane[i].getTabCount() - 1, false);
            }
            tabbedPane[i].setSelectedIndex(-1);
            HControlWindow.tabChangeListener[i] = new TabChangeListener();
            tabbedPane[i].addChangeListener(tabChangeListener[i]);
            tabbedPane[i].addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (AUtilities.isRightMouseButton(e)) {
                        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                        int tab = tabbedPane.getUI().tabForCoordinate(tabbedPane, e.getX(), e.getY());
                        int parentTab = ((JTabbedPane)tabbedPane.getParent()).getSelectedIndex();
                        if (tab != -1) {
                            String helpName = groups[parentTab][tab].getGroupName();
                            AHelpSystem.getInstance().showPage(helpName);
                        }
                    }
                }
            });
        }
        outerTabbedPane = new AItemTabbedPane(1);
        String[] superGroups = APar.getUISuperGroups();
        String[] superGroupTips = APar.getUISuperGroupTips();
        for (int i = 0; i < superGroups.length; ++i) {
            outerTabbedPane.addTab(superGroups[i], null, tabbedPane[i], superGroupTips[i]);
        }
        outerTabChangeListener = new OuterTabChangeListener();
        outerTabbedPane.addChangeListener(outerTabChangeListener);
        outerTabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JTabbedPane tabbedPane;
                int tab;
                if (AUtilities.isRightMouseButton(e) && (tab = (tabbedPane = (JTabbedPane)e.getSource()).getUI().tabForCoordinate(tabbedPane, e.getX(), e.getY())) != -1) {
                    String helpName = tabbedPane.getTitleAt(tab);
                    AHelpSystem.getInstance().showPage(helpName);
                }
            }
        });
        parameterControl.add(outerTabbedPane);
        mainTabbedPane.add(PARAMETERCONTROL, parameterControl);
        interactionAndWindowControl = new JPanel(new BorderLayout());
        interactionAndWindowControl.add((Component)new AWindowControl(), "South");
        ACanvas.getCanvas().addWindowChangeListener(this);
        String[] wName = ACanvas.getCanvas().getKnownWindowNames();
        for (int i = 0; i < wName.length; ++i) {
            AWindow w = ACanvas.getCanvas().getWindow(wName[i]);
            w.addProjectionChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AWindow window = (AWindow)e.getSource();
                    if (window.equals(ACanvas.getCanvas().getCurrentWindow())) {
                        if (interactionToolBar != null) {
                            interactionAndWindowControl.remove(interactionToolBar);
                        }
                        interactionToolBar = window.getInteractionToolBar();
                        if (interactionToolBar == null) {
                            window.getInteractionManager().forgetContext();
                        } else {
                            interactionAndWindowControl.add((Component)interactionToolBar, "Center");
                            interactionToolBar.connect();
                            HControlWindow.this.validate();
                        }
                    }
                }
            });
            w.addGroupChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AWindow window = (AWindow)e.getSource();
                    if (window.equals(ACanvas.getCanvas().getCurrentWindow())) {
                        HControlWindow.setSelectedTab(window.getGroupName());
                    }
                }
            });
        }
        mainTabbedPane.add(INTERACTIONANDWINDOWCONTROL, interactionAndWindowControl);
        outputDisplay = new JPanel(new BorderLayout());
        outputDisplay.add(AOutput.getOutputDisplay());
        mainTabbedPane.add(OUTPUTDISPLAY, outputDisplay);
        this.getContentPane().add(mainTabbedPane);
    }

    public void layoutChanged(ACanvas canvas) {
        Rectangle screenSize = canvas.getScreenSize();
        int useWidth = screenSize.width;
        if (Atlantis.MAX_WIDTH > 0 && useWidth > Atlantis.MAX_WIDTH) {
            useWidth = Atlantis.MAX_WIDTH;
        }
        Rectangle canvbound = canvas.getStartupCanvasSize();
        int guiHeight = canvbound.height;
        if (canvas.getCurrentLayout().getName().equals("FULL SCREEN")) {
            int guiWidth = useWidth / 4;
            this.setBounds(useWidth * 3 / 4, 0, guiWidth, guiHeight);
            int state = this.getExtendedState();
            this.setExtendedState(state |= 1);
        } else {
            int guiWidth = useWidth - canvbound.width - canvbound.x;
            this.setBounds(canvbound.x + canvbound.width, canvbound.y, guiWidth, guiHeight);
        }
    }

    public void stateChanged(ChangeEvent e) {
        HControlWindow.setSelectedTab(ACanvas.getCanvas().getCurrentWindow().getGroupName());
        if (interactionToolBar != null) {
            interactionAndWindowControl.remove(interactionToolBar);
        }
        if ((interactionToolBar = ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar()) != null) {
            interactionAndWindowControl.add((Component)interactionToolBar, "Center");
            interactionToolBar.connect();
        }
        this.validate();
    }

    private static void setSelectedTab(String newTabName) {
        block0: for (int i = 0; i < groups.length; ++i) {
            for (int j = 0; j < groups[i].length; ++j) {
                if (!groups[i][j].getGroupName().equals(newTabName)) continue;
                for (int k = 0; k < groups.length; ++k) {
                    if (k == i || tabbedPane[k].getSelectedIndex() == -1) continue;
                    tabbedPane[k].removeChangeListener(tabChangeListener[k]);
                    tabbedPane[k].setSelectedIndex(-1);
                    tabbedPane[k].addChangeListener(tabChangeListener[k]);
                }
                tabbedPane[i].removeChangeListener(tabChangeListener[i]);
                tabbedPane[i].setSelectedIndex(j);
                tabbedPane[i].addChangeListener(tabChangeListener[i]);
                outerTabbedPane.setSelectedIndex(i);
                if (HControlWindow.pages[i][j].pTable == null) continue block0;
                HControlWindow.pages[i][j].pTable.refresh();
                continue block0;
            }
        }
    }

    public static String getCurrentGroup() {
        return ACanvas.getCanvas().getCurrentWindow().getGroupName();
    }

    public static void refresh() {
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                for (int j = 0; j < groups[i].length; ++j) {
                    if (HControlWindow.pages[i][j].pTable == null) continue;
                    HControlWindow.pages[i][j].pTable.refresh();
                }
            }
        }
    }

    public static void repaintTable() {
        if (tabbedPane != null) {
            for (int i = 0; i < tabbedPane.length; ++i) {
                if (tabbedPane[i] == null) continue;
                tabbedPane[i].repaint();
            }
        }
    }

    public static HControlWindow getGUI() {
        return instance;
    }

    static class TabDragListener
    implements ADragListener {
        TabDragListener() {
        }

        public void dragPerformed(Object from, Object to, int action) {
            String wName = to instanceof ADnDLabel ? ((ADnDLabel)to).getText() : (to instanceof AWindow ? ((AWindow)to).getName() : "???");
            JTabbedPane tp = (JTabbedPane)from;
            String tabName = tp.getTitleAt(tp.getSelectedIndex());
            AOutput.append("Drag of " + tabName + " into window " + wName + "\n", "COMMAND");
            APar.copyCurrentGroupLocalsTo(wName);
            ACanvas.getCanvas().getWindow(wName).repaintFromScratch();
        }
    }

    class OuterTabChangeListener
    implements ChangeListener {
        OuterTabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            int parentIndex = tabbedPane.getSelectedIndex();
            if (parentIndex > -1) {
                JTabbedPane child = (JTabbedPane)tabbedPane.getSelectedComponent();
                if (child.getTabCount() == 0) {
                    child.setSelectedIndex(-1);
                } else {
                    int index = 0;
                    String name = groups[parentIndex][index].getGroupName();
                    if (groups[parentIndex][index].getUIUsage() == 2) {
                        name = ACanvas.getCanvas().getCurrentWindow().getProjection().getName();
                        for (int i = 0; i < groups[parentIndex].length; ++i) {
                            if (!groups[parentIndex][i].getGroupName().equals(name)) continue;
                            index = i;
                        }
                    }
                    ACommandProcessor.receive(name + ".");
                    pages[parentIndex][index].repaint();
                    pages[parentIndex][index].pTable.refresh();
                    if (groups[parentIndex][index].getUIUsage() == 2) {
                        AProjection p = AProjectionsManager.getProjection(name);
                        ACanvas.getCanvas().getCurrentWindow().setProjection(p);
                    }
                }
            }
        }
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            int index = tabbedPane.getSelectedIndex();
            if (index > -1) {
                int parentIndex = ((JTabbedPane)tabbedPane.getParent()).getSelectedIndex();
                String name = groups[parentIndex][index].getGroupName();
                ACommandProcessor.receive(name + ".");
                pages[parentIndex][index].repaint();
                pages[parentIndex][index].pTable.refresh();
                if (groups[parentIndex][index].getUIUsage() == 2) {
                    AProjection p = AProjectionsManager.getProjection(name);
                    ACanvas.getCanvas().getCurrentWindow().setProjection(p);
                }
            }
        }
    }
}

