/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

public class HData {
    public String sourceName;
    public String eventName;
    public int eventNumber;
    public int runNumber;
    public float ETMis;
    public float ETMisX;
    public float ETMisY;
    public int trackCounter = 0;
    public String[] trackGroup = new String[4];
    public String[] trackName = new String[4];
    public int[] trackIndex = new int[4];
    public double[] P = new double[4];
    public double[] Pt = new double[4];
    public double[] phi = new double[4];
    public double[] Tl = new double[4];
    public double[] eta = new double[4];
    public double[] Mlv = new double[4];
    public double[] Mll = new double[2];
    public double Mllll;
    public String[] particleType = new String[4];

    public HData() {
    }

    public HData(HData hypatiaData) {
        this.sourceName = hypatiaData.sourceName;
        this.eventName = hypatiaData.eventName;
        this.ETMis = hypatiaData.ETMis;
        this.ETMisX = hypatiaData.ETMisX;
        this.ETMisY = hypatiaData.ETMisY;
        this.trackCounter = hypatiaData.trackCounter;
        this.trackGroup = hypatiaData.trackGroup;
        this.trackName = hypatiaData.trackName;
        this.trackIndex = hypatiaData.trackIndex;
        this.P = hypatiaData.P;
        this.Pt = hypatiaData.Pt;
        this.phi = hypatiaData.phi;
        this.Tl = hypatiaData.Tl;
        this.eta = hypatiaData.eta;
        this.particleType = hypatiaData.particleType;
        this.calculate();
    }

    private void calculateMlv() {
        for (int i = 0; i < this.trackCounter; ++i) {
            if (this.ETMis != 0.0f) {
                double px = Math.abs(this.Pt[i]) * Math.cos(this.phi[i]);
                double py = Math.abs(this.Pt[i]) * Math.sin(this.phi[i]);
                this.Mlv[i] = Math.sqrt((Math.abs(this.Pt[i]) + (double)this.ETMis) * (Math.abs(this.Pt[i]) + (double)this.ETMis) - (px + (double)this.ETMisX) * (px + (double)this.ETMisX) - (py + (double)this.ETMisY) * (py + (double)this.ETMisY));
                continue;
            }
            this.Mlv[i] = 0.0;
        }
    }

    private void calculateMll() {
        for (int i = 0; i < this.trackCounter / 2; ++i) {
            double px1 = Math.abs(this.Pt[2 * i]) * Math.cos(this.phi[2 * i]);
            double px2 = Math.abs(this.Pt[2 * i + 1]) * Math.cos(this.phi[2 * i + 1]);
            double py1 = Math.abs(this.Pt[2 * i]) * Math.sin(this.phi[2 * i]);
            double py2 = Math.abs(this.Pt[2 * i + 1]) * Math.sin(this.phi[2 * i + 1]);
            double pz1 = Math.abs(this.Pt[2 * i]) * this.Tl[2 * i];
            double pz2 = Math.abs(this.Pt[2 * i + 1]) * this.Tl[2 * i + 1];
            this.Mll[i] = Math.sqrt((this.P[2 * i] + this.P[2 * i + 1]) * (this.P[2 * i] + this.P[2 * i + 1]) - (px1 + px2) * (px1 + px2) - (py1 + py2) * (py1 + py2) - (pz1 + pz2) * (pz1 + pz2));
            if (this.particleType[2 * i].equals(this.particleType[2 * i + 1])) continue;
            this.Mll[i] = -1.0;
        }
    }

    private void calculateMllll() {
        if (this.trackCounter == 4) {
            double px1 = Math.abs(this.Pt[0]) * Math.cos(this.phi[0]);
            double px2 = Math.abs(this.Pt[1]) * Math.cos(this.phi[1]);
            double px3 = Math.abs(this.Pt[2]) * Math.cos(this.phi[2]);
            double px4 = Math.abs(this.Pt[3]) * Math.cos(this.phi[3]);
            double py1 = Math.abs(this.Pt[0]) * Math.sin(this.phi[0]);
            double py2 = Math.abs(this.Pt[1]) * Math.sin(this.phi[1]);
            double py3 = Math.abs(this.Pt[2]) * Math.sin(this.phi[2]);
            double py4 = Math.abs(this.Pt[3]) * Math.sin(this.phi[3]);
            double pz1 = Math.abs(this.Pt[0]) * this.Tl[0];
            double pz2 = Math.abs(this.Pt[1]) * this.Tl[1];
            double pz3 = Math.abs(this.Pt[2]) * this.Tl[2];
            double pz4 = Math.abs(this.Pt[3]) * this.Tl[3];
            this.Mllll = Math.sqrt((this.P[0] + this.P[1] + this.P[2] + this.P[3]) * (this.P[0] + this.P[1] + this.P[2] + this.P[3]) - (px1 + px2 + px3 + px4) * (px1 + px2 + px3 + px4) - (py1 + py2 + py3 + py4) * (py1 + py2 + py3 + py4) - (pz1 + pz2 + pz3 + pz4) * (pz1 + pz2 + pz3 + pz4));
            if (!this.particleType[0].equals(this.particleType[1]) || !this.particleType[2].equals(this.particleType[3])) {
                this.Mllll = -1.0;
            }
        }
    }

    public void calculate() {
        this.calculateMlv();
        this.calculateMll();
        this.calculateMllll();
    }
}

