/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.event.AEventSource;
import atlantis.hypatia.BackgroundPanel;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.parameters.ACommandProcessor;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.ALogger;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class HDemoWindow
extends JFrame {
    static final int DEFAULT_EVENT_TYPE = 5;
    static final int WINDOW_WIDTH = 620;
    static final int WINDOW_HEIGHT = 600;
    static final int PREVIEW_SIZE = 150;
    private static HDemoWindow instance;
    private static JLabel timeLabel;
    private static JLabel eventLabel;
    private static JLabel eventOrderLabel;
    private static JComboBox timeCombo;
    private static JComboBox eventCombo;
    private static JComboBox eventOrderCombo;
    private static JButton startButton;
    private static JButton cancelButton;
    private static BackgroundPanel selectionPanel;
    private static BackgroundPanel textPanel;
    private static JPanel imagePanel;
    private static JLabel previewIconLabel;
    private static ImageIcon previewIcon;
    private static JToggleButton windowLayout1;
    private static JToggleButton windowLayout2;
    private static JToggleButton windowLayout3;
    private static ButtonGroup windowLayoutButtonGroup;
    private static ALogger logger;

    public HDemoWindow() {
        super("HYPATIA - University of Athens - Demo Control");
        AUtilities.setIconImage(this);
        instance = this;
        logger = ALogger.getLogger(HDemoWindow.class);
        textPanel = new BackgroundPanel(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Demo_Instructions.png").getImage());
        textPanel.setBorder(BorderFactory.createEtchedBorder(1));
        imagePanel = new JPanel(null);
        imagePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        previewIconLabel = new JLabel();
        imagePanel.add(previewIconLabel);
        previewIconLabel.setBounds(1, 1, 150, 150);
        selectionPanel = new BackgroundPanel(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Demo_Background.png").getImage());
        selectionPanel.setBorder(BorderFactory.createEtchedBorder(1));
        eventLabel = new JLabel("Event Type");
        String[] demoEventSelectValues = new String[]{"tt-bar \u2192 \u2113 + X", "W \u2192 e\u03bd", "W \u2192 \u03bc\u03bd", "Z \u2192 e+ + e-", "Z \u2192 \u03bc+ + \u03bc-", "\u0397 \u2192 4\u2113", "Mini Black Holes", "Find The Higgs"};
        eventCombo = new JComboBox<String>(demoEventSelectValues);
        eventCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (eventCombo.getSelectedIndex()) {
                    case 0: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "ttbar_preview.png");
                        previewIconLabel.setIcon(previewIcon);
                        break;
                    }
                    case 1: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Wenu_preview.png");
                        previewIconLabel.setIcon(previewIcon);
                        break;
                    }
                    case 2: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Wmumu_preview.png");
                        previewIconLabel.setIcon(previewIcon);
                        break;
                    }
                    case 3: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Zee_preview.png");
                        previewIconLabel.setIcon(previewIcon);
                        break;
                    }
                    case 4: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Zmumu_preview.png");
                        previewIconLabel.setIcon(previewIcon);
                        break;
                    }
                    case 5: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Higgs_preview.png");
                        previewIconLabel.setIcon(previewIcon);
                        break;
                    }
                    case 6: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Black_Hole_preview.png");
                        previewIconLabel.setIcon(previewIcon);
                        break;
                    }
                    case 7: {
                        previewIcon = new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "Find_the_Higgs.png");
                        previewIconLabel.setIcon(previewIcon);
                    }
                }
            }
        });
        eventCombo.setSelectedIndex(5);
        selectionPanel.add(eventLabel);
        selectionPanel.add(eventCombo);
        eventLabel.setBounds(183, 120, 100, 25);
        eventCombo.setBounds(260, 120, 120, 25);
        timeLabel = new JLabel("Delay between events (sec)");
        String[] demoTimeValues = new String[]{"1", "2", "3", "5", "10", "20", "30"};
        timeCombo = new JComboBox<String>(demoTimeValues);
        timeCombo.setSelectedIndex(1);
        selectionPanel.add(timeLabel);
        selectionPanel.add(timeCombo);
        timeLabel.setBounds(90, 150, 180, 25);
        timeCombo.setBounds(260, 150, 120, 25);
        eventOrderLabel = new JLabel("Event display order");
        String[] modeValues = new String[]{"Sequential", "Repeat", "Random"};
        eventOrderCombo = new JComboBox<String>(modeValues);
        eventOrderCombo.setSelectedIndex(2);
        selectionPanel.add(eventOrderLabel);
        selectionPanel.add(eventOrderCombo);
        eventOrderLabel.setBounds(138, 180, 180, 30);
        eventOrderCombo.setBounds(260, 183, 120, 25);
        windowLayout1 = new JToggleButton(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "layout1_grayed.png"));
        windowLayout1.setSelectedIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "layout1.png"));
        windowLayout1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (windowLayout1.isSelected()) {
                    ACommandProcessor.receive("WS");
                    ACommandProcessor.receive("WX");
                    ACommandProcessor.receive("WB");
                }
            }
        });
        windowLayout2 = new JToggleButton(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "layout2_grayed.png"));
        windowLayout2.setSelectedIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "layout2.png"));
        windowLayout2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (windowLayout2.isSelected()) {
                    ACommandProcessor.receive("WW");
                    AProjection p = AProjectionsManager.getProjection("YX");
                    ACanvas.getCanvas().getCurrentWindow().setProjection(p);
                    ((AProjection2D)p).setAspectRatio1(ACanvas.getCanvas().getCurrentWindow());
                }
            }
        });
        windowLayout3 = new JToggleButton(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "layout3_grayed.png"));
        windowLayout3.setSelectedIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "layout3.png"));
        windowLayout3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (windowLayout3.isSelected()) {
                    ACommandProcessor.receive("WW");
                    AProjection p = AProjectionsManager.getProjection("RZ");
                    ACanvas.getCanvas().getCurrentWindow().setProjection(p);
                    ((AProjection2D)p).setAspectRatio1(ACanvas.getCanvas().getCurrentWindow());
                }
            }
        });
        windowLayout1.setSelected(true);
        windowLayoutButtonGroup = new ButtonGroup();
        windowLayoutButtonGroup.add(windowLayout1);
        windowLayoutButtonGroup.add(windowLayout2);
        windowLayoutButtonGroup.add(windowLayout3);
        selectionPanel.add(windowLayout1);
        selectionPanel.add(windowLayout2);
        selectionPanel.add(windowLayout3);
        windowLayout1.setBounds(40, 10, 100, 100);
        windowLayout2.setBounds(170, 10, 100, 100);
        windowLayout3.setBounds(300, 10, 100, 100);
        startButton = new JButton("Start");
        startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTrackMomentaWindow.setDemoDelay(Integer.parseInt(timeCombo.getSelectedItem().toString()) * 1000);
                switch (eventCombo.getSelectedIndex()) {
                    case 0: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "ttbar.zip";
                        break;
                    }
                    case 1: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "Wenu.zip";
                        break;
                    }
                    case 2: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "Wmumu.zip";
                        break;
                    }
                    case 3: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "Zee.zip";
                        break;
                    }
                    case 4: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "Zmumu.zip";
                        break;
                    }
                    case 5: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "Higgs.zip";
                        break;
                    }
                    case 6: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "BlackHoles.zip";
                        break;
                    }
                    case 7: {
                        Atlantis.demoEventPath = Atlantis.getHomeDirectory() + "events" + Atlantis.FILE_SEPAR + "FindTheHiggs.zip";
                    }
                }
                try {
                    Atlantis.getEventManager().setEventSource("file://" + Atlantis.demoEventPath);
                    switch (eventOrderCombo.getSelectedIndex()) {
                        case 0: {
                            Atlantis.getEventManager().getEventSource().setNavigationMode(AEventSource.NavigationMode.SEQUENTIAL);
                            break;
                        }
                        case 1: {
                            Atlantis.getEventManager().getEventSource().setNavigationMode(AEventSource.NavigationMode.LOOP);
                            break;
                        }
                        case 2: {
                            Atlantis.getEventManager().getEventSource().setNavigationMode(AEventSource.NavigationMode.RANDOM);
                        }
                    }
                    Atlantis.getEventManager().nextEvent();
                }
                catch (AEventSource.NoMoreEventsException nme) {
                    try {
                        Atlantis.getEventManager().setEventSource("file://" + Atlantis.demoEventPath);
                        Atlantis.getEventManager().nextEvent();
                    }
                    catch (Exception ex) {}
                }
                catch (AEventSource.ReadEventException ree) {
                    logger.warn("Got ReadEventException: " + ree.getMessage() + " - trying next event");
                }
                catch (AEventSource.InvalidEventSourceException ies) {
                    String msg = "Event source is not valid: +" + ies.getMessage() + " - stopping Demo!";
                    logger.error(msg);
                    JOptionPane.showMessageDialog(null, msg, "Invalid Event Source", 0);
                    HTrackMomentaWindow.removeDemoCheckBox();
                }
                ACanvas.getCanvas().repaintAllFromScratch();
                HTrackMomentaWindow.startDemo();
                instance.setVisible(false);
            }
        });
        cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTrackMomentaWindow.removeDemoCheckBox();
                instance.setVisible(false);
            }
        });
        selectionPanel.add(startButton);
        selectionPanel.add(cancelButton);
        startButton.setBounds(180, 230, 110, 30);
        cancelButton.setBounds(310, 230, 110, 30);
        this.setLayout(null);
        this.add(textPanel);
        this.add(selectionPanel);
        selectionPanel.add(imagePanel);
        textPanel.setBounds(5, 5, 605, 285);
        selectionPanel.setBounds(5, 295, 605, 270);
        imagePanel.setBounds(445, 10, 152, 152);
        this.setSize(620, 600);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    public static void ShowWindow() {
        instance.setVisible(true);
    }
}

