/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

import atlantis.utils.AUtilities;
import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.ref.plotter.PlotterUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HHistogram
extends JFrame {
    private static JPanel histogramPanel;
    private static IAnalysisFactory hypatiaAF;
    private static IHistogramFactory hypatiaHF;
    private static IHistogram1D hypatiaH1D;
    private static IPlotter hypatiaPlotter;

    public HHistogram() {
        this.setTitle("HYPATIA - Histogram");
        AUtilities.setIconImage(this);
        this.setSize(500, 300);
        this.setLocationRelativeTo(null);
        histogramPanel = new JPanel(new BorderLayout());
        hypatiaAF = IAnalysisFactory.create();
        hypatiaHF = hypatiaAF.createHistogramFactory(hypatiaAF.createTreeFactory().create());
        hypatiaPlotter = hypatiaAF.createPlotterFactory().create();
        this.add((Component)histogramPanel, "Center");
    }

    public static void drawDoubleDataHistogram(String name, double[] data, int entries, int division) {
        double valueMin = data[0];
        double valueMax = data[0];
        for (int i = 0; i < entries; ++i) {
            if (data[i] < valueMin) {
                valueMin = data[i];
            }
            if (!(data[i] > valueMax)) continue;
            valueMax = data[i];
        }
        double step = valueMin == valueMax ? 10.0 : (valueMax - valueMin) / (double)division;
        hypatiaH1D = hypatiaHF.createHistogram1D(name, division, valueMin - 10.0 * step, valueMax + 10.0 * step);
        for (int i = 0; i < entries; ++i) {
            hypatiaH1D.fill(data[i]);
        }
        hypatiaPlotter.destroyRegions();
        hypatiaPlotter.createRegion(0.0, 0.0, 1.0, 1.0);
        hypatiaPlotter.currentRegion().style().dataStyle().fillStyle().setColor("blue");
        hypatiaPlotter.currentRegion().style().dataStyle().errorBarStyle().setVisible(false);
        hypatiaPlotter.currentRegion().plot((IBaseHistogram)hypatiaH1D);
        histogramPanel.add(PlotterUtilities.componentForPlotter((IPlotter)hypatiaPlotter), "Center");
    }
}

