/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

import atlantis.Atlantis;
import atlantis.data.AETMisData;
import atlantis.data.AElectronData;
import atlantis.data.AJetData;
import atlantis.data.AMuonData;
import atlantis.data.AMuonTrackData;
import atlantis.data.ASMTrData;
import atlantis.data.ASTrData;
import atlantis.data.ATrackData;
import atlantis.event.AEvent;
import atlantis.event.AEventSource;
import atlantis.graphics.APickingGraphics2D;
import atlantis.gui.AClosingConfirmationDialog;
import atlantis.gui.AExceptionHandler;
import atlantis.gui.AFileControl;
import atlantis.gui.AHelpControl;
import atlantis.gui.APreferencesControl;
import atlantis.hypatia.HData;
import atlantis.hypatia.HHistogram;
import atlantis.hypatia.HHistogramControl;
import atlantis.hypatia.HTrackColor;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.hypatia.HUtilities;
import atlantis.hypatia.HViewControl;
import atlantis.list.AList;
import atlantis.list.AListManager;
import atlantis.utils.AMath;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HInvariantMassWindow
extends JFrame {
    private static HInvariantMassWindow instance;
    public static final String MESSAGE_ONE_TRACK = "Insert a track first.";
    public static final String MESSAGE_TWO_TRACKS = "You need to insert at least two tracks from one event.";
    public static final String MESSAGE_FOUR_TRACKS = "You need to insert at least four tracks from one event.";
    public static final String MESSAGE_ONLY_FOUR_TRACKS = "You can insert only four tracks from each event.";
    private static JTable invariantMassTable;
    private static JScrollPane invariantMassScrollPane;
    private static DefaultTableModel invariantMassTableModel;
    private static ArrayList<HData> data;
    private static AEvent currentEvent;
    private static HHistogram histogram;
    private static String[] columnToolTips;

    public HInvariantMassWindow() {
        super("Hybrid pupils' analysis tool for interactions in ATLAS - version 6.0 - Invariant Mass Window");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new AClosingConfirmationDialog(this));
        AUtilities.setIconImage(this);
        instance = this;
        data = new ArrayList();
        histogram = new HHistogram();
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new AFileControl());
        menuBar.add(new HViewControl());
        menuBar.add(new HHistogramControl());
        menuBar.add(new APreferencesControl());
        menuBar.add(new AHelpControl());
        this.setJMenuBar(menuBar);
        HInvariantMassWindow.invariantMassTableInit();
        this.add(invariantMassScrollPane);
    }

    private static void invariantMassTableInit() {
        invariantMassTable = new JTable();
        invariantMassScrollPane = new JScrollPane();
        invariantMassTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        invariantMassTableModel.addColumn("File Name");
        invariantMassTableModel.addColumn("ETMis [GeV]");
        invariantMassTableModel.addColumn("Track");
        invariantMassTableModel.addColumn("P [GeV]");
        invariantMassTableModel.addColumn("+/-");
        invariantMassTableModel.addColumn("Pt [GeV]");
        invariantMassTableModel.addColumn("\u03c6");
        invariantMassTableModel.addColumn("\u03b7");
        invariantMassTableModel.addColumn("M(l\u03bd) [GeV]");
        invariantMassTableModel.addColumn("M(2l) [GeV]");
        invariantMassTableModel.addColumn("M(4l) [GeV]");
        invariantMassTableModel.addColumn("e/\u03bc");
        invariantMassTable = new JTable(invariantMassTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                c.setBackground(Color.white);
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }

            public String getToolTipText(MouseEvent event) {
                int col = this.convertColumnIndexToModel(this.columnAtPoint(event.getPoint()));
                return columnToolTips[col];
            }
        };
        invariantMassTable.setAutoResizeMode(2);
        invariantMassTable.setRowSelectionAllowed(false);
        invariantMassTable.setColumnSelectionAllowed(false);
        invariantMassTable.setFocusable(false);
        invariantMassTable.getTableHeader().setReorderingAllowed(false);
        invariantMassTable.setSelectionMode(0);
        invariantMassTable.getColumnModel().getColumn(0).setPreferredWidth(220);
        invariantMassTable.getColumnModel().getColumn(1).setPreferredWidth(90);
        invariantMassTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        invariantMassTable.getColumnModel().getColumn(4).setPreferredWidth(15);
        invariantMassTable.removeColumn(invariantMassTable.getColumnModel().getColumn(8));
        invariantMassTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HInvariantMassWindow.markSelectedTrack();
            }
        });
        invariantMassTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HInvariantMassWindow.markSelectedTrack();
            }
        });
        invariantMassScrollPane.setViewportView(invariantMassTable);
    }

    public static void markTrackFromTrackMomentaWindow(String EventName, String TrackName) {
        for (int i = 0; i < invariantMassTable.getModel().getRowCount(); ++i) {
            Object TableEventName;
            int q = i;
            while ((TableEventName = invariantMassTable.getModel().getValueAt(q, 0)) == null && --q >= 0) {
            }
            if (!TableEventName.toString().equals(EventName) || !invariantMassTable.getModel().getValueAt(i, 2).equals(TrackName)) continue;
            invariantMassTable.getSelectionModel().setSelectionInterval(i, i);
            invariantMassTable.scrollRectToVisible(invariantMassTable.getCellRect(i, 0, true));
        }
    }

    private static void markSelectedTrack() {
        int trackCounter = 0;
        int selectedTrack = invariantMassTable.getSelectedRow();
        if (selectedTrack != -1) {
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    if (selectedTrack == trackCounter) {
                        if (!Atlantis.getEventManager().getEventSource().getSourceName().equals(HInvariantMassWindow.data.get((int)i).sourceName) || !Atlantis.getEventManager().getCurrentEvent().getSourceName().equals(HInvariantMassWindow.data.get((int)i).eventName)) {
                            try {
                                Atlantis.getEventManager().setEventSource("file://" + HInvariantMassWindow.data.get((int)i).sourceName + System.getProperty("file.separator") + HInvariantMassWindow.data.get((int)i).eventName);
                                Atlantis.getEventManager().nextEvent();
                            }
                            catch (AEventSource.NoMoreEventsException nme) {
                                String msg = "No events found from this source!";
                            }
                            catch (AEventSource.InvalidEventSourceException ies) {
                                String msg = "Not a valid event source";
                            }
                            catch (AEventSource.ReadEventException ree) {
                                String msg = "Can not read event(s)";
                            }
                        }
                        currentEvent = Atlantis.getEventManager().getCurrentEvent();
                        APickingGraphics2D.setPicked(currentEvent.getTrackData("InDetTrack", HInvariantMassWindow.data.get((int)i).trackName[j]), HInvariantMassWindow.data.get((int)i).trackIndex[j]);
                        AList picked = APickingGraphics2D.getPickedHit();
                        AListManager.getInstance().highlight(picked);
                        HTrackMomentaWindow.markSelectedRecTrack();
                        invariantMassTable.getSelectionModel().setSelectionInterval(selectedTrack, selectedTrack);
                        invariantMassTable.scrollRectToVisible(invariantMassTable.getCellRect(selectedTrack, 0, true));
                        return;
                    }
                    ++trackCounter;
                }
            }
        }
    }

    public static void repaintTable() {
        invariantMassTableModel.setRowCount(0);
        for (int i = 0; i < data.size(); ++i) {
            for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                Object[] trackInfo = new Object[12];
                trackInfo[2] = HInvariantMassWindow.data.get((int)i).trackName[j] + " " + HInvariantMassWindow.data.get((int)i).trackIndex[j];
                trackInfo[3] = AMath.d2s(HInvariantMassWindow.data.get((int)i).P[j], 1);
                trackInfo[4] = HUtilities.getSign(HInvariantMassWindow.data.get((int)i).Pt[j]);
                trackInfo[5] = AMath.d2s(Math.abs(HInvariantMassWindow.data.get((int)i).Pt[j]), 1);
                trackInfo[6] = AMath.d2s(HInvariantMassWindow.data.get((int)i).phi[j], 3);
                trackInfo[7] = AMath.d2s(HInvariantMassWindow.data.get((int)i).eta[j], 3);
                trackInfo[8] = AMath.d2s(HInvariantMassWindow.data.get((int)i).Mlv[j], 3);
                trackInfo[11] = HInvariantMassWindow.data.get((int)i).particleType[j];
                switch (j) {
                    case 0: {
                        trackInfo[0] = HInvariantMassWindow.data.get((int)i).eventName;
                        trackInfo[1] = AMath.d2s(HInvariantMassWindow.data.get((int)i).ETMis, 3);
                        if (HInvariantMassWindow.data.get((int)i).trackCounter >= 2) {
                            trackInfo[9] = HInvariantMassWindow.data.get((int)i).Mll[0] != -1.0 ? AMath.d2s(HInvariantMassWindow.data.get((int)i).Mll[0], 3) : "Incompatible";
                        }
                        if (HInvariantMassWindow.data.get((int)i).trackCounter < 4) break;
                        if (HInvariantMassWindow.data.get((int)i).Mllll != -1.0) {
                            trackInfo[10] = AMath.d2s(HInvariantMassWindow.data.get((int)i).Mllll, 3);
                            break;
                        }
                        trackInfo[10] = "Incompatible";
                        break;
                    }
                    case 2: {
                        if (HInvariantMassWindow.data.get((int)i).trackCounter < 4) break;
                        trackInfo[9] = HInvariantMassWindow.data.get((int)i).Mll[1] != -1.0 ? AMath.d2s(HInvariantMassWindow.data.get((int)i).Mll[1], 3) : "Incompatible";
                    }
                }
                invariantMassTableModel.insertRow(invariantMassTableModel.getRowCount(), trackInfo);
            }
        }
        HInvariantMassWindow.findTrack();
    }

    public static void insertTrack(String RecTrackName, int RecTrackIndex, double RecTrackP, double RecTrackPt, double RecTrackPhi, double RecTrackTl, double RecTrackEta, String particleType) {
        String pickedTrackGroup;
        int pickedTrackIndex;
        String pickedTrackName;
        currentEvent = Atlantis.getEventManager().getCurrentEvent();
        int event = -1;
        for (int i = 0; i < data.size(); ++i) {
            if (!HInvariantMassWindow.data.get((int)i).sourceName.equals(Atlantis.getEventManager().getEventSource().getSourceName()) || !HInvariantMassWindow.data.get((int)i).eventName.equals(currentEvent.getSourceName()) || (long)HInvariantMassWindow.data.get((int)i).eventNumber != currentEvent.getEventNumber() || (long)HInvariantMassWindow.data.get((int)i).runNumber != currentEvent.getRunNumber()) continue;
            if (HInvariantMassWindow.data.get((int)i).trackCounter > 3) {
                System.out.println(MESSAGE_ONLY_FOUR_TRACKS);
                AExceptionHandler.processException("warning", MESSAGE_ONLY_FOUR_TRACKS);
                return;
            }
            pickedTrackName = APickingGraphics2D.getPickedData().getStoreGateKey();
            if (pickedTrackName == null) {
                pickedTrackName = APickingGraphics2D.getPickedData().getNameScreenName();
            }
            pickedTrackIndex = APickingGraphics2D.getPickedHitIndex();
            pickedTrackGroup = APickingGraphics2D.getPickedData().getParameterGroup();
            for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                if (!HInvariantMassWindow.data.get((int)i).trackName[j].equals(RecTrackName) || HInvariantMassWindow.data.get((int)i).trackIndex[j] != RecTrackIndex || !HInvariantMassWindow.data.get((int)i).trackGroup[j].equals(pickedTrackGroup)) continue;
                System.out.println("Track Exists in Invariant Mass");
                return;
            }
            event = i;
            break;
        }
        if (event == -1) {
            data.add(new HData());
            event = data.size() - 1;
        }
        HInvariantMassWindow.data.get((int)event).sourceName = Atlantis.getEventManager().getEventSource().getSourceName();
        HInvariantMassWindow.data.get((int)event).eventName = currentEvent.getSourceName();
        HInvariantMassWindow.data.get((int)event).eventNumber = (int)currentEvent.getEventNumber();
        HInvariantMassWindow.data.get((int)event).runNumber = (int)currentEvent.getRunNumber();
        AETMisData ETMis = (AETMisData)currentEvent.get("ETMisMET_Final");
        if (ETMis != null) {
            HInvariantMassWindow.data.get((int)event).ETMis = ETMis.getET();
            HInvariantMassWindow.data.get((int)event).ETMisX = ETMis.getETx();
            HInvariantMassWindow.data.get((int)event).ETMisY = ETMis.getETy();
        } else {
            HInvariantMassWindow.data.get((int)event).ETMis = 0.0f;
            HInvariantMassWindow.data.get((int)event).ETMisX = 0.0f;
            HInvariantMassWindow.data.get((int)event).ETMisY = 0.0f;
        }
        pickedTrackName = APickingGraphics2D.getPickedData().getStoreGateKey();
        if (pickedTrackName == null) {
            pickedTrackName = APickingGraphics2D.getPickedData().getNameScreenName();
        }
        pickedTrackIndex = APickingGraphics2D.getPickedHitIndex();
        pickedTrackGroup = APickingGraphics2D.getPickedData().getParameterGroup();
        HInvariantMassWindow.data.get((int)event).trackName[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTrackName;
        HInvariantMassWindow.data.get((int)event).trackIndex[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTrackIndex;
        HInvariantMassWindow.data.get((int)event).trackGroup[HInvariantMassWindow.data.get((int)event).trackCounter] = pickedTrackGroup;
        HInvariantMassWindow.data.get((int)event).particleType[HInvariantMassWindow.data.get((int)event).trackCounter] = particleType;
        if (pickedTrackGroup.equals("InDetTrack")) {
            ATrackData RecTracks = currentEvent.getTrackData("InDetTrack", pickedTrackName);
            HInvariantMassWindow.data.get((int)event).Pt[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTracks.getModifiableHelix((int)pickedTrackIndex).pT;
            HInvariantMassWindow.data.get((int)event).P[HInvariantMassWindow.data.get((int)event).trackCounter] = AMath.getPFromPttL(RecTracks.getModifiableHelix((int)pickedTrackIndex).pT, RecTracks.getModifiableHelix((int)pickedTrackIndex).tL);
            HInvariantMassWindow.data.get((int)event).phi[HInvariantMassWindow.data.get((int)event).trackCounter] = AMath.degreesToRadians(RecTracks.getModifiableHelix((int)pickedTrackIndex).phi0);
            HInvariantMassWindow.data.get((int)event).Tl[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTracks.getModifiableHelix((int)pickedTrackIndex).tL;
            HInvariantMassWindow.data.get((int)event).eta[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTracks.getModifiableHelix((int)pickedTrackIndex).eta;
        } else if (pickedTrackGroup.equals("STr")) {
            ASTrData SimTracks = currentEvent.getSTrData();
            HInvariantMassWindow.data.get((int)event).Pt[HInvariantMassWindow.data.get((int)event).trackCounter] = SimTracks.getModifiableHelix((int)pickedTrackIndex).pT;
            HInvariantMassWindow.data.get((int)event).P[HInvariantMassWindow.data.get((int)event).trackCounter] = AMath.getPFromPttL(SimTracks.getModifiableHelix((int)pickedTrackIndex).pT, SimTracks.getModifiableHelix((int)pickedTrackIndex).tL);
            HInvariantMassWindow.data.get((int)event).phi[HInvariantMassWindow.data.get((int)event).trackCounter] = AMath.degreesToRadians(SimTracks.getModifiableHelix((int)pickedTrackIndex).phi0);
            HInvariantMassWindow.data.get((int)event).Tl[HInvariantMassWindow.data.get((int)event).trackCounter] = SimTracks.getModifiableHelix((int)pickedTrackIndex).tL;
            HInvariantMassWindow.data.get((int)event).eta[HInvariantMassWindow.data.get((int)event).trackCounter] = SimTracks.getModifiableHelix((int)pickedTrackIndex).eta;
        } else if (pickedTrackGroup.equals("MuonTrack")) {
            AMuonTrackData RecMuonTracks = (AMuonTrackData)currentEvent.getTrackData("MuonTrack", pickedTrackName);
            HInvariantMassWindow.data.get((int)event).Pt[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTrackPt;
            HInvariantMassWindow.data.get((int)event).P[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTrackP;
            HInvariantMassWindow.data.get((int)event).phi[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTrackPhi;
            HInvariantMassWindow.data.get((int)event).Tl[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTrackTl;
            HInvariantMassWindow.data.get((int)event).eta[HInvariantMassWindow.data.get((int)event).trackCounter] = RecTrackEta;
        } else if (pickedTrackGroup.equals("SMTr")) {
            ASMTrData SimMuonTracks = (ASMTrData)currentEvent.get("SMTr");
            HInvariantMassWindow.data.get((int)event).Pt[HInvariantMassWindow.data.get((int)event).trackCounter] = SimMuonTracks.getPt(pickedTrackIndex);
            HInvariantMassWindow.data.get((int)event).P[HInvariantMassWindow.data.get((int)event).trackCounter] = SimMuonTracks.getP(pickedTrackIndex);
            HInvariantMassWindow.data.get((int)event).phi[HInvariantMassWindow.data.get((int)event).trackCounter] = SimMuonTracks.getPhi(pickedTrackIndex);
            HInvariantMassWindow.data.get((int)event).Tl[HInvariantMassWindow.data.get((int)event).trackCounter] = SimMuonTracks.gettL(pickedTrackIndex);
            HInvariantMassWindow.data.get((int)event).eta[HInvariantMassWindow.data.get((int)event).trackCounter] = SimMuonTracks.getEta(pickedTrackIndex);
        } else if (pickedTrackGroup.equals("Jet")) {
            AJetData JetTracks = currentEvent.getJetData();
            HInvariantMassWindow.data.get((int)event).Pt[HInvariantMassWindow.data.get((int)event).trackCounter] = JetTracks.getET(pickedTrackIndex);
            HInvariantMassWindow.data.get((int)event).P[HInvariantMassWindow.data.get((int)event).trackCounter] = Math.abs((double)JetTracks.getET(pickedTrackIndex) / Math.cos(AMath.lambda(JetTracks.getEta(pickedTrackIndex))));
            HInvariantMassWindow.data.get((int)event).phi[HInvariantMassWindow.data.get((int)event).trackCounter] = HUtilities.changePhiRange(JetTracks.getPhi(pickedTrackIndex));
            HInvariantMassWindow.data.get((int)event).Tl[HInvariantMassWindow.data.get((int)event).trackCounter] = 1.0 / Math.tan(2.0 * Math.atan(Math.exp(-JetTracks.getEta(pickedTrackIndex))));
            HInvariantMassWindow.data.get((int)event).eta[HInvariantMassWindow.data.get((int)event).trackCounter] = JetTracks.getEta(pickedTrackIndex);
        } else if (pickedTrackGroup.equals("Electron")) {
            AElectronData ElectronTracks = (AElectronData)currentEvent.get("Electron" + pickedTrackName);
            HInvariantMassWindow.data.get((int)event).Pt[HInvariantMassWindow.data.get((int)event).trackCounter] = ElectronTracks.getPT(pickedTrackIndex);
            HInvariantMassWindow.data.get((int)event).P[HInvariantMassWindow.data.get((int)event).trackCounter] = Math.abs((double)ElectronTracks.getPT(pickedTrackIndex) / Math.cos(AMath.lambda(ElectronTracks.getEta(pickedTrackIndex))));
            HInvariantMassWindow.data.get((int)event).phi[HInvariantMassWindow.data.get((int)event).trackCounter] = HUtilities.changePhiRange(ElectronTracks.getPhi(pickedTrackIndex));
            HInvariantMassWindow.data.get((int)event).Tl[HInvariantMassWindow.data.get((int)event).trackCounter] = 1.0 / Math.tan(2.0 * Math.atan(Math.exp(-ElectronTracks.getEta(pickedTrackIndex))));
            HInvariantMassWindow.data.get((int)event).eta[HInvariantMassWindow.data.get((int)event).trackCounter] = ElectronTracks.getEta(pickedTrackIndex);
        } else if (pickedTrackGroup.equals("Muon")) {
            AMuonData ObjectMuonTracks = (AMuonData)currentEvent.get("Muon" + pickedTrackName);
            HInvariantMassWindow.data.get((int)event).Pt[HInvariantMassWindow.data.get((int)event).trackCounter] = ObjectMuonTracks.getPT(pickedTrackIndex);
            HInvariantMassWindow.data.get((int)event).P[HInvariantMassWindow.data.get((int)event).trackCounter] = Math.abs((double)ObjectMuonTracks.getPT(pickedTrackIndex) / Math.cos(AMath.lambda(ObjectMuonTracks.getEta(pickedTrackIndex))));
            HInvariantMassWindow.data.get((int)event).phi[HInvariantMassWindow.data.get((int)event).trackCounter] = HUtilities.changePhiRange(ObjectMuonTracks.getPhi(pickedTrackIndex));
            HInvariantMassWindow.data.get((int)event).Tl[HInvariantMassWindow.data.get((int)event).trackCounter] = 1.0 / Math.tan(2.0 * Math.atan(Math.exp(-ObjectMuonTracks.getEta(pickedTrackIndex))));
            HInvariantMassWindow.data.get((int)event).eta[HInvariantMassWindow.data.get((int)event).trackCounter] = ObjectMuonTracks.getEta(pickedTrackIndex);
        }
        ++HInvariantMassWindow.data.get((int)event).trackCounter;
        data.get(event).calculate();
        HInvariantMassWindow.repaintTable();
    }

    public static void deleteTrack() {
        int select = invariantMassTable.getSelectedRow();
        int trackCounter = 0;
        for (int i = 0; i < data.size(); ++i) {
            for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                if (select == trackCounter) {
                    if (HInvariantMassWindow.data.get((int)i).trackCounter > 1) {
                        for (int k = 0; k < HInvariantMassWindow.data.get((int)i).trackCounter - 1; ++k) {
                            if (k < j) continue;
                            HInvariantMassWindow.data.get((int)i).trackGroup[k] = HInvariantMassWindow.data.get((int)i).trackGroup[k + 1];
                            HInvariantMassWindow.data.get((int)i).trackIndex[k] = HInvariantMassWindow.data.get((int)i).trackIndex[k + 1];
                            HInvariantMassWindow.data.get((int)i).trackName[k] = HInvariantMassWindow.data.get((int)i).trackName[k + 1];
                            HInvariantMassWindow.data.get((int)i).P[k] = HInvariantMassWindow.data.get((int)i).P[k + 1];
                            HInvariantMassWindow.data.get((int)i).Pt[k] = HInvariantMassWindow.data.get((int)i).Pt[k + 1];
                            HInvariantMassWindow.data.get((int)i).phi[k] = HInvariantMassWindow.data.get((int)i).phi[k + 1];
                            HInvariantMassWindow.data.get((int)i).Tl[k] = HInvariantMassWindow.data.get((int)i).Tl[k + 1];
                            HInvariantMassWindow.data.get((int)i).eta[k] = HInvariantMassWindow.data.get((int)i).eta[k + 1];
                            HInvariantMassWindow.data.get((int)i).particleType[k] = HInvariantMassWindow.data.get((int)i).particleType[k + 1];
                        }
                        --HInvariantMassWindow.data.get((int)i).trackCounter;
                        data.get(i).calculate();
                    } else {
                        data.remove(i);
                    }
                    HInvariantMassWindow.repaintTable();
                    return;
                }
                ++trackCounter;
            }
        }
    }

    public static void findTrack() {
        int trackCounter = 0;
        currentEvent = Atlantis.getEventManager().getCurrentEvent();
        invariantMassTable.getSelectionModel().removeSelectionInterval(invariantMassTable.getSelectedRow(), invariantMassTable.getSelectedRow());
        for (int i = 0; i < data.size(); ++i) {
            if (Atlantis.getEventManager().getEventSource().getSourceName().equals(HInvariantMassWindow.data.get((int)i).sourceName) && Atlantis.getEventManager().getCurrentEvent().getSourceName().equals(HInvariantMassWindow.data.get((int)i).eventName)) {
                for (int j = trackCounter + HInvariantMassWindow.data.get((int)i).trackCounter; j >= trackCounter; --j) {
                    invariantMassTable.scrollRectToVisible(invariantMassTable.getCellRect(j, 0, true));
                }
                if (APickingGraphics2D.getPickedData() != null) {
                    int pickedDataIndex = APickingGraphics2D.getPickedHitIndex();
                    String pickedDataName = APickingGraphics2D.getPickedData().getStoreGateKey();
                    if (pickedDataName == null) {
                        pickedDataName = APickingGraphics2D.getPickedData().getNameScreenName();
                    }
                    HInvariantMassWindow.findTrackInEvent(pickedDataName, pickedDataIndex);
                }
                return;
            }
            trackCounter += HInvariantMassWindow.data.get((int)i).trackCounter;
        }
        invariantMassTable.scrollRectToVisible(invariantMassTable.getCellRect(invariantMassTable.getRowCount() - 1, 0, true));
    }

    private static void findTrackInEvent(String track, int index) {
        int trackCounter = 0;
        currentEvent = Atlantis.getEventManager().getCurrentEvent();
        for (int i = 0; i < data.size(); ++i) {
            if (Atlantis.getEventManager().getEventSource().getSourceName().equals(HInvariantMassWindow.data.get((int)i).sourceName) && Atlantis.getEventManager().getCurrentEvent().getSourceName().equals(HInvariantMassWindow.data.get((int)i).eventName)) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    if (!HInvariantMassWindow.data.get((int)i).trackName[j].equals(track) || HInvariantMassWindow.data.get((int)i).trackIndex[j] != index) continue;
                    invariantMassTable.getSelectionModel().setSelectionInterval(trackCounter + j, trackCounter + j);
                    return;
                }
            }
            trackCounter += HInvariantMassWindow.data.get((int)i).trackCounter;
        }
    }

    public static void ETMisHistogram() {
        if (data.size() > 0) {
            double[] histData = new double[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                histData[i] = HInvariantMassWindow.data.get((int)i).ETMis;
            }
            HHistogram.drawDoubleDataHistogram("ETMis [Gev]", histData, data.size(), 50);
            histogram.setVisible(true);
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void PHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    histData[counter] = HInvariantMassWindow.data.get((int)i).P[j];
                    ++counter;
                }
            }
            HHistogram.drawDoubleDataHistogram("P [Gev]", histData, counter, 50);
            histogram.setVisible(true);
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void PtHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    histData[counter] = HInvariantMassWindow.data.get((int)i).Pt[j];
                    ++counter;
                }
            }
            HHistogram.drawDoubleDataHistogram("Pt [Gev]", histData, counter, 50);
            histogram.setVisible(true);
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void PhiHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    histData[counter] = HInvariantMassWindow.data.get((int)i).phi[j];
                    ++counter;
                }
            }
            HHistogram.drawDoubleDataHistogram("\u03c6", histData, counter, 50);
            histogram.setVisible(true);
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void EtaHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    histData[counter] = HInvariantMassWindow.data.get((int)i).eta[j];
                    ++counter;
                }
            }
            HHistogram.drawDoubleDataHistogram("\u03b7", histData, counter, 50);
            histogram.setVisible(true);
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void TlHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    histData[counter] = HInvariantMassWindow.data.get((int)i).Tl[j];
                    ++counter;
                }
            }
            HHistogram.drawDoubleDataHistogram("cot \u03b8", histData, counter, 50);
            histogram.setVisible(true);
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void MlvHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                    histData[counter] = HInvariantMassWindow.data.get((int)i).Mlv[j];
                    ++counter;
                }
            }
            HHistogram.drawDoubleDataHistogram("M(lv) [GeV]", histData, counter, 50);
            histogram.setVisible(true);
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void MllHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter / 2; ++j) {
                    if (HInvariantMassWindow.data.get((int)i).Mll[j] == -1.0) continue;
                    histData[counter] = HInvariantMassWindow.data.get((int)i).Mll[j];
                    ++counter;
                }
            }
            if (counter > 0) {
                HHistogram.drawDoubleDataHistogram("M(ll) [GeV]", histData, counter, 50);
                histogram.setVisible(true);
            } else {
                AExceptionHandler.processException("warning", MESSAGE_TWO_TRACKS);
            }
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void MllllHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                if (HInvariantMassWindow.data.get((int)i).trackCounter != 4 || HInvariantMassWindow.data.get((int)i).Mllll == -1.0) continue;
                histData[counter] = HInvariantMassWindow.data.get((int)i).Mllll;
                ++counter;
            }
            if (counter > 0) {
                HHistogram.drawDoubleDataHistogram("M(llll) [GeV]", histData, counter, 50);
                histogram.setVisible(true);
            } else {
                AExceptionHandler.processException("warning", MESSAGE_FOUR_TRACKS);
            }
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void MeeHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter / 2; ++j) {
                    if (!HInvariantMassWindow.data.get((int)i).particleType[2 * j].equals("e") || HInvariantMassWindow.data.get((int)i).Mll[j] == -1.0) continue;
                    histData[counter] = HInvariantMassWindow.data.get((int)i).Mll[j];
                    ++counter;
                }
            }
            if (counter > 0) {
                HHistogram.drawDoubleDataHistogram("M(ee) [GeV]", histData, counter, 50);
                histogram.setVisible(true);
            } else {
                AExceptionHandler.processException("warning", MESSAGE_TWO_TRACKS);
            }
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static void MmmHistogram() {
        int counter = 0;
        if (data.size() > 0) {
            double[] histData = new double[4 * data.size()];
            for (int i = 0; i < data.size(); ++i) {
                for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter / 2; ++j) {
                    if (!HInvariantMassWindow.data.get((int)i).particleType[2 * j].equals("\u03bc") || HInvariantMassWindow.data.get((int)i).Mll[j] == -1.0) continue;
                    histData[counter] = HInvariantMassWindow.data.get((int)i).Mll[j];
                    ++counter;
                }
            }
            if (counter > 0) {
                HHistogram.drawDoubleDataHistogram("M(\u03bc\u03bc) [GeV]", histData, counter, 50);
                histogram.setVisible(true);
            } else {
                AExceptionHandler.processException("warning", MESSAGE_TWO_TRACKS);
            }
        } else {
            AExceptionHandler.processException("warning", MESSAGE_ONE_TRACK);
        }
    }

    public static ArrayList<HData> getData() {
        return data;
    }

    public static void clearInvariantMassTable() {
        if (data.size() > 0) {
            data.clear();
            HInvariantMassWindow.repaintTable();
            AExceptionHandler.processException("info", "Invariant Mass Table is empty.");
        } else {
            AExceptionHandler.processException("warning", "Invariant Mass Table is empty.");
        }
    }

    public static void saveHypatiaProject(BufferedWriter out) throws IOException {
        for (int i = 0; i < data.size(); ++i) {
            out.write(HInvariantMassWindow.data.get((int)i).sourceName);
            out.newLine();
            out.write(HInvariantMassWindow.data.get((int)i).eventName);
            out.newLine();
            out.write(Integer.toString(HInvariantMassWindow.data.get((int)i).eventNumber));
            out.newLine();
            out.write(Integer.toString(HInvariantMassWindow.data.get((int)i).runNumber));
            out.newLine();
            out.write(HInvariantMassWindow.data.get((int)i).ETMis + " " + HInvariantMassWindow.data.get((int)i).ETMisX + " " + HInvariantMassWindow.data.get((int)i).ETMisY + " ");
            out.newLine();
            out.write(HInvariantMassWindow.data.get((int)i).trackCounter + " ");
            for (int j = 0; j < HInvariantMassWindow.data.get((int)i).trackCounter; ++j) {
                out.newLine();
                out.write(HInvariantMassWindow.data.get((int)i).trackGroup[j] + " " + HInvariantMassWindow.data.get((int)i).trackName[j] + " " + HInvariantMassWindow.data.get((int)i).trackIndex[j] + " " + HInvariantMassWindow.data.get((int)i).P[j] + " " + HInvariantMassWindow.data.get((int)i).Pt[j] + " " + HInvariantMassWindow.data.get((int)i).phi[j] + " " + HInvariantMassWindow.data.get((int)i).Pt[j] + " " + HInvariantMassWindow.data.get((int)i).Tl[j] + " " + HInvariantMassWindow.data.get((int)i).eta[j] + " " + HInvariantMassWindow.data.get((int)i).particleType[j]);
            }
            out.newLine();
        }
    }

    public static void loadHypatiaProject(BufferedReader in) throws IOException {
        String line;
        Object Pathname = null;
        Object Filename = null;
        Object fname = null;
        String fsep = File.separator;
        Object tname = null;
        HInvariantMassWindow.clearInvariantMassTable();
        while ((line = in.readLine()) != null) {
            HData hData = new HData();
            hData.sourceName = line;
            hData.eventName = line = in.readLine();
            line = in.readLine();
            hData.eventNumber = Integer.parseInt(line);
            line = in.readLine();
            hData.runNumber = Integer.parseInt(line);
            line = in.readLine();
            hData.ETMis = Float.parseFloat(line.split(" ")[0]);
            hData.ETMisX = Float.parseFloat(line.split(" ")[1]);
            hData.ETMisY = Float.parseFloat(line.split(" ")[2]);
            line = in.readLine();
            hData.trackCounter = Integer.parseInt(line.split(" ")[0]);
            for (int j = 0; j < hData.trackCounter; ++j) {
                line = in.readLine();
                hData.trackGroup[j] = line.split(" ")[0];
                hData.trackName[j] = line.split(" ")[1];
                hData.trackIndex[j] = Integer.parseInt(line.split(" ")[2]);
                hData.P[j] = Double.parseDouble(line.split(" ")[3]);
                hData.Pt[j] = Double.parseDouble(line.split(" ")[4]);
                hData.phi[j] = Double.parseDouble(line.split(" ")[5]);
                hData.Pt[j] = Double.parseDouble(line.split(" ")[6]);
                hData.Tl[j] = Double.parseDouble(line.split(" ")[7]);
                hData.eta[j] = Double.parseDouble(line.split(" ")[8]);
                hData.particleType[j] = line.split(" ")[9];
                hData.calculate();
            }
            data.add(hData);
        }
        if (data.size() > 0) {
            try {
                if (HInvariantMassWindow.data.get((int)(HInvariantMassWindow.data.size() - 1)).sourceName.endsWith(".zip")) {
                    Atlantis.getEventManager().setEventSource("file://" + HInvariantMassWindow.data.get((int)(HInvariantMassWindow.data.size() - 1)).sourceName);
                } else {
                    Atlantis.getEventManager().setEventSource("file://" + HInvariantMassWindow.data.get((int)(HInvariantMassWindow.data.size() - 1)).sourceName + System.getProperty("file.separator") + HInvariantMassWindow.data.get((int)(HInvariantMassWindow.data.size() - 1)).eventName);
                }
                Atlantis.getEventManager().nextEvent();
            }
            catch (AEventSource.InvalidEventSourceException e) {
                e.printStackTrace();
            }
            catch (AEventSource.NoMoreEventsException e) {
                e.printStackTrace();
            }
            catch (AEventSource.ReadEventException e) {
                e.printStackTrace();
            }
        }
        HInvariantMassWindow.repaintTable();
    }

    static {
        columnToolTips = new String[]{"Event file name", "Missing Energy", "Track name", "Momentum", "Charge", "Transverse momentum", "Track angle \u03a6", "Track angle \u03b7", "Invariant mass of Track + ETMiss", "Invariant mass of 2 tracks", "Invariant mass of all 4 tracks", "Particle kind. Either electron or muon"};
    }
}

