/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

import atlantis.canvas.ACanvas;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.parameters.ACutParameter;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.AUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HSimplifiedControlWindow
extends JFrame {
    private static HSimplifiedControlWindow instance;
    private static JPanel parametersPanel;
    private static JPanel projectionPanel;
    private static ButtonGroup projectionGroup;
    private static JRadioButton projectionYXButton;
    private static JRadioButton projectionrhoZButton;
    private static JPanel interactionPanel;
    private static ButtonGroup interactionGroup;
    private static JRadioButton interactionZMRButton;
    private static JRadioButton interactionPickButton;
    private static JPanel cutPanel;
    private static JPanel cutPtPanel;
    private static JPanel cutD0Panel;
    private static JPanel cutZ0Panel;
    private static JCheckBox cutPtCheckBox;
    private static JLabel cutPtLabel;
    private static JTextField cutPtTextField;
    private static JLabel cutPtType;
    private static JCheckBox cutD0CheckBox;
    private static JLabel cutD0Label;
    private static JTextField cutD0TextField;
    private static JLabel cutD0Type;
    private static JCheckBox cutZ0CheckBox;
    private static JLabel cutZ0Label;
    private static JTextField cutZ0TextField;
    private static JLabel cutZ0Type;
    private static ACutParameter Pt;
    private static ACutParameter D0;
    private static ACutParameter Z0;

    public HSimplifiedControlWindow() {
        super("HYPATIA - Simplified Control Window");
        AUtilities.setIconImage(this);
        instance = this;
        parametersPanel = new JPanel();
        projectionPanel = new JPanel();
        projectionGroup = new ButtonGroup();
        projectionYXButton = new JRadioButton();
        projectionrhoZButton = new JRadioButton();
        interactionPanel = new JPanel();
        interactionGroup = new ButtonGroup();
        interactionZMRButton = new JRadioButton();
        interactionPickButton = new JRadioButton();
        cutPanel = new JPanel();
        cutPtPanel = new JPanel();
        cutD0Panel = new JPanel();
        cutZ0Panel = new JPanel();
        cutPtCheckBox = new JCheckBox();
        cutPtLabel = new JLabel();
        cutPtTextField = new JTextField(3);
        cutPtType = new JLabel("GeV");
        cutD0CheckBox = new JCheckBox();
        cutD0Label = new JLabel();
        cutD0TextField = new JTextField(3);
        cutD0Type = new JLabel("cm");
        cutZ0CheckBox = new JCheckBox();
        cutZ0Label = new JLabel();
        cutZ0TextField = new JTextField(3);
        cutZ0Type = new JLabel("cm");
        this.setLayout(new BorderLayout());
        parametersPanel.setLayout(new GridLayout(0, 3));
        projectionPanel.setBorder(BorderFactory.createTitledBorder("Projection"));
        projectionPanel.setLayout(new GridLayout(0, 2));
        projectionYXButton.setText("End-View");
        projectionrhoZButton.setText("Side-View");
        projectionPanel.add(projectionYXButton);
        projectionPanel.add(projectionrhoZButton);
        projectionGroup.add(projectionYXButton);
        projectionGroup.add(projectionrhoZButton);
        projectionYXButton.setSelected(true);
        projectionYXButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HSimplifiedControlWindow.applyProjectionAndInteractionChanges();
            }
        });
        interactionPanel.setBorder(BorderFactory.createTitledBorder("Interaction"));
        interactionPanel.setLayout(new GridLayout(0, 2));
        interactionZMRButton.setText("Zoom");
        interactionPickButton.setText("Pick");
        interactionPanel.add(interactionZMRButton);
        interactionPanel.add(interactionPickButton);
        interactionGroup.add(interactionZMRButton);
        interactionGroup.add(interactionPickButton);
        interactionZMRButton.setSelected(true);
        interactionZMRButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HSimplifiedControlWindow.applyProjectionAndInteractionChanges();
            }
        });
        cutPanel.setBorder(BorderFactory.createTitledBorder("Cut"));
        Pt = (ACutParameter)APar.get("CutsInDet", "Pt");
        if (!Pt.isInitialized()) {
            Pt.initialize();
        }
        cutPtCheckBox.setText("|Pt|");
        cutPtCheckBox.setSelected(true);
        Pt.setStatus(cutPtCheckBox.isSelected());
        cutPtCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Pt.setStatus(cutPtCheckBox.isSelected());
                ACanvas.getCanvas().repaintAllFromScratch();
                HTrackMomentaWindow.refresh();
            }
        });
        cutPtPanel.add(cutPtCheckBox);
        cutPtLabel.setText(Pt.getOperator());
        cutPtLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (cutPtLabel.getText().equals(">")) {
                    Pt._setOperator("<");
                } else {
                    Pt._setOperator(">");
                }
                cutPtLabel.setText(Pt.getOperator());
                ACanvas.getCanvas().repaintAllFromScratch();
                HTrackMomentaWindow.refresh();
            }
        });
        cutPtPanel.add(cutPtLabel);
        cutPtTextField.setText(Pt.getValue());
        cutPtPanel.add(cutPtTextField);
        cutPtTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                String value = Pt.getValue();
                if (evt.getKeyCode() == 10) {
                    cutPtTextField.setFocusable(false);
                    try {
                        Pt._setValue(Double.parseDouble(cutPtTextField.getText()));
                        ACanvas.getCanvas().repaintAllFromScratch();
                        HTrackMomentaWindow.refresh();
                    }
                    catch (NumberFormatException nfe) {
                        cutPtTextField.setText(value);
                    }
                    cutPtTextField.setFocusable(true);
                }
            }
        });
        cutPtPanel.add(cutPtType);
        cutPanel.add(cutPtPanel);
        D0 = (ACutParameter)APar.get("CutsInDet", "d0");
        if (!D0.isInitialized()) {
            D0.initialize();
        }
        cutD0CheckBox.setText("|D0|");
        cutD0CheckBox.setSelected(true);
        D0.setStatus(cutD0CheckBox.isSelected());
        cutD0CheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                D0.setStatus(cutD0CheckBox.isSelected());
                ACanvas.getCanvas().repaintAllFromScratch();
                HTrackMomentaWindow.refresh();
            }
        });
        cutD0Panel.add(cutD0CheckBox);
        cutD0Label.setText(D0.getOperator());
        cutD0Label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (cutD0Label.getText().equals(">")) {
                    D0._setOperator("<");
                } else {
                    D0._setOperator(">");
                }
                cutD0Label.setText(D0.getOperator());
                ACanvas.getCanvas().repaintAllFromScratch();
                HTrackMomentaWindow.refresh();
            }
        });
        cutD0Panel.add(cutD0Label);
        cutD0TextField.setText(D0.getValue());
        cutD0Panel.add(cutD0TextField);
        cutD0TextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                String value = D0.getValue();
                if (evt.getKeyCode() == 10) {
                    cutD0TextField.setFocusable(false);
                    try {
                        D0._setValue(Double.parseDouble(cutD0TextField.getText()));
                        ACanvas.getCanvas().repaintAllFromScratch();
                        HTrackMomentaWindow.refresh();
                    }
                    catch (NumberFormatException nfe) {
                        cutD0TextField.setText(value);
                    }
                    cutD0TextField.setFocusable(true);
                }
            }
        });
        cutD0Panel.add(cutD0Type);
        cutPanel.add(cutD0Panel);
        Z0 = (ACutParameter)APar.get("CutsInDet", "z0");
        if (!Z0.isInitialized()) {
            Z0.initialize();
        }
        cutZ0CheckBox.setText("|Z0|");
        cutZ0CheckBox.setSelected(true);
        Z0.setStatus(cutZ0CheckBox.isSelected());
        cutZ0CheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Z0.setStatus(cutZ0CheckBox.isSelected());
                ACanvas.getCanvas().repaintAllFromScratch();
                HTrackMomentaWindow.refresh();
            }
        });
        cutZ0Panel.add(cutZ0CheckBox);
        cutZ0Label.setText(Z0.getOperator());
        cutZ0Label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (cutZ0Label.getText().equals(">")) {
                    Z0._setOperator("<");
                } else {
                    Z0._setOperator(">");
                }
                cutZ0Label.setText(Z0.getOperator());
                ACanvas.getCanvas().repaintAllFromScratch();
                HTrackMomentaWindow.refresh();
            }
        });
        cutZ0Panel.add(cutZ0Label);
        cutZ0TextField.setText(Z0.getValue());
        cutZ0Panel.add(cutZ0TextField);
        cutZ0TextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                String value = Z0.getValue();
                if (evt.getKeyCode() == 10) {
                    cutZ0TextField.setFocusable(false);
                    try {
                        Z0._setValue(Double.parseDouble(cutZ0TextField.getText()));
                        ACanvas.getCanvas().repaintAllFromScratch();
                        HTrackMomentaWindow.refresh();
                    }
                    catch (NumberFormatException nfe) {
                        cutZ0TextField.setText(value);
                    }
                    cutZ0TextField.setFocusable(true);
                }
            }
        });
        cutZ0Panel.add(cutZ0Type);
        cutPanel.add(cutZ0Panel);
        parametersPanel.add(projectionPanel);
        parametersPanel.add(interactionPanel);
        parametersPanel.add(cutPanel);
        this.add((Component)parametersPanel, "Center");
    }

    public static void applyProjectionAndInteractionChanges() {
        AProjection p = projectionYXButton.isSelected() ? AProjectionsManager.getProjection("YX") : AProjectionsManager.getProjection("RZ");
        ACanvas.getCanvas().getCurrentWindow().setProjection(p);
        if (interactionZMRButton.isSelected()) {
            ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar().setSelectedGroup("ZMR");
        } else {
            ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar().setSelectedGroup("Pick");
        }
    }

    public static HSimplifiedControlWindow getGUI() {
        return instance;
    }
}

