/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.data.AETMisData;
import atlantis.data.AElectronData;
import atlantis.data.AJetData;
import atlantis.data.AMuonData;
import atlantis.data.AMuonTrackData;
import atlantis.data.ASMTrData;
import atlantis.data.ASNPData;
import atlantis.data.ASTrData;
import atlantis.data.ATrackData;
import atlantis.event.AEvent;
import atlantis.event.AEventSource;
import atlantis.graphics.APickingGraphics2D;
import atlantis.gui.AEventSourceToolBar;
import atlantis.gui.AExceptionHandler;
import atlantis.gui.AFileControl;
import atlantis.hypatia.HControlWindow;
import atlantis.hypatia.HDemoWindow;
import atlantis.hypatia.HInvariantMassWindow;
import atlantis.hypatia.HTrackColor;
import atlantis.hypatia.HUtilities;
import atlantis.list.AList;
import atlantis.list.AListManager;
import atlantis.parameters.AEnumeratorParameter;
import atlantis.parameters.APar;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class HTrackMomentaWindow
extends JFrame {
    private static final double LEAST_SQUARES_MIN_VALUE = 0.01;
    private static HTrackMomentaWindow instance;
    private static AEvent currentEvent;
    private static JLabel currentEventETMis;
    private static JPanel secondaryMenuPanel;
    private static JPanel infoPanel;
    private static JPanel trackColorInfoPanel;
    private static JPanel windowPanel;
    private static JCheckBoxMenuItem hideInvariantMassWindowCheckBox;
    private static JCheckBoxMenuItem simplifiedControlPanelCheckBox;
    private static JCheckBoxMenuItem hideSimulatedCheckBox;
    private static JMenuBar menuBar;
    private static JButton insertElectronButton;
    private static JButton insertMuonButton;
    private static JButton deleteButton;
    private static JButton forwardButton;
    private static JButton backButton;
    private static JButton resetViewButton;
    static final String REC_TABBEDPANE = "<html><body leftmargin=95 marginwidth=95>Reconstructed Tracks</body></html>";
    static final String REC_TRACKS = "<html><body marginheight=-10></body></html>";
    static final String RECMUON_TRACKS = "RecMuonTracks";
    static final String SIM_TABBEDPANE = "Simulated";
    static final String SIM_TRACKS = "SimTracks";
    static final String SIMMUON_TRACKS = "SimMuonTracks";
    static final String SIMNEUTRAL_TRACKS = "SimNeutralTracks";
    static final String OBJ_TABBEDPANE = "Physics Objects";
    static final String OBJ_JETS = "Jets";
    static final String OBJ_ELECTRONS = "Electrons";
    static final String OBJ_MUONS = "Muons";
    private static ATrackData recTracks;
    private static DefaultTableModel recTracksTableModel;
    private static JTable recTracksTable;
    private static JScrollPane recTracksScrollPane;
    private static AMuonTrackData recMuonTracks;
    private static DefaultTableModel recMuonTracksTableModel;
    private static JTable recMuonTracksTable;
    private static JScrollPane recMuonTracksScrollPane;
    private static AElectronData ElectronTracks;
    private static AMuonData MuonTracks;
    private static ASTrData simTracks;
    private static DefaultTableModel simTracksTableModel;
    private static JTable simTracksTable;
    private static JScrollPane simTracksScrollPane;
    private static ASMTrData simMuonTracks;
    private static DefaultTableModel simMuonTracksTableModel;
    private static JTable simMuonTracksTable;
    private static JScrollPane simMuonTracksScrollPane;
    private static ASNPData simNeutralTracks;
    private static DefaultTableModel simNeutralTracksTableModel;
    private static JTable simNeutralTracksTable;
    private static JScrollPane simNeutralTracksScrollPane;
    private static JCheckBoxMenuItem trackColorCheckBox;
    private static JCheckBoxMenuItem demoCheckBox;
    static int DemoDelay;
    static Timer timer;
    private static AJetData objJets;
    private static DefaultTableModel objJetsTableModel;
    private static JTable objJetsTable;
    private static JScrollPane objJetsScrollPane;
    private static AElectronData objElectrons;
    private static DefaultTableModel objElectronsTableModel;
    private static JTable objElectronsTable;
    private static JScrollPane objElectronsScrollPane;
    private static AMuonData objMuons;
    private static DefaultTableModel objMuonsTableModel;
    private static JTable objMuonsTable;
    private static JScrollPane objMuonsScrollPane;
    private static JTabbedPane mainTabbedPane;
    private static JTabbedPane recTabbedPane;
    private static JTabbedPane simTabbedPane;
    private static JTabbedPane objTabbedPane;
    public static AEventSourceToolBar toolBar;
    private static final ALogger logger;

    public HTrackMomentaWindow() {
        super("HYPATIA - Track Momenta Window");
        this.setDefaultCloseOperation(3);
        AUtilities.setIconImage(this);
        instance = this;
        JMenuBar menuBar = this.constructAndGetMenuBar();
        this.setJMenuBar(menuBar);
        windowPanel = new JPanel();
        windowPanel.setLayout(new BoxLayout(windowPanel, 0));
        hideInvariantMassWindowCheckBox = new JCheckBoxMenuItem(" Hide Invariant Mass Window     ");
        hideInvariantMassWindowCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Atlantis.showInvariantMassWindow(false);
                    insertElectronButton.setVisible(false);
                    insertMuonButton.setVisible(false);
                    deleteButton.setVisible(false);
                } else {
                    Atlantis.showInvariantMassWindow(true);
                    insertElectronButton.setVisible(true);
                    insertMuonButton.setVisible(true);
                    deleteButton.setVisible(true);
                }
            }
        });
        hideInvariantMassWindowCheckBox.setBorder(null);
        windowPanel.add(hideInvariantMassWindowCheckBox);
        simplifiedControlPanelCheckBox = new JCheckBoxMenuItem(" Simplified Control Panel     ");
        simplifiedControlPanelCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Atlantis.showSimplifiedControlPanel(true);
                } else {
                    Atlantis.showSimplifiedControlPanel(false);
                }
            }
        });
        simplifiedControlPanelCheckBox.setBorder(null);
        hideSimulatedCheckBox = new JCheckBoxMenuItem(" Hide Simulated   ");
        hideSimulatedCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    mainTabbedPane.remove(simTabbedPane);
                    mainTabbedPane.remove(objTabbedPane);
                } else {
                    mainTabbedPane.add(HTrackMomentaWindow.SIM_TRACKS, simTabbedPane);
                    mainTabbedPane.add(HTrackMomentaWindow.OBJ_TABBEDPANE, objTabbedPane);
                }
            }
        });
        hideSimulatedCheckBox.setBorder(null);
        windowPanel.add(hideSimulatedCheckBox);
        demoCheckBox = new JCheckBoxMenuItem(" Demo Mode     ");
        demoCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    HDemoWindow.ShowWindow();
                    ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar().setSelectedGroup("Pick");
                } else if (timer != null && timer.isRunning()) {
                    timer.stop();
                }
                try {
                    Atlantis.getEventManager().getEventSource().setNavigationMode(AEventSource.NavigationMode.SEQUENTIAL);
                }
                catch (Exception ex) {
                    logger.warn("Error settings event navigation mode to sequential : " + ex.getMessage());
                }
            }
        });
        demoCheckBox.setBorder(null);
        windowPanel.add(demoCheckBox);
        secondaryMenuPanel = new JPanel();
        secondaryMenuPanel.setLayout(new BoxLayout(secondaryMenuPanel, 1));
        ACanvas.getCanvas().getATitle().setName(" File: n/a  Run: n/a  Event: n/a");
        infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        currentEventETMis = new JLabel("ETMiss : n/a");
        currentEventETMis.setFont(new Font("Courier", 1, 12));
        infoPanel.add(currentEventETMis);
        trackColorCheckBox.setBorder(null);
        toolBar = new AEventSourceToolBar();
        secondaryMenuPanel.add(infoPanel);
        secondaryMenuPanel.add(toolBar);
        secondaryMenuPanel.setBorder(BorderFactory.createEtchedBorder(0));
        Atlantis.getEventManager().addNewEventSourceListener(toolBar);
        trackColorInfoPanel = new JPanel(new GridLayout(1, 6, 0, 0));
        trackColorInfoPanel.add(HTrackColor.getElectronLabel());
        trackColorInfoPanel.add(HTrackColor.getMuonLabel());
        trackColorInfoPanel.add(HTrackColor.getPhotonLabel());
        trackColorInfoPanel.add(HTrackColor.getNeutrinoLabel());
        trackColorInfoPanel.add(HTrackColor.getOtherNeutralLabel());
        trackColorInfoPanel.add(HTrackColor.getOtherChargedLabel());
        trackColorInfoPanel.add(HTrackColor.getUnresolvedLabel());
        if (trackColorCheckBox.isSelected()) {
            trackColorInfoPanel.setVisible(true);
        } else {
            trackColorInfoPanel.setVisible(false);
        }
        this.add((Component)secondaryMenuPanel, "North");
        this.add((Component)trackColorInfoPanel, "South");
        recTabbedPane = new JTabbedPane();
        HTrackMomentaWindow.initRecTracks();
        HTrackMomentaWindow.initRecMuonTracks();
        recTabbedPane.add(REC_TRACKS, recTracksScrollPane);
        simTabbedPane = new JTabbedPane();
        HTrackMomentaWindow.initSimTracks();
        HTrackMomentaWindow.initSimMuonTracks();
        HTrackMomentaWindow.initSimNeutralTracks();
        simTabbedPane.add(SIM_TRACKS, simTracksScrollPane);
        simTabbedPane.add(SIMMUON_TRACKS, simMuonTracksScrollPane);
        simTabbedPane.add(SIMNEUTRAL_TRACKS, simNeutralTracksScrollPane);
        objTabbedPane = new JTabbedPane();
        HTrackMomentaWindow.initObjJets();
        HTrackMomentaWindow.initObjElectrons();
        HTrackMomentaWindow.initObjMuons();
        objTabbedPane.add(OBJ_JETS, objJetsScrollPane);
        objTabbedPane.add(OBJ_ELECTRONS, objElectronsScrollPane);
        objTabbedPane.add(OBJ_MUONS, objMuonsScrollPane);
        mainTabbedPane = new JTabbedPane();
        mainTabbedPane.add(REC_TABBEDPANE, recTabbedPane);
        mainTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                APar.get("Data", "InDetTrack").setStatus(false);
                APar.get("Data", "MuonTrack").setStatus(false);
                APar.get("Data", "STr").setStatus(false);
                APar.get("Data", "SMTr").setStatus(false);
                APar.get("Data", "SNP").setStatus(false);
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                int selectedTab = pane.getSelectedIndex();
                block0 : switch (selectedTab) {
                    case 0: {
                        int recSelected = recTabbedPane.getSelectedIndex();
                        APar.get("Data", "InDetTrack").setStatus(true);
                        APar.get("Data", "MuonTrack").setStatus(true);
                        switch (recSelected) {
                            case 0: {
                                HTrackMomentaWindow.markSelectedRecTrack();
                                break;
                            }
                            case 1: {
                                HTrackMomentaWindow.markSelectedRecMuonTrack();
                            }
                        }
                        break;
                    }
                    case 1: {
                        int simSelected = simTabbedPane.getSelectedIndex();
                        APar.get("Data", "STr").setStatus(true);
                        APar.get("Data", "SMTr").setStatus(true);
                        APar.get("Data", "SNP").setStatus(true);
                        switch (simSelected) {
                            case 0: {
                                HTrackMomentaWindow.markSelectedSimTrack();
                                break;
                            }
                            case 1: {
                                HTrackMomentaWindow.markSelectedSimMuonTrack();
                                break;
                            }
                            case 2: {
                                HTrackMomentaWindow.markSelectedSimNeutralTrack();
                            }
                        }
                        break;
                    }
                    case 2: {
                        int objectsSelected = objTabbedPane.getSelectedIndex();
                        APar.get("Data", "InDetTrack").setStatus(true);
                        APar.get("Data", "MuonTrack").setStatus(true);
                        switch (objectsSelected) {
                            case 0: {
                                HTrackMomentaWindow.markSelectedJet();
                                break block0;
                            }
                            case 1: {
                                HTrackMomentaWindow.markSelectedElectron();
                                break block0;
                            }
                            case 2: {
                                HTrackMomentaWindow.markSelectedObjectMuon();
                            }
                        }
                    }
                }
            }
        });
        recTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                int recSelected = recTabbedPane.getSelectedIndex();
                switch (recSelected) {
                    case 0: {
                        APar.get("Data", "InDetTrack").setStatus(true);
                        HTrackMomentaWindow.markSelectedRecTrack();
                        break;
                    }
                    case 1: {
                        APar.get("Data", "MuonTrack").setStatus(true);
                        HTrackMomentaWindow.markSelectedRecMuonTrack();
                    }
                }
            }
        });
        simTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                int simSelected = simTabbedPane.getSelectedIndex();
                switch (simSelected) {
                    case 0: {
                        APar.get("Data", "STr").setStatus(true);
                        HTrackMomentaWindow.markSelectedSimTrack();
                        break;
                    }
                    case 1: {
                        APar.get("Data", "SMTr").setStatus(true);
                        HTrackMomentaWindow.markSelectedSimMuonTrack();
                        break;
                    }
                    case 2: {
                        APar.get("Data", "SNP").setStatus(true);
                        HTrackMomentaWindow.markSelectedSimNeutralTrack();
                    }
                }
            }
        });
        objTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                int objSelected = objTabbedPane.getSelectedIndex();
                switch (objSelected) {
                    case 0: {
                        HTrackMomentaWindow.markSelectedJet();
                        break;
                    }
                    case 1: {
                        HTrackMomentaWindow.markSelectedElectron();
                        break;
                    }
                    case 2: {
                        HTrackMomentaWindow.markSelectedObjectMuon();
                    }
                }
            }
        });
        this.add((Component)mainTabbedPane, "Center");
    }

    private JMenuBar constructAndGetMenuBar() {
        menuBar = new JMenuBar();
        menuBar.add(new AFileControl());
        backButton = new JButton("   Previous Event   ");
        backButton.setVerticalTextPosition(3);
        backButton.setHorizontalTextPosition(0);
        backButton.setIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "back.png"));
        backButton.setBorder(null);
        backButton.setToolTipText("Read previous event");
        backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Atlantis.getEventManager().previousEvent();
                }
                catch (AEventSource.NoMoreEventsException nme) {
                    String msg = "Already at first event from this source!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
                    logger.warn(nme.getCauseMessages());
                }
                catch (AEventSource.InvalidEventSourceException ies) {
                    String msg = "Not a valid event source - please select one!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
                    logger.warn(ies.getCauseMessages());
                }
                catch (AEventSource.ReadEventException ree) {
                    String msg = "Can not read event(s)!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
                    logger.warn(ree.getCauseMessages());
                }
            }
        });
        menuBar.add(backButton);
        forwardButton = new JButton("   Next Event  ");
        forwardButton.setVerticalTextPosition(3);
        forwardButton.setHorizontalTextPosition(0);
        forwardButton.setIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "forward.png"));
        forwardButton.setBorder(null);
        forwardButton.setToolTipText("Read next event");
        forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Atlantis.getEventManager().nextEvent();
                }
                catch (AEventSource.NoMoreEventsException nme) {
                    String msg = "Already at last event from this source!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "No more events", 0);
                    logger.warn(nme.getCauseMessages());
                }
                catch (AEventSource.InvalidEventSourceException ies) {
                    String msg = "Not a valid event source - please select one!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Invalid source", 0);
                    logger.warn(ies.getCauseMessages());
                }
                catch (AEventSource.ReadEventException ree) {
                    String msg = "Can not read event(s)!";
                    JOptionPane.showMessageDialog(HTrackMomentaWindow.getGUI(), msg, "Read error", 0);
                    logger.warn(ree.getCauseMessages());
                }
            }
        });
        menuBar.add(forwardButton);
        insertElectronButton = new JButton("   Insert Electron   ");
        insertElectronButton.setVerticalTextPosition(3);
        insertElectronButton.setHorizontalTextPosition(0);
        insertElectronButton.setIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "electron.png"));
        insertElectronButton.setBorder(null);
        insertElectronButton.setToolTipText("Insert selected electron track");
        insertElectronButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (APickingGraphics2D.getPickedData() != null) {
                    String trackGroup = APickingGraphics2D.getPickedData().getParameterGroup();
                    if (trackGroup.equals("InDetTrack") || trackGroup.equals("MuonTrack") || trackGroup.equals("STr") || trackGroup.equals("SMTr") || trackGroup.equals("Jet") || trackGroup.equals("Electron") || trackGroup.equals("Muon")) {
                        AEnumeratorParameter RecTracklistBox = (AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections");
                        String RecTrackSelectedKey = RecTracklistBox.getCurrentText();
                        ATrackData TempRecTracks = currentEvent.getTrackData("InDetTrack", RecTrackSelectedKey);
                        int RecTrackIndex = Integer.parseInt(recTracksTableModel.getValueAt(recTracksTable.getSelectedRow(), 0).toString().split(" ")[1]);
                        String particleType = e.getActionCommand().equals("   Insert Electron   ") ? "e" : "\u03bc";
                        HInvariantMassWindow.insertTrack(TempRecTracks.getStoreGateKey(), RecTrackIndex, AMath.getPFromPttL(TempRecTracks.getModifiableHelix((int)RecTrackIndex).pT, TempRecTracks.getModifiableHelix((int)RecTrackIndex).tL), TempRecTracks.getModifiableHelix((int)RecTrackIndex).pT, AMath.degreesToRadians(TempRecTracks.getModifiableHelix((int)RecTrackIndex).phi0), TempRecTracks.getModifiableHelix((int)RecTrackIndex).tL, TempRecTracks.getModifiableHelix((int)RecTrackIndex).eta, particleType);
                    } else {
                        AExceptionHandler.processException("Warning", "You can insert InDetTrack, STr, MuonTrack, SMTr, Jet, Electron and Object Muon tracks only.");
                    }
                } else {
                    AExceptionHandler.processException("Warning", "You should select some track first.");
                }
            }
        });
        menuBar.add(insertElectronButton);
        insertMuonButton = new JButton("   Insert Muon   ");
        insertMuonButton.setVerticalTextPosition(3);
        insertMuonButton.setHorizontalTextPosition(0);
        insertMuonButton.setIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "muon.png"));
        insertMuonButton.setBorder(null);
        insertMuonButton.setToolTipText("Insert selected muon track");
        insertMuonButton.addActionListener(insertElectronButton.getActionListeners()[0]);
        menuBar.add(insertMuonButton);
        deleteButton = new JButton("   Delete Track   ");
        deleteButton.setVerticalTextPosition(3);
        deleteButton.setHorizontalTextPosition(0);
        deleteButton.setIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "delete.png"));
        deleteButton.setBorder(null);
        deleteButton.setToolTipText("Delete selected track");
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (APickingGraphics2D.getPickedData() != null) {
                    HInvariantMassWindow.deleteTrack();
                } else {
                    AExceptionHandler.processException("warning", "You should select some track first.");
                }
            }
        });
        menuBar.add(deleteButton);
        trackColorCheckBox = new JCheckBoxMenuItem("Enable Color Coding");
        trackColorCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    trackColorInfoPanel.setVisible(true);
                } else {
                    trackColorInfoPanel.setVisible(false);
                }
            }
        });
        resetViewButton = new JButton("   Reset Canvas  ");
        resetViewButton.setVerticalTextPosition(3);
        resetViewButton.setHorizontalTextPosition(0);
        resetViewButton.setIcon(new ImageIcon(Atlantis.getHomeDirectory() + "img" + Atlantis.FILE_SEPAR + "reset.png"));
        resetViewButton.setToolTipText("Reset Canvas View");
        resetViewButton.setBorder(null);
        resetViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Atlantis.restoreDefaults();
            }
        });
        menuBar.add(resetViewButton);
        return menuBar;
    }

    private static void initRecTracks() {
        recTracksScrollPane = new JScrollPane();
        recTracksTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        recTracksTableModel.addColumn("Track");
        recTracksTableModel.addColumn("+/-");
        recTracksTableModel.addColumn("P [GeV]");
        recTracksTableModel.addColumn("Pt [GeV]");
        recTracksTableModel.addColumn("\u03c6");
        recTracksTableModel.addColumn("\u03b8");
        recTracksTable = new JTable(recTracksTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                int SimTracksTableEquivalent = -1;
                double RecTracksTableMinValue = Double.MAX_VALUE;
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                for (int i = 0; i < simTracksTable.getRowCount(); ++i) {
                    double LeastSquaresValue = Math.pow(Double.parseDouble(recTracksTable.getValueAt(rowIndex, 4).toString().replace(',', '.')) - Double.parseDouble(simTracksTable.getValueAt(i, 4).toString().replace(',', '.')), 2.0) + Math.pow(Double.parseDouble(recTracksTable.getValueAt(rowIndex, 5).toString().replace(',', '.')) - Double.parseDouble(simTracksTable.getValueAt(i, 5).toString().replace(',', '.')), 2.0);
                    if (!(LeastSquaresValue < RecTracksTableMinValue)) continue;
                    SimTracksTableEquivalent = i;
                    RecTracksTableMinValue = LeastSquaresValue;
                }
                if (recTracksTable.getSelectedRow() == rowIndex) {
                    if (Math.sqrt(RecTracksTableMinValue) <= 0.4 && SimTracksTableEquivalent >= 0) {
                        simTracksTable.setRowSelectionInterval(SimTracksTableEquivalent, SimTracksTableEquivalent);
                    } else {
                        simTracksTable.clearSelection();
                    }
                }
                if (trackColorCheckBox.isSelected()) {
                    Color cellColor = SimTracksTableEquivalent != -1 ? HTrackColor.getParticleColor(simTracksTable.getValueAt(SimTracksTableEquivalent, 1).toString()) : HTrackColor.getUnresolvedColor();
                    c.setBackground(cellColor);
                } else {
                    c.setBackground(Color.white);
                }
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        recTracksTable.setAutoResizeMode(2);
        recTracksTable.setRowSelectionAllowed(false);
        recTracksTable.setColumnSelectionAllowed(false);
        recTracksTable.setFocusable(false);
        recTracksTable.setSelectionMode(0);
        recTracksTable.getTableHeader().setReorderingAllowed(false);
        recTracksTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        recTracksTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        recTracksTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedRecTrack();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        recTracksTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedRecTrack();
            }
        });
        recTracksScrollPane.setViewportView(recTracksTable);
    }

    private static void initRecMuonTracks() {
        recMuonTracksScrollPane = new JScrollPane();
        recMuonTracksTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        recMuonTracksTableModel.addColumn("Track");
        recMuonTracksTableModel.addColumn("+/-");
        recMuonTracksTableModel.addColumn("P [GeV]");
        recMuonTracksTableModel.addColumn("Pt [GeV]");
        recMuonTracksTableModel.addColumn("\u03c6");
        recMuonTracksTableModel.addColumn("\u03b8");
        recMuonTracksTable = new JTable(recMuonTracksTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                int SimTracksTableEquivalent = -1;
                double recTracksTableMinValue = 1.0;
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                for (int i = 0; i < simMuonTracksTable.getRowCount(); ++i) {
                    double leastSquaresValue = Math.pow(Double.parseDouble(recMuonTracksTable.getValueAt(rowIndex, 3).toString().replace(',', '.')) - Double.parseDouble(simMuonTracksTable.getValueAt(i, 4).toString().replace(',', '.')), 2.0) + Math.pow(Double.parseDouble(recMuonTracksTable.getValueAt(rowIndex, 4).toString().replace(',', '.')) - Double.parseDouble(simMuonTracksTable.getValueAt(i, 5).toString().replace(',', '.')), 2.0);
                    if (!(leastSquaresValue < recTracksTableMinValue)) continue;
                    SimTracksTableEquivalent = i;
                    recTracksTableMinValue = leastSquaresValue;
                }
                if (recMuonTracksTable.getSelectedRow() == rowIndex) {
                    if (Math.sqrt(recTracksTableMinValue) <= 0.4 && SimTracksTableEquivalent >= 0) {
                        simMuonTracksTable.setRowSelectionInterval(SimTracksTableEquivalent, SimTracksTableEquivalent);
                    } else {
                        simMuonTracksTable.clearSelection();
                    }
                }
                if (trackColorCheckBox.isSelected()) {
                    Color cellColor = SimTracksTableEquivalent != -1 ? HTrackColor.getParticleColor(simMuonTracksTable.getValueAt(SimTracksTableEquivalent, 1).toString()) : HTrackColor.getUnresolvedColor();
                    c.setBackground(cellColor);
                } else {
                    c.setBackground(Color.white);
                }
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        recMuonTracksTable.setAutoResizeMode(2);
        recMuonTracksTable.setRowSelectionAllowed(false);
        recMuonTracksTable.setColumnSelectionAllowed(false);
        recMuonTracksTable.setFocusable(false);
        recMuonTracksTable.setSelectionMode(0);
        recMuonTracksTable.getTableHeader().setReorderingAllowed(false);
        recMuonTracksTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        recMuonTracksTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        recMuonTracksTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedRecMuonTrack();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        recMuonTracksTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedRecMuonTrack();
            }
        });
        recMuonTracksScrollPane.setViewportView(recMuonTracksTable);
    }

    private static void initSimTracks() {
        simTracksScrollPane = new JScrollPane();
        simTracksTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        simTracksTableModel.addColumn("Track");
        simTracksTableModel.addColumn("Type");
        simTracksTableModel.addColumn("P [GeV]");
        simTracksTableModel.addColumn("Pt [GeV]");
        simTracksTableModel.addColumn("\u03c6");
        simTracksTableModel.addColumn("\u03b8");
        simTracksTable = new JTable(simTracksTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                int RecTracksTableEquivalent = -1;
                double simTracksTableMinValue = Double.MAX_VALUE;
                for (int i = 0; i < recTracksTable.getRowCount(); ++i) {
                    double leastSquaresValue = Math.pow(Double.parseDouble(recTracksTable.getValueAt(i, 4).toString().replace(',', '.')) - Double.parseDouble(simTracksTable.getValueAt(rowIndex, 4).toString().replace(',', '.')), 2.0) + Math.pow(Double.parseDouble(recTracksTable.getValueAt(i, 5).toString().replace(',', '.')) - Double.parseDouble(simTracksTable.getValueAt(rowIndex, 5).toString().replace(',', '.')), 2.0);
                    if (!(leastSquaresValue < simTracksTableMinValue)) continue;
                    RecTracksTableEquivalent = i;
                    simTracksTableMinValue = leastSquaresValue;
                }
                if (simTracksTable.getSelectedRow() == rowIndex) {
                    if (Math.sqrt(simTracksTableMinValue) <= 0.4 && RecTracksTableEquivalent >= 0) {
                        recTracksTable.setRowSelectionInterval(RecTracksTableEquivalent, RecTracksTableEquivalent);
                    } else {
                        recTracksTable.clearSelection();
                    }
                }
                Color cellColor = trackColorCheckBox.isSelected() ? HTrackColor.getParticleColor(simTracksTable.getValueAt(rowIndex, 1).toString()) : HTrackColor.getUnresolvedColor();
                c.setBackground(cellColor);
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        simTracksTable.setAutoResizeMode(2);
        simTracksTable.setRowSelectionAllowed(false);
        simTracksTable.setColumnSelectionAllowed(false);
        simTracksTable.setFocusable(false);
        simTracksTable.setSelectionMode(0);
        simTracksTable.getTableHeader().setReorderingAllowed(false);
        simTracksTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        simTracksTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        simTracksTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedSimTrack();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        simTracksTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedSimTrack();
            }
        });
        simTracksScrollPane.setViewportView(simTracksTable);
    }

    private static void initSimMuonTracks() {
        simMuonTracksScrollPane = new JScrollPane();
        simMuonTracksTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        simMuonTracksTableModel.addColumn("Track");
        simMuonTracksTableModel.addColumn("Type");
        simMuonTracksTableModel.addColumn("P [GeV]");
        simMuonTracksTableModel.addColumn("Pt [GeV]");
        simMuonTracksTableModel.addColumn("\u03c6");
        simMuonTracksTableModel.addColumn("\u03b8");
        simMuonTracksTable = new JTable(simMuonTracksTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                int RecTracksTableEquivalent = -1;
                double simTracksTableMinValue = 1.0;
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                for (int i = 0; i < recMuonTracksTable.getRowCount(); ++i) {
                    double leastSquaresValue = Math.pow(Double.parseDouble(simMuonTracksTable.getValueAt(rowIndex, 4).toString().replace(',', '.')) - Double.parseDouble(recMuonTracksTable.getValueAt(i, 3).toString().replace(',', '.')), 2.0) + Math.pow(Double.parseDouble(simMuonTracksTable.getValueAt(rowIndex, 5).toString().replace(',', '.')) - Double.parseDouble(recMuonTracksTable.getValueAt(i, 4).toString().replace(',', '.')), 2.0);
                    if (!(leastSquaresValue < simTracksTableMinValue)) continue;
                    RecTracksTableEquivalent = i;
                    simTracksTableMinValue = leastSquaresValue;
                }
                if (simMuonTracksTable.getSelectedRow() == rowIndex) {
                    if (Math.sqrt(simTracksTableMinValue) <= 0.4 && RecTracksTableEquivalent >= 0) {
                        recMuonTracksTable.setRowSelectionInterval(RecTracksTableEquivalent, RecTracksTableEquivalent);
                    } else {
                        recMuonTracksTable.clearSelection();
                    }
                }
                Color cellColor = trackColorCheckBox.isSelected() ? HTrackColor.getParticleColor(simMuonTracksTable.getValueAt(rowIndex, 1).toString()) : HTrackColor.getUnresolvedColor();
                c.setBackground(cellColor);
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        simMuonTracksTable.setAutoResizeMode(2);
        simMuonTracksTable.setRowSelectionAllowed(false);
        simMuonTracksTable.setColumnSelectionAllowed(false);
        simMuonTracksTable.setFocusable(false);
        simMuonTracksTable.setSelectionMode(0);
        simMuonTracksTable.getTableHeader().setReorderingAllowed(false);
        simMuonTracksTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        simMuonTracksTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        simMuonTracksTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedSimMuonTrack();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        simMuonTracksTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedSimMuonTrack();
            }
        });
        simMuonTracksScrollPane.setViewportView(simMuonTracksTable);
    }

    private static void initSimNeutralTracks() {
        simNeutralTracksScrollPane = new JScrollPane();
        simNeutralTracksTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        simNeutralTracksTableModel.addColumn("Track");
        simNeutralTracksTableModel.addColumn("Type");
        simNeutralTracksTableModel.addColumn("P [GeV]");
        simNeutralTracksTableModel.addColumn("Pt [GeV]");
        simNeutralTracksTableModel.addColumn("\u03c6");
        simNeutralTracksTableModel.addColumn("\u03b8");
        simNeutralTracksTable = new JTable(simNeutralTracksTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        simNeutralTracksTable.setAutoResizeMode(2);
        simNeutralTracksTable.setRowSelectionAllowed(false);
        simNeutralTracksTable.setColumnSelectionAllowed(false);
        simNeutralTracksTable.setFocusable(false);
        simNeutralTracksTable.setSelectionMode(0);
        simNeutralTracksTable.getTableHeader().setReorderingAllowed(false);
        simNeutralTracksTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        simNeutralTracksTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        simNeutralTracksTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedSimNeutralTrack();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        simNeutralTracksTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedSimNeutralTrack();
            }
        });
        simNeutralTracksScrollPane.setViewportView(simNeutralTracksTable);
    }

    private static void initObjJets() {
        objJetsScrollPane = new JScrollPane();
        objJetsTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        objJetsTableModel.addColumn("Track");
        objJetsTableModel.addColumn("E [GeV]");
        objJetsTableModel.addColumn("ET [GeV]");
        objJetsTableModel.addColumn("\u03c6");
        objJetsTableModel.addColumn("\u03b8");
        objJetsTable = new JTable(objJetsTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        objJetsTable.setAutoResizeMode(2);
        objJetsTable.setRowSelectionAllowed(false);
        objJetsTable.setColumnSelectionAllowed(false);
        objJetsTable.setFocusable(false);
        objJetsTable.setSelectionMode(0);
        objJetsTable.getTableHeader().setReorderingAllowed(false);
        objJetsTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        objJetsTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedJet();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        objJetsTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedJet();
            }
        });
        objJetsScrollPane.setViewportView(objJetsTable);
    }

    private static void initObjElectrons() {
        objElectronsScrollPane = new JScrollPane();
        objElectronsTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        objElectronsTableModel.addColumn("Track");
        objElectronsTableModel.addColumn("+/-");
        objElectronsTableModel.addColumn("P [GeV]");
        objElectronsTableModel.addColumn("Pt [GeV]");
        objElectronsTableModel.addColumn("\u03c6");
        objElectronsTableModel.addColumn("\u03b8");
        objElectronsTable = new JTable(objElectronsTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        objElectronsTable.setAutoResizeMode(2);
        objElectronsTable.setRowSelectionAllowed(false);
        objElectronsTable.setColumnSelectionAllowed(false);
        objElectronsTable.setFocusable(false);
        objElectronsTable.setSelectionMode(0);
        objElectronsTable.getTableHeader().setReorderingAllowed(false);
        objElectronsTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        objElectronsTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        objElectronsTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedElectron();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        objElectronsTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedElectron();
            }
        });
        objElectronsScrollPane.setViewportView(objElectronsTable);
    }

    private static void initObjMuons() {
        objMuonsScrollPane = new JScrollPane();
        objMuonsTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        objMuonsTableModel.addColumn("Track");
        objMuonsTableModel.addColumn("+/-");
        objMuonsTableModel.addColumn("P [GeV]");
        objMuonsTableModel.addColumn("Pt [GeV]");
        objMuonsTableModel.addColumn("\u03c6");
        objMuonsTableModel.addColumn("\u03b8");
        objMuonsTable = new JTable(objMuonsTableModel){

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
                if (this.isRowSelected(rowIndex)) {
                    c.setFont(new Font("", 1, 12));
                    c.setBackground(Color.LIGHT_GRAY);
                } else {
                    c.setFont(new Font("", 0, 12));
                    c.setBackground(HTrackColor.getUnresolvedColor());
                }
                return c;
            }
        };
        objMuonsTable.setAutoResizeMode(2);
        objMuonsTable.setRowSelectionAllowed(false);
        objMuonsTable.setColumnSelectionAllowed(false);
        objMuonsTable.setFocusable(false);
        objMuonsTable.setSelectionMode(0);
        objMuonsTable.getTableHeader().setReorderingAllowed(false);
        objMuonsTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        objMuonsTable.getColumnModel().getColumn(1).setPreferredWidth(25);
        objMuonsTable.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                HTrackMomentaWindow.markSelectedObjectMuon();
                if (e.getClickCount() == 2) {
                    insertElectronButton.doClick();
                }
            }
        });
        objMuonsTable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                HTrackMomentaWindow.markSelectedObjectMuon();
            }
        });
        objMuonsScrollPane.setViewportView(objMuonsTable);
    }

    public static void refresh() {
        currentEvent = Atlantis.getEventManager().getCurrentEvent();
        String currentEventETMisCollection = ((AEnumeratorParameter)APar.get("ETMis", "ETMisCollections")).getCurrentText();
        AETMisData currentEventETMisCollectionEnergy = (AETMisData)currentEvent.get("ETMis" + currentEventETMisCollection);
        currentEventETMis.setText(" ETMis: " + AMath.d2s(currentEventETMisCollectionEnergy.getET(), 3) + " GeV     " + "\u03c6" + ": " + AMath.d2s(HUtilities.changePhiRange(currentEventETMisCollectionEnergy.getPhi()), 3) + " rad     " + "Collection: " + currentEventETMisCollection + "        ");
        ACanvas.setCanvasTitle(" File: " + currentEvent.getSourceName() + "  Run: " + currentEvent.getRunNumber() + "  Event: " + currentEvent.getEventNumber());
        HTrackMomentaWindow.refreshRecTracks();
        HTrackMomentaWindow.refreshRecMuonTracks();
        HTrackMomentaWindow.refreshSimTracks();
        HTrackMomentaWindow.refreshSimMuonTracks();
        HTrackMomentaWindow.refreshSimNeutralTracks();
        HTrackMomentaWindow.refreshObjJets();
        HTrackMomentaWindow.refreshObjElectrons();
        HTrackMomentaWindow.refreshObjMuons();
    }

    private static void refreshRecTracks() {
        block11: {
            block10: {
                recTracksTableModel.setRowCount(0);
                recTracks = currentEvent.getTrackData("InDetTrack", ((AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections")).getCurrentText());
                AEnumeratorParameter listBoxE = (AEnumeratorParameter)APar.get("Electron", "ElectronCollections");
                String selectedElectronCollection = listBoxE.getCurrentText();
                ElectronTracks = (AElectronData)currentEvent.get("Electron" + selectedElectronCollection);
                AEnumeratorParameter listBoxM = (AEnumeratorParameter)APar.get("Muon", "MuonCollections");
                String selectedMuonCollection = listBoxM.getCurrentText();
                MuonTracks = (AMuonData)currentEvent.get("Muon" + selectedMuonCollection);
                if (((AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections")).getCurrentText() == null) {
                    AEnumeratorParameter trackCollections = (AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections");
                    APar.get("InDetTrack", "InDetTrackCollections").setI((int)trackCollections.getValue("All"));
                }
                if (!((AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections")).getCurrentText().equals("All")) break block10;
                for (int listBoxCounter = 0; listBoxCounter < ((AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections")).size() - 1; ++listBoxCounter) {
                    recTracks = currentEvent.getTrackData("InDetTrack", ((AEnumeratorParameter)APar.get("InDetTrack", "InDetTrackCollections")).getText(listBoxCounter));
                    if (recTracks == null) continue;
                    recTracks.makeDrawList();
                    for (int i = 0; i < recTracks.getNumData(); ++i) {
                        if (!recTracks.isDrawn(i) || recTracks.getModifiableHelix(i) == null) continue;
                        recTracksTableModel.insertRow(recTracksTableModel.getRowCount(), new Object[]{recTracks.getStoreGateKey() + " " + i, HUtilities.getSign(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT), AMath.d2s(AMath.getPFromPttL(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT, HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).tL), 2), AMath.d2s(Math.abs(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT), 2), AMath.d2s(AMath.degreesToRadians(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).phi0), 3), AMath.d2s(HUtilities.getThetaFromTl(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).tL), 3)});
                    }
                }
                break block11;
            }
            if (recTracks == null) break block11;
            recTracks.makeDrawList();
            for (int i = 0; i < recTracks.getNumData(); ++i) {
                double LeastSquaresValue;
                int ElectronEquivalent = -1;
                double RecTracksTableMinValue = Double.MAX_VALUE;
                double thetaRecTrack = HUtilities.getThetaFromTl(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).tL);
                if (ElectronTracks != null) {
                    for (int q = 0; q < ElectronTracks.getNumData(); ++q) {
                        double thetaElectron = HUtilities.getThetaFromEta(ElectronTracks.getEta(q));
                        LeastSquaresValue = Math.pow(AMath.degreesToRadians(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).phi0) - HUtilities.changePhiRange(ElectronTracks.getPhi(q)), 2.0) + Math.pow(thetaRecTrack - thetaElectron, 2.0);
                        if (!(LeastSquaresValue < RecTracksTableMinValue)) continue;
                        ElectronEquivalent = q;
                        RecTracksTableMinValue = LeastSquaresValue;
                    }
                }
                if (Math.sqrt(RecTracksTableMinValue) <= 0.005 && ElectronEquivalent >= 0) {
                    HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT = ElectronTracks.getPt(ElectronEquivalent);
                }
                int MuonEquivalent = -1;
                RecTracksTableMinValue = Double.MAX_VALUE;
                if (MuonTracks != null) {
                    for (int q = 0; q < MuonTracks.getNumData(); ++q) {
                        double thetaMuon = HUtilities.getThetaFromEta(MuonTracks.getEta(q));
                        LeastSquaresValue = Math.pow(AMath.degreesToRadians(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).phi0) - HUtilities.changePhiRange(MuonTracks.getPhi(q)), 2.0) + Math.pow(thetaRecTrack - thetaMuon, 2.0);
                        if (!(LeastSquaresValue < RecTracksTableMinValue)) continue;
                        MuonEquivalent = q;
                        RecTracksTableMinValue = LeastSquaresValue;
                    }
                }
                if (Math.sqrt(RecTracksTableMinValue) <= 0.005 && MuonEquivalent >= 0) {
                    HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT = MuonTracks.getPt(MuonEquivalent);
                }
                if (!recTracks.isDrawn(i)) continue;
                recTracksTableModel.insertRow(recTracksTableModel.getRowCount(), new Object[]{recTracks.getStoreGateKey() + " " + i, HUtilities.getSign(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT), AMath.d2s(AMath.getPFromPttL(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT, HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).tL), 2), AMath.d2s(Math.abs(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).pT), 2), AMath.d2s(AMath.degreesToRadians(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).phi0), 3), AMath.d2s(HUtilities.getThetaFromTl(HTrackMomentaWindow.recTracks.getModifiableHelix((int)i).tL), 3)});
            }
        }
    }

    private static void refreshRecMuonTracks() {
        block10: {
            block9: {
                recMuonTracksTableModel.setRowCount(0);
                recMuonTracks = (AMuonTrackData)currentEvent.getTrackData("MuonTrack", ((AEnumeratorParameter)APar.get("MuonTrack", "MuonTrackCollections")).getCurrentText());
                if (!((AEnumeratorParameter)APar.get("MuonTrack", "MuonTrackCollections")).getCurrentText().equals("All")) break block9;
                for (int listBoxCounter = 0; listBoxCounter < ((AEnumeratorParameter)APar.get("MuonTrack", "MuonTrackCollections")).size() - 1; ++listBoxCounter) {
                    recMuonTracks = (AMuonTrackData)currentEvent.getTrackData("MuonTrack", ((AEnumeratorParameter)APar.get("MuonTrack", "MuonTrackCollections")).getText(listBoxCounter));
                    if (recMuonTracks == null) continue;
                    recMuonTracks.makeDrawList();
                    for (int i = 0; i < recMuonTracks.getNumData(); ++i) {
                        if (!recMuonTracks.isDrawn(i)) continue;
                        if (recMuonTracks.getStoreGateKey().equals("ConvertedMuIdCBTracks") && currentEvent.getTrackData("InDetTrack", "ConvertedMuIdCBTracks") != null) {
                            HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT = HTrackMomentaWindow.currentEvent.getTrackData((String)"InDetTrack", (String)"ConvertedMuIdCBTracks").getModifiableHelix((int)i).pT;
                        } else if (recMuonTracks.getStoreGateKey().equals("ConvertedStacoTracks") && currentEvent.getTrackData("InDetTrack", "ConvertedStacoTracks") != null) {
                            HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT = HTrackMomentaWindow.currentEvent.getTrackData((String)"InDetTrack", (String)"ConvertedStacoTracks").getModifiableHelix((int)i).pT;
                        }
                        if (recMuonTracks.getModifiableHelix(i) == null) continue;
                        recMuonTracksTableModel.insertRow(recMuonTracksTableModel.getRowCount(), new Object[]{recMuonTracks.getStoreGateKey() + " " + i, HUtilities.getSign(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT), AMath.d2s(AMath.getPFromPttL(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT, HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).tL), 2), AMath.d2s(Math.abs(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT), 2), AMath.d2s(AMath.degreesToRadians(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).phi0), 3), AMath.d2s(HUtilities.getThetaFromTl(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).tL), 3)});
                    }
                }
                break block10;
            }
            if (recMuonTracks == null) break block10;
            recMuonTracks.makeDrawList();
            for (int i = 0; i < recMuonTracks.getNumData(); ++i) {
                if (!recMuonTracks.isDrawn(i)) continue;
                if (recMuonTracks.getStoreGateKey().equals("ConvertedMuIdCBTracks") && currentEvent.getTrackData("InDetTrack", "ConvertedMuIdCBTracks") != null) {
                    HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT = HTrackMomentaWindow.currentEvent.getTrackData((String)"InDetTrack", (String)"ConvertedMuIdCBTracks").getModifiableHelix((int)i).pT;
                } else if (recMuonTracks.getStoreGateKey().equals("ConvertedStacoTracks") && currentEvent.getTrackData("InDetTrack", "ConvertedStacoTracks") != null) {
                    HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT = HTrackMomentaWindow.currentEvent.getTrackData((String)"InDetTrack", (String)"ConvertedStacoTracks").getModifiableHelix((int)i).pT;
                }
                if (recMuonTracks.getModifiableHelix(i) == null) continue;
                recMuonTracksTableModel.insertRow(recMuonTracksTableModel.getRowCount(), new Object[]{recMuonTracks.getStoreGateKey() + " " + i, HUtilities.getSign(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT), AMath.d2s(AMath.getPFromPttL(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT, HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).tL), 2), AMath.d2s(Math.abs(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).pT), 2), AMath.d2s(AMath.degreesToRadians(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).phi0), 3), AMath.d2s(HUtilities.getThetaFromTl(HTrackMomentaWindow.recMuonTracks.getModifiableHelix((int)i).tL), 3)});
            }
        }
    }

    private static void refreshSimTracks() {
        simTracksTableModel.setRowCount(0);
        simTracks = currentEvent.getSTrData();
        if (simTracks != null) {
            simTracks.makeDrawList();
            for (int i = 0; i < simTracks.getNumData(); ++i) {
                if (!simTracks.isDrawn(i) || simTracks.getModifiableHelix(i) == null) continue;
                simTracksTableModel.insertRow(simTracksTableModel.getRowCount(), new Object[]{simTracks.getNameScreenName() + " " + i, simTracks.getType(i), AMath.d2s(AMath.getPFromPttL(HTrackMomentaWindow.simTracks.getModifiableHelix((int)i).pT, HTrackMomentaWindow.simTracks.getModifiableHelix((int)i).tL), 2), AMath.d2s(Math.abs(HTrackMomentaWindow.simTracks.getModifiableHelix((int)i).pT), 2), AMath.d2s(AMath.degreesToRadians(HTrackMomentaWindow.simTracks.getModifiableHelix((int)i).phi0), 3), AMath.d2s(HUtilities.getThetaFromTl(HTrackMomentaWindow.simTracks.getModifiableHelix((int)i).tL), 3)});
            }
        }
    }

    private static void refreshSimMuonTracks() {
        simMuonTracksTableModel.setRowCount(0);
        simMuonTracks = currentEvent.getSMTrData();
        if (simMuonTracks != null) {
            simMuonTracks.makeDrawList();
            for (int i = 0; i < simMuonTracks.getNumData(); ++i) {
                if (!simMuonTracks.isDrawn(i)) continue;
                simMuonTracksTableModel.insertRow(simMuonTracksTableModel.getRowCount(), new Object[]{simMuonTracks.getNameScreenName() + " " + i, simMuonTracks.getType(i), AMath.d2s(simMuonTracks.getP(i), 2), AMath.d2s(Math.abs(simMuonTracks.getPt(i)), 2), AMath.d2s(AMath.degreesToRadians(simMuonTracks.getPhi(i)), 3), AMath.d2s(HUtilities.getThetaFromTl(simMuonTracks.gettL(i)), 3)});
            }
        }
    }

    private static void refreshSimNeutralTracks() {
        simNeutralTracksTableModel.setRowCount(0);
        simNeutralTracks = currentEvent.getSNPData();
        if (simNeutralTracks != null) {
            simNeutralTracks.makeDrawList();
            for (int i = 0; i < simNeutralTracks.getNumData(); ++i) {
                if (!simNeutralTracks.isDrawn(i)) continue;
                simNeutralTracksTableModel.insertRow(simNeutralTracksTableModel.getRowCount(), new Object[]{simNeutralTracks.getNameScreenName() + " " + i, simNeutralTracks.getType(i), AMath.d2s(simNeutralTracks.getP(i), 2), AMath.d2s(Math.abs(simNeutralTracks.getPt(i)), 2), AMath.d2s(AMath.degreesToRadians(simNeutralTracks.getPhi(i)), 3), AMath.d2s(HUtilities.getThetaFromTl(simNeutralTracks.gettL(i)), 3)});
            }
        }
    }

    private static void refreshObjJets() {
        objJetsTableModel.setRowCount(0);
        objJets = currentEvent.getJetData();
        if (objJets != null) {
            objJets.makeDrawList();
            for (int i = 0; i < objJets.getNumData(); ++i) {
                if (!objJets.isDrawn(i)) continue;
                objJetsTableModel.insertRow(objJetsTableModel.getRowCount(), new Object[]{objJets.getStoreGateKey() + " " + i, AMath.d2s(objJets.getE(i), 3), AMath.d2s(objJets.getET(i), 3), AMath.d2s(HUtilities.changePhiRange(objJets.getPhi(i)), 3), AMath.d2s(HUtilities.getThetaFromEta(objJets.getEta(i)), 3)});
            }
        }
    }

    private static void refreshObjElectrons() {
        objElectronsTableModel.setRowCount(0);
        objElectrons = (AElectronData)currentEvent.get("Electron" + ((AEnumeratorParameter)APar.get("Electron", "ElectronCollections")).getCurrentText());
        if (objElectrons != null) {
            objElectrons.makeDrawList();
            for (int i = 0; i < objElectrons.getNumData(); ++i) {
                if (!objElectrons.isDrawn(i)) continue;
                objElectronsTableModel.insertRow(objElectronsTableModel.getRowCount(), new Object[]{objElectrons.getStoreGateKey() + " " + i, HUtilities.getSign(objElectrons.getPt(i)), AMath.d2s(objElectrons.getP(i), 2), AMath.d2s(Math.abs(objElectrons.getPt(i)), 2), AMath.d2s(HUtilities.changePhiRange(objElectrons.getPhi(i)), 3), AMath.d2s(HUtilities.getThetaFromEta(objElectrons.getEta(i)), 3)});
            }
        }
    }

    private static void refreshObjMuons() {
        objMuonsTableModel.setRowCount(0);
        objMuons = (AMuonData)currentEvent.get("Muon" + ((AEnumeratorParameter)APar.get("Muon", "MuonCollections")).getCurrentText());
        if (objMuons != null) {
            objMuons.makeDrawList();
            for (int i = 0; i < objMuons.getNumData(); ++i) {
                if (!objMuons.isDrawn(i)) continue;
                objMuonsTableModel.insertRow(objMuonsTableModel.getRowCount(), new Object[]{objMuons.getStoreGateKey() + " " + i, HUtilities.getSign(objMuons.getPt(i)), AMath.d2s(objMuons.getP(i), 2), AMath.d2s(Math.abs(objMuons.getPt(i)), 2), AMath.d2s(HUtilities.changePhiRange(objMuons.getPhi(i)), 3), AMath.d2s(HUtilities.getThetaFromEta(objMuons.getEta(i)), 3)});
            }
        }
    }

    static void markSelectedRecTrack() {
        int sel = recTracksTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(recTracksTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            recTracks = currentEvent.getTrackData("InDetTrack", recTracksTableModel.getValueAt(sel, 0).toString().split(" ")[0]);
            APickingGraphics2D.setPicked(recTracks, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
            int RecMuonTracksTableEquivalent = -1;
            double RecMuonTracksTableMinValue = 1.0;
            for (int q = 0; q < recMuonTracksTable.getRowCount(); ++q) {
                double LeastSquaresValue = Math.pow(Double.parseDouble(recTracksTable.getValueAt(sel, 4).toString().replace(',', '.')) - Double.parseDouble(recMuonTracksTable.getValueAt(q, 4).toString().replace(',', '.')), 2.0) + Math.pow(Double.parseDouble(recTracksTable.getValueAt(sel, 5).toString().replace(',', '.')) - Double.parseDouble(recMuonTracksTable.getValueAt(q, 5).toString().replace(',', '.')), 2.0);
                if (!(LeastSquaresValue < RecMuonTracksTableMinValue)) continue;
                RecMuonTracksTableEquivalent = q;
                RecMuonTracksTableMinValue = LeastSquaresValue;
            }
            if (Math.sqrt(RecMuonTracksTableMinValue) <= 0.01 && RecMuonTracksTableEquivalent >= 0) {
                APickingGraphics2D.setPicked(recMuonTracks, RecMuonTracksTableEquivalent);
                AList pickedMuon = APickingGraphics2D.getPickedHit();
                AListManager.getInstance().highlight(pickedMuon);
                HInvariantMassWindow.markTrackFromTrackMomentaWindow(Atlantis.getEventManager().getCurrentEvent().getName(), recTracksTable.getModel().getValueAt(sel, 0).toString());
            }
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    private static void markSelectedRecMuonTrack() {
        int sel = recMuonTracksTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(recMuonTracksTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            recMuonTracks = (AMuonTrackData)currentEvent.getTrackData("MuonTrack", recMuonTracksTableModel.getValueAt(sel, 0).toString().split(" ")[0]);
            APickingGraphics2D.setPicked(recMuonTracks, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    private static void markSelectedSimTrack() {
        int sel = simTracksTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(simTracksTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            APickingGraphics2D.setPicked(simTracks, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    private static void markSelectedSimMuonTrack() {
        int sel = simMuonTracksTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(simMuonTracksTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            APickingGraphics2D.setPicked(simMuonTracks, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    private static void markSelectedSimNeutralTrack() {
        int sel = simNeutralTracksTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(simNeutralTracksTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            APickingGraphics2D.setPicked(simNeutralTracks, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    private static void markSelectedJet() {
        int sel = objJetsTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(objJetsTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            APickingGraphics2D.setPicked(objJets, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    private static void markSelectedElectron() {
        int sel = objElectronsTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(objElectronsTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            APickingGraphics2D.setPicked(objElectrons, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    private static void markSelectedObjectMuon() {
        int sel = objMuonsTable.getSelectedRow();
        if (sel != -1) {
            int index = Integer.parseInt(objMuonsTableModel.getValueAt(sel, 0).toString().split(" ")[1]);
            APickingGraphics2D.setPicked(objMuons, index);
            AList picked = APickingGraphics2D.getPickedHit();
            AListManager.getInstance().highlight(picked);
        } else {
            APickingGraphics2D.setPicked(null, 0);
            AListManager.getInstance().clearHighlight();
        }
    }

    public static void findTrack() {
        int i;
        currentEvent = Atlantis.getEventManager().getCurrentEvent();
        int trackIndex = APickingGraphics2D.getPickedHitIndex();
        int selectedTab = mainTabbedPane.getSelectedIndex();
        block0 : switch (selectedTab) {
            case 0: {
                int recSelected = recTabbedPane.getSelectedIndex();
                switch (recSelected) {
                    case 0: {
                        recTracksTable.getSelectionModel().clearSelection();
                        break;
                    }
                    case 1: {
                        recMuonTracksTable.getSelectionModel().clearSelection();
                    }
                }
                break;
            }
            case 1: {
                int simSelected = simTabbedPane.getSelectedIndex();
                switch (simSelected) {
                    case 0: {
                        simTracksTable.getSelectionModel().clearSelection();
                        break;
                    }
                    case 1: {
                        simMuonTracksTable.getSelectionModel().clearSelection();
                        break;
                    }
                    case 2: {
                        simNeutralTracksTable.getSelectionModel().clearSelection();
                    }
                }
                break;
            }
            case 2: {
                int objectsSelected = objTabbedPane.getSelectedIndex();
                switch (objectsSelected) {
                    case 0: {
                        objJetsTable.getSelectionModel().clearSelection();
                        break block0;
                    }
                    case 1: {
                        objElectronsTable.getSelectionModel().clearSelection();
                        break block0;
                    }
                    case 2: {
                        objMuonsTable.getSelectionModel().clearSelection();
                    }
                }
            }
        }
        String selectedKey = APickingGraphics2D.getPickedData().getStoreGateKey();
        if (selectedKey == null) {
            selectedKey = APickingGraphics2D.getPickedData().getNameScreenName();
        }
        for (i = 0; i < recTracksTable.getRowCount(); ++i) {
            if (!selectedKey.equals(recTracksTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(recTracksTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            recTracksTable.scrollRectToVisible(recTracksTable.getCellRect(i, 0, true));
            recTracksTable.getSelectionModel().setSelectionInterval(i, i);
            mainTabbedPane.setSelectedIndex(0);
            recTabbedPane.setSelectedIndex(0);
        }
        for (i = 0; i < recMuonTracksTable.getRowCount(); ++i) {
            if (!selectedKey.equals(recMuonTracksTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(recMuonTracksTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            recMuonTracksTable.scrollRectToVisible(recMuonTracksTable.getCellRect(i, 0, true));
            recMuonTracksTable.getSelectionModel().setSelectionInterval(i, i);
            int RecTracksTableEquivalent = -1;
            double RecTracksTableMinValue = 1.0;
            for (int q = 0; q < recTracksTable.getRowCount(); ++q) {
                double LeastSquaresValue = Math.pow(Double.parseDouble(recMuonTracksTable.getValueAt(i, 4).toString().replace(',', '.')) - Double.parseDouble(recTracksTable.getValueAt(q, 4).toString().replace(',', '.')), 2.0) + Math.pow(Double.parseDouble(recMuonTracksTable.getValueAt(i, 5).toString().replace(',', '.')) - Double.parseDouble(recTracksTable.getValueAt(q, 5).toString().replace(',', '.')), 2.0);
                if (!(LeastSquaresValue < RecTracksTableMinValue)) continue;
                RecTracksTableEquivalent = q;
                RecTracksTableMinValue = LeastSquaresValue;
            }
            if (recMuonTracksTable.getSelectedRow() == i) {
                if (Math.sqrt(RecTracksTableMinValue) <= 0.01 && RecTracksTableEquivalent >= 0) {
                    recTracksTable.setRowSelectionInterval(RecTracksTableEquivalent, RecTracksTableEquivalent);
                    recTracksTable.scrollRectToVisible(recTracksTable.getCellRect(RecTracksTableEquivalent, 0, true));
                    HInvariantMassWindow.markTrackFromTrackMomentaWindow(Atlantis.getEventManager().getCurrentEvent().getName(), recTracksTable.getModel().getValueAt(RecTracksTableEquivalent, 0).toString());
                } else {
                    recTracksTable.clearSelection();
                }
            }
            mainTabbedPane.setSelectedIndex(0);
            recTabbedPane.setSelectedIndex(0);
        }
        for (i = 0; i < simTracksTable.getRowCount(); ++i) {
            if (!selectedKey.equals(simTracksTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(simTracksTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            simTracksTable.scrollRectToVisible(simTracksTable.getCellRect(i, 0, true));
            simTracksTable.getSelectionModel().setSelectionInterval(i, i);
            mainTabbedPane.setSelectedIndex(1);
            simTabbedPane.setSelectedIndex(0);
        }
        for (i = 0; i < simMuonTracksTable.getRowCount(); ++i) {
            if (!selectedKey.equals(simMuonTracksTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(simMuonTracksTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            simMuonTracksTable.scrollRectToVisible(simMuonTracksTable.getCellRect(i, 0, true));
            simMuonTracksTable.getSelectionModel().setSelectionInterval(i, i);
            mainTabbedPane.setSelectedIndex(1);
            simTabbedPane.setSelectedIndex(1);
        }
        for (i = 0; i < simNeutralTracksTable.getRowCount(); ++i) {
            if (!selectedKey.equals(simNeutralTracksTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(simNeutralTracksTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            simNeutralTracksTable.scrollRectToVisible(simNeutralTracksTable.getCellRect(i, 0, true));
            simNeutralTracksTable.getSelectionModel().setSelectionInterval(i, i);
            mainTabbedPane.setSelectedIndex(1);
            simTabbedPane.setSelectedIndex(2);
        }
        for (i = 0; i < objJetsTable.getRowCount(); ++i) {
            if (!selectedKey.equals(objJetsTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(objJetsTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            objJetsTable.scrollRectToVisible(objJetsTable.getCellRect(i, 0, true));
            objJetsTable.getSelectionModel().setSelectionInterval(i, i);
            mainTabbedPane.setSelectedIndex(2);
            objTabbedPane.setSelectedIndex(0);
        }
        for (i = 0; i < objElectronsTable.getRowCount(); ++i) {
            if (!selectedKey.equals(objElectronsTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(objElectronsTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            objElectronsTable.scrollRectToVisible(objElectronsTable.getCellRect(i, 0, true));
            objElectronsTable.getSelectionModel().setSelectionInterval(i, i);
            mainTabbedPane.setSelectedIndex(2);
            objTabbedPane.setSelectedIndex(1);
        }
        for (i = 0; i < objMuonsTable.getRowCount(); ++i) {
            if (!selectedKey.equals(objMuonsTableModel.getValueAt(i, 0).toString().split(" ")[0]) || trackIndex != Integer.parseInt(objMuonsTableModel.getValueAt(i, 0).toString().split(" ")[1])) continue;
            objMuonsTable.scrollRectToVisible(objMuonsTable.getCellRect(i, 0, true));
            objMuonsTable.getSelectionModel().setSelectionInterval(i, i);
            mainTabbedPane.setSelectedIndex(2);
            objTabbedPane.setSelectedIndex(2);
        }
    }

    public static HTrackMomentaWindow getGUI() {
        return instance;
    }

    public static void setDemoCheckBox() {
        demoCheckBox.setSelected(true);
    }

    public static void removeDemoCheckBox() {
        demoCheckBox.setSelected(false);
    }

    public static void setDemoDelay(int d) {
        DemoDelay = d;
    }

    public static void startDemo() {
        timer = new Timer(DemoDelay, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HTrackMomentaWindow.readDemoEvent();
                ACanvas.getCanvas().repaintAllFromScratch();
            }
        });
        timer.start();
    }

    public static void readDemoEvent() {
        try {
            Atlantis.getEventManager().nextEvent();
        }
        catch (AEventSource.NoMoreEventsException nme) {
            try {
                Atlantis.getEventManager().setEventSource(Atlantis.demoEventPath);
                Atlantis.getEventManager().nextEvent();
            }
            catch (Exception ex) {}
        }
        catch (AEventSource.ReadEventException ree) {
            logger.warn("Got ReadEventException: " + ree.getMessage() + " - trying next event");
        }
        catch (AEventSource.InvalidEventSourceException ies) {
            String msg = "Event source is not valid: +" + ies.getMessage() + " - stopping Demo!";
            logger.error(msg);
            JOptionPane.showMessageDialog(null, msg, "Invalid Event Source", 0);
            HTrackMomentaWindow.removeDemoCheckBox();
        }
    }

    public static void setInvariantMassWindowCheckBox() {
        hideInvariantMassWindowCheckBox.setSelected(true);
    }

    public static void setSimplifiedControlPanelCheckBox() {
        simplifiedControlPanelCheckBox.setSelected(true);
    }

    public static void setHideSimulatedCheckBox() {
        hideSimulatedCheckBox.setSelected(true);
    }

    static {
        DemoDelay = 0;
        logger = ALogger.getLogger(HControlWindow.class);
    }
}

