/*
 * Decompiled with CFR 0.152.
 */
package atlantis.hypatia;

public class HUtilities {
    public static final String projectShortName = "HYPATIA";
    public static final String projectFullName = "Hybrid pupils' analysis tool for interactions in ATLAS";
    public static final String projectVersion = "6.0";
    public static final int VersionNumber = 6000;
    public static final String teta = "\u03b8";
    public static final String phi = "\u03c6";
    public static final String eta = "\u03b7";
    public static final String ni = "\u03bd";
    public static final String mu = "\u03bc";
    public static final String gamma = "\u03b3";

    public static String getSign(double value) {
        return value > 0.0 ? "+" : "-";
    }

    public static String getSign(int value) {
        return value > 0 ? "+" : "-";
    }

    public static double getThetaFromTl(double tl) {
        double theta = Math.atan(1.0 / tl);
        if (theta < 0.0) {
            theta += Math.PI;
        }
        return theta;
    }

    public static double getThetaFromEta(double eta) {
        double theta = -2.0 * Math.atan2(1.0, Math.exp(-eta));
        if (theta < 0.0) {
            theta += Math.PI;
        }
        return theta;
    }

    public static double changePhiRange(double phi) {
        if (phi > Math.PI) {
            phi -= Math.PI * 2;
        }
        return phi;
    }
}

