/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.gui.ACursorFactory;
import atlantis.interactions.AEnterExitListener;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionsManager;
import atlantis.interactions.AModifier;
import atlantis.interactions.AMousePressListener;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection3DBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;

public class A3DBoxInteraction
extends AInteraction
implements ASleepMouseDragListener,
AMousePressListener,
AEnterExitListener {
    private static final int ZOOM_MODE = 0;
    private static final int HORIZONTAL_ZOOM_MODE = 1;
    private static final int VERTICAL_ZOOM_MODE = 2;
    private static final int ROTATE_MODE = 3;
    private int d = 10;
    private Point2D.Double p0;
    private int previousKey = 0;
    private int mode;

    public A3DBoxInteraction() {
        super(1, 1, 0, false);
        this.hr[0] = new Ellipse2D.Double(-this.d / 2, -this.d / 2, this.d, this.d);
    }

    public void connect(AInteractionsManager manager) {
        super.connect(manager);
    }

    public int getPressButton() {
        return 0;
    }

    public int init(Point2D.Double p, int key) {
        this.keyChange(p, key);
        return -1;
    }

    public void pressed(Point2D.Double p, int button, int key) {
    }

    public int getButton() {
        return 0;
    }

    public void start(Point2D.Double p, int region, int key) {
    }

    private void keyChange(Point2D.Double p, int key) {
        this.p0 = p;
        switch (key) {
            case 0: {
                this.mode = 0;
                break;
            }
            case 72: {
                this.mode = 1;
                break;
            }
            case 86: {
                this.mode = 2;
                break;
            }
            case 82: {
                this.mode = 3;
                break;
            }
            case 90: {
                this.mode = 0;
            }
        }
    }

    public void drag(Point2D.Double p, int region, int key) {
        if (key != this.previousKey) {
            this.keyChange(p, key);
            this.previousKey = key;
        }
        AProjection proj = this.window.getProjection();
        Point2D.Double center = ((AProjection3DBox)proj).getCenter(this.window);
        switch (this.mode) {
            case 0: {
                double zf = this.p0.distance(center.getX(), center.getY()) / p.distance(center.getX(), center.getY());
                ((AProjection3DBox)proj).zoom(zf);
                this.p0 = p;
                this.window.repaintFromScratch();
                break;
            }
            case 1: {
                double zf = Math.abs((this.p0.getX() - center.getX()) / (p.getX() - center.getX()));
                ((AProjection3DBox)proj).zoomHorizontal(zf);
                this.p0 = p;
                this.window.repaintFromScratch();
                break;
            }
            case 2: {
                double zf = Math.abs((this.p0.getY() - center.getY()) / (p.getY() - center.getY()));
                ((AProjection3DBox)proj).zoomVertical(zf);
                this.p0 = p;
                this.window.repaintFromScratch();
                break;
            }
            case 3: {
                AParameter phiPar = APar.get(proj.getName(), "Phi");
                double height = this.window.getCurrDisp().getHeight();
                double deltaV = p.getY() - this.p0.getY();
                phiPar.setD(this.adjustPhi(phiPar.getD() + 360.0 * deltaV / height));
                this.p0 = p;
                this.window.repaintFromScratch();
            }
        }
    }

    private double adjustPhi(double phi) {
        while (phi < 0.0) {
            phi += 360.0;
        }
        while (phi > 360.0) {
            phi -= 360.0;
        }
        return phi;
    }

    public void stop() {
    }

    public void cancel() {
    }

    public void paint(Graphics2D g) {
        Point2D.Double p = ((AProjection3DBox)this.window.getProjection()).getCenter(this.window);
        g.setColor(Color.red);
        g.fillOval((int)(p.x - (double)(this.d / 2)), (int)(p.y - (double)(this.d / 2)), this.d, this.d);
    }

    public void entered() {
        this.window.setCursor(ACursorFactory.getInstance().getDefaultCursor());
    }

    public void exited() {
        this.window.setCursor(ACursorFactory.getInstance().getDefaultCursor());
    }

    public int getPopupType() {
        return 1;
    }

    public JMenuItem[] getPopupItems() {
        return null;
    }

    public AModifier[] getModifiers() {
        return new AModifier[]{new AModifier(0, false, "Change the volume of the box"), new AModifier(90, false, "Change the volume of the box"), new AModifier(72, false, "Change the length of the box"), new AModifier(86, false, "Change the height of the box"), new AModifier(82, false, "Rotate around axis of box")};
    }
}

