/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.graphics.AGraphics;
import atlantis.interactions.AInteraction;
import atlantis.interactions.ALineSegment;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class AClockInteraction
extends AInteraction
implements ASleepMouseDragListener {
    private ALineSegment line;
    private double phi;

    public AClockInteraction() {
        super(1, 4, 1, false);
        double phi = Math.toRadians(APar.get("YX", "Phi").getD());
        this.line = new ALineSegment(0.0, 0.0, 1500.0 * Math.cos(phi), 1500.0 * Math.sin(phi), 10.0);
        this.hr[0] = this.line;
    }

    public RectangularShape getScreenHotRegion(int region) {
        if (region == 0) {
            return new ALineSegment(this.window.calculateDisplay(this.line.p1), this.window.calculateDisplay(this.line.p2), 10.0);
        }
        return null;
    }

    public int init(Point2D.Double p, int key) {
        return 1;
    }

    public int getButton() {
        return 0;
    }

    public void start(Point2D.Double p, int region, int key) {
        if (region == 0) {
            APar.get("YX", "Clock").setD(1.0E-7);
        } else if (region == 1) {
            AProjection2D projection = (AProjection2D)this.window.getProjection();
            Point2D.Double p0 = projection.inverseNonLinearTransform(p);
            this.phi = Math.atan2(p0.y, p0.x);
        }
    }

    public void drag(Point2D.Double p, int region, int key) {
        if (region == 0) {
            double phi = Math.atan2(p.y, p.x);
            if (phi < 0.0) {
                phi += Math.PI * 2;
            }
            APar.get("YX", "Phi").setD(Math.toDegrees(phi));
        } else if (region == 1 && APar.get("YX", "Clock").getStatus()) {
            double deltaPhi;
            double phi0;
            double phiPrime = Math.atan2(p.y, p.x);
            double deltaPhiPrime = phiPrime - (phi0 = Math.toRadians(APar.get("YX", "Phi").getD()));
            if (deltaPhiPrime < -Math.PI) {
                deltaPhiPrime += Math.PI * 2;
            }
            if (deltaPhiPrime > Math.PI) {
                deltaPhiPrime -= Math.PI * 2;
            }
            if ((deltaPhi = this.phi - phi0) < -Math.PI) {
                deltaPhi += Math.PI * 2;
            }
            if (deltaPhi > Math.PI) {
                deltaPhi -= Math.PI * 2;
            }
            if (deltaPhi > 0.0 && deltaPhiPrime - deltaPhi > 0.0 || deltaPhi < 0.0 && deltaPhiPrime - deltaPhi < 0.0) {
                double a = (deltaPhi * Math.PI - deltaPhiPrime * Math.abs(deltaPhi)) / (deltaPhiPrime - deltaPhi);
                APar.get("YX", "Clock").setD(Math.min(Math.max(Math.PI / a, 1.0E-6), 7.0));
            } else {
                APar.get("YX", "Clock").setD(1.0E-6);
            }
        }
    }

    public void stop() {
    }

    public void cancel() {
    }

    public void paint(Graphics2D g) {
        double phi = Math.toRadians(APar.get("YX", "Phi").getD());
        this.line.p2.setLocation(1500.0 * Math.cos(phi), 1500.0 * Math.sin(phi));
        ALineSegment screenLine = (ALineSegment)this.getScreenHotRegion(0);
        AGraphics ag = AGraphics.makeAGraphics(g);
        ag.updateDrawParameters(frameDrawParameters);
        ag.drawLine(screenLine.p1.x, screenLine.p1.y, screenLine.p2.x, screenLine.p2.y);
        ag.updateDrawParameters(drawParameters);
        ag.drawLine(screenLine.p1.x, screenLine.p1.y, screenLine.p2.x, screenLine.p2.y);
    }
}

