/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.interactions.AFishEyeChangeListener;
import atlantis.interactions.AFishEyeInteraction;
import atlantis.interactions.AInteractionGroup;
import atlantis.interactions.AInteractionsManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AFishEyeGroup
extends AInteractionGroup
implements AFishEyeChangeListener {
    private final AFishEyeInteraction fishEyeInteraction = new AFishEyeInteraction();
    private final JCheckBox checkbox;
    private final JFormattedTextField valueField;
    private JPanel additionalControls;
    private NumberFormat valueFormat;
    private JLabel valueLabel;
    private static String valueString = "Value: ";

    public AFishEyeGroup(AInteractionsManager iManager) {
        super(0, iManager);
        this.addInteraction(this.fishEyeInteraction);
        this.additionalControls = new JPanel();
        this.checkbox = new JCheckBox("on/off", false);
        this.checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                switch (e.getStateChange()) {
                    case 1: {
                        AFishEyeGroup.this.fishEyeInteraction.setStatus(true);
                        break;
                    }
                    case 2: {
                        AFishEyeGroup.this.fishEyeInteraction.setStatus(false);
                    }
                }
                ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
            }
        });
        this.valueLabel = new JLabel(valueString);
        this.valueFormat = NumberFormat.getNumberInstance();
        this.valueFormat.setMaximumIntegerDigits(2);
        this.valueField = new JFormattedTextField(this.valueFormat);
        this.valueField.setToolTipText("Enter fish eye value between 0 and 25");
        this.valueField.setValue(new Double(0.0));
        this.valueField.setColumns(3);
        this.valueField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Number value = (Number)AFishEyeGroup.this.valueField.getValue();
                double dvalue = value.doubleValue();
                if (dvalue > 0.0 && dvalue < 25.0) {
                    AFishEyeGroup.this.fishEyeInteraction.setValue(dvalue);
                    ACanvas.getCanvas().getCurrentWindow().repaintFromScratch();
                } else {
                    Double val = new Double(AFishEyeGroup.this.fishEyeInteraction.getValue());
                    AFishEyeGroup.this.valueField.setValue(val);
                }
            }
        });
        JPanel nestedPanel = new JPanel();
        nestedPanel.add(this.valueLabel);
        nestedPanel.add(this.valueField);
        JPanel borderPanel = new JPanel(new BorderLayout());
        borderPanel.add((Component)this.checkbox, "West");
        borderPanel.add((Component)nestedPanel, "East");
        this.additionalControls.add(borderPanel);
    }

    public void connect() {
        super.connect();
        this.fishEyeInteraction.addFishEyeChangeListener(this);
    }

    public void fishEyeChange(boolean status, double value) {
        this.valueField.setValue(value);
        this.checkbox.setSelected(status);
    }

    public boolean hasAdditionalControls() {
        return true;
    }

    public JPanel getAdditionalControls() {
        return this.additionalControls;
    }
}

