/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.gui.ACursorFactory;
import atlantis.interactions.AEnterExitListener;
import atlantis.interactions.AFishEyeChangeListener;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AModifier;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionXZ;
import atlantis.projection.AProjectionYX;
import atlantis.projection.AProjectionYZ;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.JMenuItem;

public class AFishEyeInteraction
extends AInteraction
implements ASleepMouseDragListener,
ActionListener,
AEnterExitListener {
    private Vector<AFishEyeChangeListener> fishEyeChangeListeners = new Vector();
    private final int d = 20;
    private final int region = 0;
    private Point2D.Double firstP;
    private JMenuItem[] popupItems;
    private static final String TOGGLE_FISHEYE = "Fish Eye On/Off";

    public AFishEyeInteraction() {
        super(1, 4, 1, false);
        this.hr[0] = new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0);
        this.popupItems = new JMenuItem[]{new JMenuItem(TOGGLE_FISHEYE)};
        for (int i = 0; i < this.popupItems.length; ++i) {
            this.popupItems[i].addActionListener(this);
        }
    }

    public int init(Point2D.Double p, int key) {
        AProjection2D projection = (AProjection2D)this.window.getProjection();
        this.firstP = new Point2D.Double(Math.abs(p.x), Math.abs(p.y));
        this.firstP = projection.inverseNonLinearTransform(this.firstP);
        return 0;
    }

    public int getButton() {
        return 0;
    }

    private AParameter getParameter(String name) {
        AProjection projection = this.window.getProjection();
        if (projection instanceof AProjectionYX) {
            return APar.get("YX", name);
        }
        if (projection instanceof AProjectionRZ) {
            return APar.get("RZ", name);
        }
        if (projection instanceof AProjection3D) {
            return APar.get("3D", name);
        }
        if (projection instanceof AProjectionYZ || projection instanceof AProjectionXZ) {
            return APar.get("XZ", name);
        }
        if (projection instanceof AProjectionFR) {
            return APar.get("FR", name);
        }
        if (projection instanceof AProjectionFZ) {
            return APar.get("FZ", name);
        }
        throw new Error("Fish Eye should be used ONLY in YX, RZ, FZ and FR");
    }

    private void updateYX(Point2D.Double p, int key) {
        double r1 = Math.sqrt(this.firstP.x * this.firstP.x + this.firstP.y * this.firstP.y);
        double r2 = Math.sqrt(p.x * p.x + p.y * p.y);
        double rTo = this.getParameter("rTo").getD();
        if (r1 < rTo && r2 > rTo) {
            return;
        }
        if (r2 < rTo && r1 > rTo) {
            return;
        }
        double newFishEyeValue = 1000.0 * (r2 - r1) / (r1 * rTo - r1 * r2);
        if (newFishEyeValue < 0.0 || newFishEyeValue > 25.0) {
            return;
        }
        this.setValue(newFishEyeValue);
        this.fireFishEyeChange(this.getStatus(), this.getValue());
    }

    private void updateRZ(Point2D.Double p, int key) {
        double newFishEyeValue = 0.0;
        switch (key) {
            case 0: 
            case 70: 
            case 72: {
                double z1 = this.firstP.x;
                double z2 = Math.abs(p.x);
                double zTo = this.getParameter("zTo").getD();
                if (z1 < zTo && z2 > zTo) {
                    return;
                }
                if (z2 < zTo && z1 > zTo) {
                    return;
                }
                newFishEyeValue = 1000.0 * (z2 - z1) / (z1 * zTo - z1 * z2);
                break;
            }
            case 86: {
                double r1 = Math.abs(this.firstP.y);
                double r2 = Math.abs(p.y);
                double rTo = this.getParameter("rTo").getD();
                if (r1 < rTo && r2 > rTo) {
                    return;
                }
                if (r2 < rTo && r1 > rTo) {
                    return;
                }
                newFishEyeValue = 1000.0 * (r2 - r1) / (r1 * rTo - r1 * r2);
            }
        }
        if (newFishEyeValue < 0.0 || newFishEyeValue > 25.0) {
            return;
        }
        this.setValue(newFishEyeValue);
        this.fireFishEyeChange(this.getStatus(), this.getValue());
    }

    private void updateXZ(Point2D.Double p, int key) {
        double newFishEyeValue = 0.0;
        switch (key) {
            case 0: 
            case 70: 
            case 72: {
                double z1 = this.firstP.x;
                double z2 = Math.abs(p.x);
                double zTo = this.getParameter("zTo").getD();
                if (z1 < zTo && z2 > zTo) {
                    return;
                }
                if (z2 < zTo && z1 > zTo) {
                    return;
                }
                newFishEyeValue = 1000.0 * (z2 - z1) / (z1 * zTo - z1 * z2);
                break;
            }
            case 86: {
                double r1 = Math.abs(this.firstP.y);
                double r2 = Math.abs(p.y);
                double rTo = this.getParameter("yTo").getD();
                if (r1 < rTo && r2 > rTo) {
                    return;
                }
                if (r2 < rTo && r1 > rTo) {
                    return;
                }
                newFishEyeValue = 1000.0 * (r2 - r1) / (r1 * rTo - r1 * r2);
            }
        }
        if (newFishEyeValue < 0.0 || newFishEyeValue > 25.0) {
            return;
        }
        this.setValue(newFishEyeValue);
        this.fireFishEyeChange(this.getStatus(), this.getValue());
    }

    private void updateFR(Point2D.Double p, int key) {
        double r1 = this.firstP.x;
        double r2 = p.x;
        double rTo = this.getParameter("rTo").getD();
        if (r1 < rTo && r2 > rTo) {
            return;
        }
        if (r2 < rTo && r1 > rTo) {
            return;
        }
        double newFishEyeValue = 1000.0 * (r2 - r1) / (r1 * rTo - r1 * r2);
        if (newFishEyeValue < 0.0 || newFishEyeValue > 25.0) {
            return;
        }
        this.setValue(newFishEyeValue);
        this.fireFishEyeChange(this.getStatus(), this.getValue());
    }

    private void updateFZ(Point2D.Double p, int key) {
        double z1 = Math.abs(this.firstP.x);
        double z2 = Math.abs(p.x);
        double zTo = this.getParameter("zTo").getD();
        if (z1 < zTo && z2 > zTo) {
            return;
        }
        if (z2 < zTo && z1 > zTo) {
            return;
        }
        double newFishEyeValue = 1000.0 * (z2 - z1) / (z1 * zTo - z1 * z2);
        if (newFishEyeValue < 0.0 || newFishEyeValue > 25.0) {
            return;
        }
        this.setValue(newFishEyeValue);
        this.fireFishEyeChange(this.getStatus(), this.getValue());
    }

    public void drag(Point2D.Double p, int region, int key) {
        if (!this.getParameter("FishEye").getStatus()) {
            return;
        }
        AProjection proj = this.window.getProjection();
        if (proj instanceof AProjectionYX) {
            this.updateYX(p, key);
        } else if (proj instanceof AProjectionRZ || proj instanceof AProjection3D) {
            this.updateRZ(p, key);
        } else if (proj instanceof AProjectionXZ || proj instanceof AProjectionYZ) {
            this.updateXZ(p, key);
        } else if (proj instanceof AProjectionFR) {
            this.updateFR(p, key);
        } else if (proj instanceof AProjectionFZ) {
            this.updateFZ(p, key);
        }
    }

    public void stop() {
    }

    public void start(Point2D.Double p, int region, int key) {
    }

    public void cancel() {
    }

    public void paint(Graphics2D g) {
    }

    public int getPopupType() {
        return 1;
    }

    public JMenuItem[] getPopupItems() {
        return this.popupItems;
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(TOGGLE_FISHEYE)) {
            this.setStatus(!this.getStatus());
            this.window.repaintFromScratch();
            this.fireFishEyeChange(this.getStatus(), this.getValue());
        }
    }

    public void setValue(double value) {
        this.getParameter("FishEye").setD(value);
    }

    public double getValue() {
        return this.getParameter("FishEye").getD();
    }

    public void setStatus(boolean status) {
        this.getParameter("FishEye").setStatus(status);
    }

    public boolean getStatus() {
        return this.getParameter("FishEye").getStatus();
    }

    public void entered() {
        this.window.setCursor(ACursorFactory.getInstance().getFishEyeCursor());
    }

    public void exited() {
        this.window.setCursor(ACursorFactory.getInstance().getDefaultCursor());
    }

    public AModifier[] getModifiers() {
        if (this.window.getProjection() instanceof AProjectionRZ || this.window.getProjection() instanceof AProjectionXZ) {
            return new AModifier[]{new AModifier(70, false, "Fast (data not drawn)"), new AModifier(86, false, "Vertically defined FishEye"), new AModifier(0, false, "Horizontally defined FishEye"), new AModifier(72, false, "Horizontally defined FishEye")};
        }
        return new AModifier[]{new AModifier(70, false, "Fast (data not drawn)")};
    }

    public void addFishEyeChangeListener(AFishEyeChangeListener listener) {
        this.fishEyeChangeListeners.addElement(listener);
        listener.fishEyeChange(this.getStatus(), this.getValue());
    }

    public void removeFishEyeChangeListener(AFishEyeChangeListener listener) {
        this.fishEyeChangeListeners.removeElement(listener);
    }

    private void fireFishEyeChange(boolean status, double value) {
        for (AFishEyeChangeListener listener : this.fishEyeChangeListeners) {
            listener.fishEyeChange(status, value);
        }
    }
}

