/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.AWindow;
import atlantis.graphics.ADrawParameters;
import atlantis.graphics.AGraphics;
import atlantis.gui.APopupHelper;
import atlantis.interactions.AInteractionsManager;
import atlantis.interactions.AModifier;
import atlantis.utils.APolygon;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AInteraction {
    public static final int NO_REPAINT = 0;
    public static final int AUTOMATIC_REPAINT = 1;
    public static final int ALL_WINDOWS_REPAINT = 3;
    public static final int WINDOW_TOTAL_REPAINT = 4;
    public static final int SCREEN_COORDINATES = 0;
    public static final int WORLD_COORDINATES = 1;
    protected static final ADrawParameters frameDrawParameters = new ADrawParameters(true, 26, 4, 1, 1, 0);
    protected static final ADrawParameters drawParameters = new ADrawParameters(true, 0, 4, 1, 0, 0);
    protected AWindow window;
    protected static final int ctrlPtSize = 1;
    protected RectangularShape[] hr;
    protected Point2D.Double[] pt;
    protected Rectangle oldAffectedRegion;
    protected int hotRegionsCount;
    protected int repaintMode;
    protected int coordinatesType;
    protected boolean isPrintable;

    public AInteraction(int hotRegionsCount, int repaintMode, int coordinatesType, boolean isPrintable) {
        this.hotRegionsCount = hotRegionsCount;
        this.repaintMode = repaintMode;
        this.coordinatesType = coordinatesType;
        this.isPrintable = isPrintable;
        this.hr = new RectangularShape[hotRegionsCount];
    }

    public void connect(AInteractionsManager manager) {
        this.window = manager.getWindow();
    }

    public void disconnect() {
        this.window = null;
    }

    public abstract void paint(Graphics2D var1);

    public RectangularShape getScreenHotRegion(int region) {
        switch (this.coordinatesType) {
            case 0: {
                return this.hr[region];
            }
            case 1: {
                RectangularShape screenShape = (RectangularShape)this.hr[region].clone();
                Point2D.Double center = this.window.calculateDisplay(screenShape.getCenterX(), screenShape.getCenterY());
                double w = screenShape.getWidth();
                double h = screenShape.getHeight();
                screenShape.setFrame(center.x - w / 2.0, center.y - w / 2.0, w, h);
                return screenShape;
            }
        }
        return null;
    }

    public APolygon getAPolygon() {
        APolygon p = new APolygon();
        for (int i = 0; i < 4; ++i) {
            p.addPoint(this.hr[i].getCenterX(), this.hr[i].getCenterY());
        }
        return p;
    }

    protected void setCenterX(RectangularShape shape, double x) {
        double w = shape.getWidth();
        double h = shape.getHeight();
        shape.setFrame(x - w / 2.0, shape.getY(), w, h);
    }

    protected void setCenterY(RectangularShape shape, double y) {
        double w = shape.getWidth();
        double h = shape.getHeight();
        shape.setFrame(shape.getX(), y - h / 2.0, w, h);
    }

    protected void setCenter(RectangularShape shape, double x, double y) {
        double w = shape.getWidth();
        double h = shape.getHeight();
        shape.setFrame(x - w / 2.0, y - h / 2.0, w, h);
    }

    public Point2D.Double getCenter(RectangularShape s) {
        return new Point2D.Double(s.getCenterX(), s.getCenterY());
    }

    protected double getRadius(int region1, int region2) {
        double dx = this.hr[region1].getCenterX() - this.hr[region2].getCenterX();
        double dy = this.hr[region1].getCenterX() - this.hr[region2].getCenterY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected double getRadius(double x, double y, int region) {
        double dx = x - this.hr[region].getCenterX();
        double dy = y - this.hr[region].getCenterY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected double getRadius(RectangularShape s) {
        return s.getCenterX() * s.getCenterX() + s.getCenterY() * s.getCenterY();
    }

    protected double getAngle(int region1, int region2) {
        double dx = this.hr[region1].getCenterX() - this.hr[region2].getCenterX();
        double dy = this.hr[region1].getCenterY() - this.hr[region2].getCenterY();
        if (dx != 0.0 || dy != 0.0) {
            return Math.atan2(dx, dy);
        }
        return 0.0;
    }

    protected void drawActivePoint(double x, double y, AGraphics g) {
        g.updateDrawParameters(frameDrawParameters);
        g.drawSymbol(x, y);
        g.updateDrawParameters(drawParameters);
        g.drawSymbol(x, y);
    }

    protected void drawActivePoint(int region, AGraphics g) {
        g.updateDrawParameters(frameDrawParameters);
        g.drawSymbol(this.hr[region].getCenterX(), this.hr[region].getCenterY());
        g.updateDrawParameters(drawParameters);
        g.drawSymbol(this.hr[region].getCenterX(), this.hr[region].getCenterY());
    }

    protected void drawLine(int region1, int region2, AGraphics g) {
        g.drawLine(this.hr[region1].getCenterX(), this.hr[region1].getCenterY(), this.hr[region2].getCenterX(), this.hr[region2].getCenterY());
    }

    public boolean isPrintable() {
        return this.isPrintable;
    }

    public AModifier[] getModifiers() {
        return new AModifier[0];
    }

    public void showPopupMenu(Point p, int region) {
        APopupHelper.showPopupMenu(p, this.window, this.getPopupItems());
    }

    public JPopupMenu getPopupMenu() {
        return APopupHelper.getPopupMenu(this.getPopupItems());
    }

    public JMenuItem[] getPopupItems() {
        return null;
    }
}

