/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionsManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public abstract class AInteractionGroup {
    public static final int WINDOW_GROUP = 0;
    public static final int CANVAS_GROUP = 1;
    protected String name;
    protected String toolTip;
    protected AInteractionsManager iManager;
    private int groupType;
    private boolean isCurrent = false;
    private Vector<AInteraction> interactions;

    public AInteractionGroup(int groupType, AInteractionsManager iManager) {
        this.groupType = groupType;
        this.iManager = iManager;
        this.interactions = new Vector();
    }

    public void setGroupName(String name) {
        this.name = name;
    }

    public String getGroupName() {
        return this.name;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public JMenuItem getPopupItem() {
        JMenuItem item = new JMenuItem(this.name);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar().setSelectedGroup(AInteractionGroup.this.name);
            }
        });
        return item;
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public boolean isWindowGroup() {
        return this.groupType == 0;
    }

    public boolean isCanvasGroup() {
        return this.groupType == 1;
    }

    public boolean hasAdditionalControls() {
        return false;
    }

    public JPanel getAdditionalControls() {
        return new JPanel();
    }

    protected void addInteraction(AInteraction i) {
        this.interactions.addElement(i);
        if (this.isCurrent) {
            this.iManager.setContext(this);
        }
    }

    protected void removeInteraction(AInteraction i) {
        this.interactions.remove(i);
    }

    protected void removeAllInteractions() {
        this.interactions.clear();
    }

    public Vector getInteractions() {
        return this.interactions;
    }

    public void setGroupState(AInteractionGroup givenGroup) {
    }
}

