/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.gui.AEventQueue;
import atlantis.gui.APointerPositionWindow;
import atlantis.gui.APreferencesControl;
import atlantis.interactions.AEnterExitListener;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionGroup;
import atlantis.interactions.AModifier;
import atlantis.interactions.AMouseDragListener;
import atlantis.interactions.AMousePressListener;
import atlantis.interactions.APickInteraction;
import atlantis.interactions.ASelection;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.interactions.AZMRInteraction;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.projection.AProjectionTrackResidual;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.AUtilities;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class AInteractionsManager
implements MouseListener,
MouseMotionListener,
WindowFocusListener {
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int RIGHT = 2;
    public static final int ALL = 3;
    private static final int safetySize = 5;
    private AWindow window;
    private LinkedList interactions;
    private AInteraction dragInter;
    private int dragInterHotRegion;
    private RectangularShape[] old_hr;
    private AInteractionGroup previousInterface;
    private AModifier[] mouseModifiers;
    private boolean origAlias = false;

    public AInteractionsManager(AWindow _window) {
        this.window = _window;
        this.interactions = new LinkedList();
        this.window.addMouseListener(this);
        this.window.addMouseMotionListener(this);
        this.mouseModifiers = new AModifier[]{new AModifier(79, true, "Output of pointer position"), new AModifier(87, true, "Window Menu pops up"), new AModifier(73, true, "Interaction Manager pops up"), new AModifier(0, true, "Interaction Menu pops up")};
    }

    public AModifier[] getMouseModifiers() {
        return this.mouseModifiers;
    }

    public void mousePressed(MouseEvent e) {
        if (!ACanvas.getCanvas().getCurrentWindow().equals(this.window)) {
            ACanvas.getCanvas().setCurrentWindow(this.window.getName());
        }
        if (AUtilities.isIntRightMouseButton(e)) {
            switch (AEventQueue.getKeyboardState()) {
                case 87: {
                    if (!(this.window.getProjection() instanceof AProjectionTrackResidual)) {
                        AWindow.getPopupMenu().show(this.window, e.getX(), e.getY());
                    }
                    return;
                }
                case 73: {
                    JPopupMenu menu = AProjectionsManager.getInteractionMenu(this.window);
                    menu.show(this.window, e.getX(), e.getY());
                    return;
                }
                case 79: {
                    Point2D.Double position = this.window.calculateUser(e.getX(), e.getY());
                    if (this.window.getProjection() instanceof AProjectionLegoPlot) {
                        position.x = -AProjectionLegoPlot.adjustPhi(this.window, -position.x, position.y);
                    }
                    if (this.window.getProjection() instanceof AProjection2D) {
                        position = ((AProjection2D)this.window.getProjection()).inverseNonLinearTransform(position);
                    }
                    String positionX = this.window.getProjection().getXLabel() + this.parseUnits(position.x, this.window.getProjection().getXUnits());
                    String positionY = this.window.getProjection().getYLabel() + this.parseUnits(position.y, this.window.getProjection().getYUnits());
                    APreferencesControl.setPosMenuItem(true);
                    APointerPositionWindow.getInstance().toFront();
                    APointerPositionWindow.append(positionX + ", " + positionY + "\n");
                    return;
                }
            }
        }
        this.processMousePressed(e);
        if (this.dragInter != null) {
            this.dragInter.hr = this.old_hr;
            ((AMouseDragListener)((Object)this.dragInter)).cancel();
            this.repaintInteraction(this.dragInter);
            this.dragInter = null;
            return;
        }
        if (AUtilities.isIntRightMouseButton(e) && this.processPopupShow(e)) {
            return;
        }
        if (this.setupDraggingByHotRegion(e)) {
            return;
        }
        if (this.initializeSleepingInteraction(e)) {
            return;
        }
    }

    private boolean processPopupShow(MouseEvent e) {
        AInteraction interaction;
        int i;
        for (i = this.interactions.size() - 1; i >= 0; --i) {
            interaction = (AInteraction)this.interactions.get(i);
            for (int region = 0; region < interaction.hr.length; ++region) {
                if (!interaction.getScreenHotRegion(region).contains(e.getPoint())) continue;
                interaction.showPopupMenu(e.getPoint(), region);
                return true;
            }
        }
        for (i = this.interactions.size() - 1; i >= 0; --i) {
            int it;
            interaction = (AInteraction)this.interactions.get(i);
            JMenuItem[] projmenu = interaction instanceof APickInteraction ? null : this.window.getProjection().getPopupItems();
            JMenuItem[] intmenu = interaction instanceof APickInteraction ? null : interaction.getPopupItems();
            JPopupMenu finalmenu = new JPopupMenu();
            for (it = 0; intmenu != null && it < intmenu.length; ++it) {
                finalmenu.add(intmenu[it]);
            }
            if (projmenu != null && projmenu.length > 0 && intmenu != null && intmenu.length > 0) {
                finalmenu.addSeparator();
            }
            for (it = 0; projmenu != null && it < projmenu.length; ++it) {
                finalmenu.add(projmenu[it]);
            }
            if (finalmenu.getComponentCount() == 0) continue;
            finalmenu.show(this.window, (int)e.getPoint().getX(), (int)e.getPoint().getY());
        }
        return false;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragInter != null) {
            ((AMouseDragListener)((Object)this.dragInter)).stop();
            this.repaintInteraction(this.dragInter);
            this.dragInter = null;
        }
        if (this.origAlias && !(this.dragInter instanceof ASelection)) {
            APreferencesControl.setAliasMenuItem(true);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        for (int i = this.interactions.size() - 1; i >= 0; --i) {
            AInteraction interaction = (AInteraction)this.interactions.get(i);
            if (!(interaction instanceof AEnterExitListener)) continue;
            ((AEnterExitListener)((Object)interaction)).entered();
        }
    }

    public void mouseExited(MouseEvent e) {
        for (int i = this.interactions.size() - 1; i >= 0; --i) {
            AInteraction interaction = (AInteraction)this.interactions.get(i);
            if (!(interaction instanceof AEnterExitListener)) continue;
            ((AEnterExitListener)((Object)interaction)).exited();
        }
    }

    public void processMousePressed(MouseEvent e) {
        if (!(this.dragInter instanceof ASelection)) {
            this.origAlias = APreferencesControl.getAliasMenuItem();
        }
        for (int i = this.interactions.size() - 1; i >= 0; --i) {
            AMousePressListener clickListener;
            AInteraction interaction = (AInteraction)this.interactions.get(i);
            if (!(interaction instanceof AMousePressListener) || (clickListener = (AMousePressListener)((Object)interaction)).getPressButton() != 3 && clickListener.getPressButton() != this.getButton(e)) continue;
            Point2D.Double p = null;
            switch (interaction.coordinatesType) {
                case 0: {
                    p = new Point2D.Double(e.getX(), e.getY());
                    break;
                }
                case 1: {
                    p = this.window.calculateUser(e.getPoint());
                }
            }
            clickListener.pressed(p, this.getButton(e), AEventQueue.getKeyboardState());
            this.setTopZOrder(interaction);
            this.repaintInteraction(interaction);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragInter == null) {
            return;
        }
        if (this.origAlias && !(this.dragInter instanceof ASelection)) {
            APreferencesControl.setAliasMenuItem(false);
        }
        Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
        if (this.dragInter.coordinatesType == 1) {
            p = this.window.calculateUser(p);
        }
        ((AMouseDragListener)((Object)this.dragInter)).drag(p, this.dragInterHotRegion, AEventQueue.getKeyboardState());
        this.repaintInteraction(this.dragInter);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
        if (this.getWindow().getMousePosition(true) != null) {
            this.mouseEntered(null);
        }
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public LinkedList getInteractions() {
        return this.interactions;
    }

    public AWindow getWindow() {
        return this.window;
    }

    public void forgetContext() {
        if (this.previousInterface != null) {
            this.previousInterface.disconnect();
        }
        for (int i = 0; i < this.interactions.size(); ++i) {
            AInteraction inter = (AInteraction)this.interactions.get(i);
            inter.disconnect();
        }
        this.interactions.clear();
        this.window.repaint();
    }

    public void setContext(AInteractionGroup iFace) {
        this.forgetContext();
        if (iFace != null) {
            Vector iFaceInter = iFace.getInteractions();
            for (int i = 0; i < iFaceInter.size(); ++i) {
                AInteraction inter = (AInteraction)iFaceInter.get(i);
                this.interactions.addLast(inter);
                inter.connect(this);
                this.repaintInteraction(inter);
            }
            iFace.connect();
        }
        this.previousInterface = iFace;
    }

    private void repaintInteraction(AInteraction interaction) {
        switch (interaction.repaintMode) {
            case 0: {
                return;
            }
            case 3: {
                this.window.repaint();
                ACanvas.getCanvas().repaintOthers(this.window);
                return;
            }
            case 4: {
                this.window.repaintFromScratch();
                return;
            }
            case 1: {
                int i;
                Rectangle regionToRedraw = interaction.getScreenHotRegion(0).getBounds();
                for (i = 1; i < interaction.hr.length; ++i) {
                    regionToRedraw.add(interaction.getScreenHotRegion(i).getBounds());
                }
                if (interaction.pt != null && interaction.pt.length != 0) {
                    for (i = 0; i < interaction.pt.length; ++i) {
                        regionToRedraw.add(this.getScreenPointToInclude(interaction, i));
                    }
                }
                regionToRedraw.x -= 5;
                regionToRedraw.y -= 5;
                regionToRedraw.width += 10;
                regionToRedraw.height += 10;
                if (interaction.oldAffectedRegion == null) {
                    this.window.repaint(regionToRedraw);
                } else {
                    this.window.repaint(SwingUtilities.computeUnion(interaction.oldAffectedRegion.x, interaction.oldAffectedRegion.y, interaction.oldAffectedRegion.width, interaction.oldAffectedRegion.height, new Rectangle(regionToRedraw)));
                }
                interaction.oldAffectedRegion = regionToRedraw;
                return;
            }
        }
    }

    private Point2D.Double getScreenPointToInclude(AInteraction interaction, int n) {
        switch (interaction.coordinatesType) {
            case 0: {
                return interaction.pt[n];
            }
            case 1: {
                return this.window.calculateDisplay(interaction.pt[n]);
            }
        }
        return null;
    }

    private boolean setupDraggingByHotRegion(MouseEvent e) {
        for (int i = this.interactions.size() - 1; i >= 0; --i) {
            AMouseDragListener dInter;
            AInteraction interaction = (AInteraction)this.interactions.get(i);
            if (!(interaction instanceof AMouseDragListener) || (dInter = (AMouseDragListener)((Object)interaction)).getButton() != this.getButton(e)) continue;
            for (int j = 0; j < interaction.hr.length; ++j) {
                if (!interaction.getScreenHotRegion(j).contains(e.getPoint())) continue;
                this.dragInter = interaction;
                this.dragInterHotRegion = j;
                this.old_hr = new RectangularShape[this.dragInter.hr.length];
                for (int region = 0; region < this.dragInter.hr.length; ++region) {
                    this.old_hr[region] = (RectangularShape)this.dragInter.hr[region].clone();
                }
                Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
                if (interaction.coordinatesType == 1) {
                    p = this.window.calculateUser(p);
                }
                if (this.dragInter instanceof AZMRInteraction) {
                    ((ASleepMouseDragListener)((Object)this.dragInter)).init(p, AEventQueue.getKeyboardState());
                }
                this.setTopZOrder(this.dragInter);
                ((AMouseDragListener)((Object)this.dragInter)).start(p, this.dragInterHotRegion, AEventQueue.getKeyboardState());
                this.repaintInteraction(this.dragInter);
                return true;
            }
        }
        return false;
    }

    private boolean initializeSleepingInteraction(MouseEvent e) {
        for (int i = this.interactions.size() - 1; i >= 0; --i) {
            ASleepMouseDragListener sdListener;
            AInteraction interaction = (AInteraction)this.interactions.get(i);
            if (!(interaction instanceof ASleepMouseDragListener) || (sdListener = (ASleepMouseDragListener)((Object)interaction)).getButton() != this.getButton(e)) continue;
            this.dragInter = interaction;
            this.old_hr = new RectangularShape[this.dragInter.hr.length];
            for (int region = 0; region < this.dragInter.hr.length; ++region) {
                this.old_hr[region] = (RectangularShape)this.dragInter.hr[region].clone();
            }
            Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
            if (interaction.coordinatesType == 1) {
                p = this.window.calculateUser(p);
            }
            this.dragInterHotRegion = ((ASleepMouseDragListener)((Object)this.dragInter)).init(p, AEventQueue.getKeyboardState());
            this.setTopZOrder(this.dragInter);
            ((AMouseDragListener)((Object)this.dragInter)).start(p, this.dragInterHotRegion, AEventQueue.getKeyboardState());
            this.repaintInteraction(this.dragInter);
            return true;
        }
        return false;
    }

    private void setTopZOrder(AInteraction ineraction) {
        this.interactions.remove(ineraction);
        this.interactions.addLast(ineraction);
        this.repaintInteraction((AInteraction)this.interactions.getLast());
    }

    public int getButton(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            return 0;
        }
        if (SwingUtilities.isMiddleMouseButton(e)) {
            return 1;
        }
        if (AUtilities.isIntRightMouseButton(e)) {
            return 2;
        }
        return -1;
    }

    protected String parseUnits(double d, String units) {
        double abs = Math.abs(d);
        if (units.equals("(cm)")) {
            if (abs >= 100.0) {
                return ": " + Math.rint(1000.0 * d / 100.0) / 1000.0 + " m";
            }
            if (abs >= 1.0) {
                return ": " + Math.rint(1000.0 * d / 1.0) / 1000.0 + " cm";
            }
            if (abs >= 0.1) {
                return ": " + Math.rint(1000.0 * d / 0.1) / 1000.0 + " mm";
            }
            return ": " + Math.rint(d / 1.0E-4) + " um";
        }
        return ": " + Math.rint(1000.0 * d / 1.0) / 1000.0 + units;
    }
}

