/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.utils.AVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ALineSegment
extends RectangularShape
implements PathIterator {
    Point2D.Double p1;
    Point2D.Double p2;
    double thickness;
    int lineNumber;

    public ALineSegment(Point2D.Double p1, Point2D.Double p2, double thickness) {
        this.p1 = p1;
        this.p2 = p2;
        this.thickness = thickness;
    }

    public ALineSegment(double x1, double y1, double x2, double y2, double thickness) {
        this.p1 = new Point2D.Double(x1, y1);
        this.p2 = new Point2D.Double(x2, y2);
        this.thickness = thickness;
    }

    private Point2D.Double[] calculateNodes() {
        AVector v1 = new AVector(this.p1, this.p2).makeUnitary().scale(this.thickness / 2.0).rotate(1.5707963267948966);
        AVector v2 = new AVector(this.p1, this.p2).makeUnitary().scale(this.thickness / 2.0).rotate(-1.5707963267948966);
        Point2D.Double[] p = new Point2D.Double[]{new Point2D.Double(this.p1.x + v1.dx, this.p1.y + v1.dy), new Point2D.Double(this.p2.x + v1.dx, this.p2.y + v1.dy), new Point2D.Double(this.p2.x + v2.dx, this.p2.y + v2.dy), new Point2D.Double(this.p1.x + v2.dx, this.p1.y + v2.dy)};
        return p;
    }

    public Rectangle2D getBounds2D() {
        double maxY;
        double maxX;
        Point2D.Double[] p = this.calculateNodes();
        double minX = maxX = p[0].x;
        double minY = maxY = p[0].y;
        for (int i = 1; i < p.length; ++i) {
            if (p[i].x < minX) {
                minX = p[i].x;
            }
            if (p[i].x > maxX) {
                maxX = p[i].x;
            }
            if (p[i].y < minY) {
                minY = p[i].y;
            }
            if (!(p[i].y > maxY)) continue;
            maxY = p[i].y;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public boolean contains(double x, double y) {
        boolean c = false;
        Point2D.Double[] p = this.calculateNodes();
        int i = 0;
        int j = p.length - 1;
        while (i < p.length) {
            if ((p[i].y <= y && y < p[j].y || p[j].y <= y && y < p[i].y) && x < (p[j].x - p[i].x) * (y - p[i].y) / (p[j].y - p[i].y) + p[i].x) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        this.lineNumber = -1;
        return this;
    }

    public void setFrame(double x, double y, double w, double h) {
    }

    public boolean isEmpty() {
        return false;
    }

    public double getWidth() {
        return this.getBounds2D().getWidth();
    }

    public double getHeight() {
        return this.getBounds2D().getHeight();
    }

    public double getX() {
        return this.getBounds2D().getX();
    }

    public double getY() {
        return this.getBounds2D().getY();
    }

    public int currentSegment(double[] coords) {
        Point2D.Double[] p = this.calculateNodes();
        if (this.lineNumber == -1) {
            coords[0] = p[0].x;
            coords[1] = p[0].y;
            return 0;
        }
        if (this.lineNumber == 4) {
            return 4;
        }
        coords[0] = p[this.lineNumber].x;
        coords[1] = p[this.lineNumber].y;
        return 1;
    }

    public int currentSegment(float[] coords) {
        Point2D.Double[] p = this.calculateNodes();
        if (this.lineNumber == -1) {
            coords[0] = (float)p[0].x;
            coords[1] = (float)p[0].y;
            return 0;
        }
        if (this.lineNumber == 4) {
            return 4;
        }
        coords[0] = (float)p[this.lineNumber].x;
        coords[1] = (float)p[this.lineNumber].y;
        return 1;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.lineNumber > 4;
    }

    public void next() {
        ++this.lineNumber;
    }

    public String toString() {
        return "ALineSegment[" + this.p1.x + ", " + this.p1.y + ", " + this.p2.x + ", " + this.p2.y + "]";
    }
}

