/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.interactions.AInteraction;
import atlantis.interactions.AMousePressListener;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.nge.ANManager;
import atlantis.nge.ANPickDrawer;
import atlantis.nge.ANPickResultPrinter;
import atlantis.nge.ANProjection;
import atlantis.nge.ANProjection3D;
import atlantis.nge.ANProjectionPhysics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class ANZMRInteraction
extends AInteraction
implements ASleepMouseDragListener,
AMousePressListener {
    private Point2D.Double m_last = null;

    public ANZMRInteraction() {
        super(0, 4, 0, false);
    }

    public void paint(Graphics2D g) {
    }

    public void doRotation(double dx, double dy) {
        ANProjection np = ANManager.getManager().getFrameManager(this.window).getTargetProjection();
        if (np instanceof ANProjection3D) {
            ((ANProjection3D)np).dPhi((float)(dx / 4.0));
            ((ANProjection3D)np).dElev((float)(dy / 4.0));
        } else if (np instanceof ANProjectionPhysics) {
            ((ANProjectionPhysics)np).dPhi((float)(dx / 4.0));
            ((ANProjectionPhysics)np).dElev((float)(dy / 4.0));
        }
    }

    public int getButton() {
        return 0;
    }

    public void start(Point2D.Double p, int region, int key) {
        this.m_last = p;
    }

    public void drag(Point2D.Double p, int region, int key) {
        double dx = p.getX() - this.m_last.getX();
        double dy = p.getY() - this.m_last.getY();
        this.doRotation(dx, dy);
        this.m_last = p;
    }

    public void stop() {
    }

    public void cancel() {
    }

    public int init(Point2D.Double p, int key) {
        return -1;
    }

    public int getPressButton() {
        return 3;
    }

    public void pressed(Point2D.Double p, int button, int key) {
        System.out.println("ZMR PRESS: " + p.getX() + ":" + p.getY());
        ANPickDrawer pd = new ANPickDrawer(this.window, this.window.getWidth(), this.window.getHeight(), (int)p.getX(), (int)p.getY(), new ANPickResultPrinter());
        pd.doPick();
    }
}

