/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.interactions.AInteractionGroup;
import atlantis.interactions.AInteractionsManager;
import atlantis.interactions.APickInteraction;
import atlantis.parameters.APar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class APickGroup
extends AInteractionGroup {
    private APickInteraction pickInteraction;
    private JComboBox mode;
    private JPanel additionalControls = new JPanel();
    private static final String HITS = "Event Data";
    private static final String DETECTORS = "Detectors";

    public APickGroup(AInteractionsManager iManager) {
        super(1, iManager);
        this.pickInteraction = new APickInteraction();
        this.addInteraction(this.pickInteraction);
        this.mode = new JComboBox();
        this.mode.addItem(HITS);
        this.mode.addItem(DETECTORS);
        if (APar.get("Event", "PickingMode").getI() == 0) {
            this.mode.setSelectedItem(HITS);
        } else {
            this.mode.setSelectedItem(DETECTORS);
        }
        this.mode.addActionListener(new ModeListener());
        this.additionalControls.add(this.mode);
    }

    public boolean hasAdditionalControls() {
        return true;
    }

    public JPanel getAdditionalControls() {
        return this.additionalControls;
    }

    public JMenuItem getPopupItem() {
        JMenu menu = new JMenu(this.name);
        PopUpListener l = new PopUpListener();
        menu.add(HITS).addActionListener(l);
        menu.add(DETECTORS).addActionListener(l);
        return menu;
    }

    public void connect() {
        super.connect();
        if (APar.get("Event", "PickingMode").getI() == 0) {
            this.mode.setSelectedItem(HITS);
        } else {
            this.mode.setSelectedItem(DETECTORS);
        }
    }

    class ModeListener
    implements ActionListener {
        ModeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (APickGroup.this.mode.getSelectedItem().equals(APickGroup.HITS)) {
                APar.get("Event", "PickingMode").setI(0);
            } else if (APickGroup.this.mode.getSelectedItem().equals(APickGroup.DETECTORS)) {
                APar.get("Event", "PickingMode").setI(1);
            }
        }
    }

    class PopUpListener
    implements ActionListener {
        PopUpListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar().setSelectedGroup(APickGroup.this.name);
            APickGroup.this.mode.setSelectedItem(e.getActionCommand());
            if (e.getActionCommand().equals(APickGroup.HITS)) {
                APar.get("Event", "PickingMode").setI(0);
            } else if (e.getActionCommand().equals(APickGroup.DETECTORS)) {
                APar.get("Event", "PickingMode").setI(1);
            }
        }
    }
}

