/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.ACalorimeterData;
import atlantis.data.AJetData;
import atlantis.data.ALVL1TriggerTowerData;
import atlantis.data.AMuonHitData;
import atlantis.data.ARVxData;
import atlantis.data.ASVxData;
import atlantis.data.ATILEData;
import atlantis.data.ATrackData;
import atlantis.event.AData;
import atlantis.graphics.APickingGraphics2D;
import atlantis.gui.ACursorFactory;
import atlantis.interactions.AEnterExitListener;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AModifier;
import atlantis.interactions.AMousePressListener;
import atlantis.list.AList;
import atlantis.list.AListManager;
import atlantis.nge.ANManager;
import atlantis.nge.ANProjectionPhysics;
import atlantis.parameters.APar;
import atlantis.projection.AProjectionNPhysics;
import atlantis.projection.AProjectionTrackResidual;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class APickInteraction
extends AInteraction
implements AMousePressListener,
AEnterExitListener {
    public APickInteraction() {
        super(0, 0, 0, false);
    }

    public int getPressButton() {
        return 3;
    }

    private void showCaloPulseShapePlot(AList picked, boolean withcurve) {
        Integer i = APickingGraphics2D.getPickedHitIndex();
        if (i != null) {
            ACalorimeterData c = (ACalorimeterData)picked.getSource();
            c.plotPulseShapes(i, withcurve);
        }
    }

    private void showTriggerPulseShapePlot(AList picked) {
        Integer i = APickingGraphics2D.getPickedHitIndex();
        if (i != null) {
            ALVL1TriggerTowerData t = (ALVL1TriggerTowerData)picked.getSource();
            t.plotPulseShapes(i);
        }
    }

    private void ignorePickedItem(AList picked) {
        Integer i = APickingGraphics2D.getPickedHitIndex();
        if (i != null) {
            AData d = picked.getSource();
            String k = d.getStoreGateKey() != null ? ":" + d.getStoreGateKey() : "";
            String m = "\n\n" + d.getNameScreenName() + k + " ID " + d.getIdFromIndex(i) + " (index " + i + ")  will be invisible and ignored " + "(until removed from the Invisible list)";
            AOutput.alwaysAppend(m, "WARNING");
            AListManager.getInstance().addInvisible(picked);
        }
    }

    private void showMuonSector(AList picked) {
        if (picked.getSource() instanceof AMuonHitData) {
            int sector = ((AMuonHitData)picked.getSource()).getSector(picked.getItems()[0]);
            int signRZ = ((AMuonHitData)picked.getSource()).getRZSign(picked.getItems()[0]);
            if (signRZ == -1) {
                sector = (sector + 8) % 16;
            }
            APar.get("YZ", "Phi").setD((double)sector * 22.5);
            this.window.repaintFromScratch();
        }
    }

    private void showTrackResidualPlot(AList picked) {
        AData pickedData = picked.getSource();
        if (pickedData instanceof ATrackData) {
            if (((ATrackData)pickedData).getResidualStatus()) {
                APickingGraphics2D.showTrackResiduals(this.window, APickingGraphics2D.getPickedH(), APickingGraphics2D.getPickedV());
            } else {
                AOutput.append("\nNo residual information available for this track\n", "PICK");
            }
        }
    }

    private void showJetView(AList picked) {
        AData pickedData = picked.getSource();
        if (pickedData instanceof AJetData) {
            String jetWindowName = "B";
            if (!ACanvas.getCanvas().isValidWindowName(jetWindowName)) {
                AOutput.append("\nWindow " + jetWindowName + " is not available in current layout" + "\n", "WARNING");
            } else if (this.window.getName().equals(jetWindowName)) {
                AOutput.append("\nPlease select jet view from a window other than window " + jetWindowName, "WARNING");
            } else {
                AWindow jetWindow = ACanvas.getCanvas().getWindow(jetWindowName);
                AProjectionNPhysics jetProj = (AProjectionNPhysics)AProjectionsManager.getProjection("NPhysics");
                ACanvas.getCanvas().moveToFrontWindow(jetWindowName);
                jetWindow.setProjection(jetProj);
                jetProj.configureFrame(ANManager.getManager().getFrameManager(jetWindow));
                ANProjectionPhysics finalProj = (ANProjectionPhysics)ANManager.getManager().getFrameManager(jetWindow).getTargetProjection();
                AJetData jd = (AJetData)pickedData;
                int index = picked.getItems()[0];
                finalProj.lookAt(jd, index);
            }
        }
    }

    private void setAtlantisPrimaryVertex(AList picked) {
        Integer i = APickingGraphics2D.getPickedHitIndex();
        AData pickedData = picked.getSource();
        double[] vtx = null;
        if (i != null) {
            if (pickedData instanceof ARVxData) {
                vtx = ((ARVxData)pickedData).getVertex(i);
            }
            if (pickedData instanceof ASVxData) {
                vtx = ((ASVxData)pickedData).getVertex(i);
            }
            if (vtx != null) {
                APar.get("Event", "XVtx").setD(vtx[0]);
                APar.get("Event", "YVtx").setD(vtx[1]);
                APar.get("Event", "ZVtx").setD(vtx[2]);
                AOutput.append("\n\nPrimary vertex set: Projection->\u03a6\u03b7:\n  XVtx = " + AMath.d2s(vtx[0], 5) + " cm\n" + "  YVtx = " + AMath.d2s(vtx[1], 5) + " cm\n" + "  ZVtx = " + AMath.d2s(vtx[2], 5) + " cm\n", "WARNING");
            }
        }
    }

    public void pressed(Point2D.Double p, int button, int key) {
        Point ps = null;
        Point pw = null;
        int pickingMode = APar.get("Event", "PickingMode").getI();
        if (button == 0) {
            if (key == 67) {
                AListManager.getInstance().clearHighlightAndMassCalculation();
            } else {
                AList picked;
                Rectangle bounds = this.window.getBounds();
                bounds.setLocation(0, 0);
                this.window.paintWindowFromScratch(new APickingGraphics2D(bounds, pickingMode, new Point((int)p.x, (int)p.y)));
                if (key != 76) {
                    APickingGraphics2D.printPicked();
                }
                if ((picked = APickingGraphics2D.getPickedHit()) != null && pickingMode == 0) {
                    Integer i;
                    AListManager.getInstance().highlight(picked);
                    if (picked.getSource() instanceof ACalorimeterData && key == 0) {
                        this.showCaloPulseShapePlot(picked, true);
                    }
                    if (picked.getSource() instanceof ACalorimeterData && key == 68) {
                        this.showCaloPulseShapePlot(picked, false);
                    }
                    if (picked.getSource() instanceof ATILEData && key == 84 && (i = APickingGraphics2D.getPickedHitIndex()) != null) {
                        ATILEData c = (ATILEData)picked.getSource();
                        c.plotPulseShapesWithTiming(i);
                    }
                    if (picked.getSource() instanceof ALVL1TriggerTowerData && key == 0) {
                        this.showTriggerPulseShapePlot(picked);
                    }
                    if (picked.getSource() instanceof AJetData) {
                        double phi = ((AJetData)picked.getSource()).getPhi(picked.getItems()[0]);
                        APar.get("XZ", "Phi").setD(Math.toDegrees(phi));
                    }
                    switch (key) {
                        case 65: {
                            AListManager.getInstance().add(picked);
                            break;
                        }
                        case 83: {
                            this.showMuonSector(picked);
                            break;
                        }
                        case 78: {
                            APickingGraphics2D.navigatePicked();
                            break;
                        }
                        case 82: {
                            this.showTrackResidualPlot(picked);
                            break;
                        }
                        case 86: {
                            this.setAtlantisPrimaryVertex(picked);
                            break;
                        }
                        case 73: {
                            this.ignorePickedItem(picked);
                            break;
                        }
                        case 74: {
                            if (!APar.get("Prefs", "OpenGL").getStatus()) break;
                            this.showJetView(picked);
                            break;
                        }
                        case 77: {
                            AListManager.getInstance().massCalc(picked);
                            break;
                        }
                        case 76: {
                            AListManager.getInstance().massCalcV0(picked);
                        }
                    }
                } else if (pickingMode == 1) {
                    AListManager.getInstance().clearHighlight();
                }
            }
        } else if (button == 2) {
            Rectangle bounds = this.window.getBounds();
            bounds.setLocation(0, 0);
            this.window.paintWindowFromScratch(new APickingGraphics2D(bounds, 2, new Point((int)p.x, (int)p.y)));
        }
        if (pickingMode != 1) {
            if (APickingGraphics2D.getPickedData() != null || APickingGraphics2D.getPickedResidual() != null) {
                if (this.window == null) {
                    return;
                }
                pw = new Point(APickingGraphics2D.getPickedH(), APickingGraphics2D.getPickedV());
                if (pw.x != 0 && pw.y != 0) {
                    try {
                        ps = new Point(pw);
                        SwingUtilities.convertPointToScreen(ps, this.window);
                        new Robot().mouseMove(ps.x, ps.y);
                    }
                    catch (AWTException e) {}
                } else {
                    AOutput.alwaysAppend("\n\nYou must pick before you can move", "BAD_COMMAND");
                }
            } else if (!(this.window.getProjection() instanceof AProjectionTrackResidual)) {
                AOutput.alwaysAppend("\n\nNothing to pick", "BAD_COMMAND");
            }
        }
    }

    public void paint(Graphics2D g) {
    }

    public void entered() {
        this.window.setCursor(ACursorFactory.getInstance().getPickCursor());
    }

    public void exited() {
        this.window.setCursor(ACursorFactory.getInstance().getDefaultCursor());
    }

    public AModifier[] getModifiers() {
        AModifier[] mods = new AModifier[]{new AModifier(0, false, "Pick"), new AModifier(0, true, "Move to last picked"), new AModifier(65, false, "Add to the current (active) list"), new AModifier(67, false, "Clear highlighted and mass calc lists"), new AModifier(68, false, "Plot ADC counts (digits) only"), new AModifier(84, false, "Plot raw and cell time pulses (TILE only)"), new AModifier(73, false, "Ignore (make invisible) picked hits/tracks"), new AModifier(76, false, "Add to the V0 mass calculation list"), new AModifier(77, false, "Add to the mass calculation list"), new AModifier(78, false, "Navigate (show data associations)"), new AModifier(82, false, "Plot track residuals if available"), new AModifier(83, false, "Select this muon Sector"), new AModifier(86, false, "Set prim.vertex from picked rec/sim vertex"), new AModifier(74, false, "Jet view (OpenGL only)")};
        return mods;
    }
}

