/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.graphics.AGraphics;
import atlantis.gui.ACursorFactory;
import atlantis.interactions.AEnterExitListener;
import atlantis.interactions.ASelection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class ARectangleSelection
extends ASelection
implements AEnterExitListener {
    public ARectangleSelection() {
        super(4);
    }

    public int init(Point2D.Double p, int key) {
        this.isValid = false;
        for (int i = 0; i < 4; ++i) {
            this.setCenter(this.hr[i], p.x, p.y);
        }
        this.region = 2;
        return this.region;
    }

    public void drag(Point2D.Double p, int region, int key) {
        this.isValid = true;
        this.setCenter(this.hr[region], p.x, p.y);
        int oppCtrlPt = (region + 2) % 4;
        double xOpp = this.hr[oppCtrlPt].getCenterX();
        double yOpp = this.hr[oppCtrlPt].getCenterY();
        int otherCtrlPt = p.x < xOpp && p.y > yOpp || p.x > xOpp && p.y < yOpp ? 1 : 3;
        otherCtrlPt = (region + otherCtrlPt) % 4;
        this.setCenter(this.hr[otherCtrlPt], p.x, yOpp);
        otherCtrlPt = (otherCtrlPt + 2) % 4;
        this.setCenter(this.hr[otherCtrlPt], xOpp, p.y);
    }

    public void paint(Graphics2D g) {
        if (!this.isValid) {
            return;
        }
        AGraphics ag = AGraphics.makeAGraphics(g);
        ag.updateDrawParameters(frameDrawParameters);
        ag.drawPolygon(this.getAPolygon());
        ag.updateDrawParameters(drawParameters);
        ag.drawPolygon(this.getAPolygon());
        this.drawActivePoint(this.region, ag);
    }

    public Point2D.Double[] getCorners() {
        int first = this.getUpperLeftRegion();
        int second = (first + 1) % 4;
        int third = (first + 2) % 4;
        return this.convert(first, second, third);
    }

    public void entered() {
        this.window.setCursor(ACursorFactory.getInstance().getRectSelectCursor());
    }

    public void exited() {
        this.window.setCursor(ACursorFactory.getInstance().getDefaultCursor());
    }
}

