/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.data.ACalorimeterData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.gui.ADnDLabel;
import atlantis.gui.ADragListener;
import atlantis.interactions.ARectangleSelection;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.projection.AProjectionYX;
import atlantis.projection.AProjectionYZ;
import atlantis.utils.A3Vector;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class ARectangleVPSelection
extends ARectangleSelection
implements ActionListener,
ADragListener {
    public static final String RUBBERBAND_WHOLE_WINDOW = "Rubberband Whole Window";
    public static final String ZOOM_LAR = "Zoom LAr";
    public static final String ZOOM_CALORIMETERS = "Zoom Calorimeters";
    public static final String CUT_ETAPHI = "Cut  ( \u03b7\u03a6 cut )";
    public static final String PRINT_CONTENTS = "Print Contents";
    public static final String SHOW_IN_3DBOX = "Show in 3DBox";
    public static final String TURN_OFF_ETAPHI_CUT = "Turn off Cut  ( \u03b7\u03a6 cut )";

    public ARectangleVPSelection() {
        this.addActionButton(ZOOM_LAR, this, this);
        this.addActionButton(ZOOM_CALORIMETERS, this, this);
        this.addActionButton(CUT_ETAPHI, this, this);
        this.addActionButton(RUBBERBAND_WHOLE_WINDOW, this, this);
        this.addActionButton(PRINT_CONTENTS, this, this);
        this.addActionButton(SHOW_IN_3DBOX, this, this);
    }

    public JMenuItem[] getPopupItems() {
        JMenuItem item;
        ArrayList<JMenuItem> al = new ArrayList<JMenuItem>();
        if (this.window.getUnzoomPossible()) {
            item = new JMenuItem("Unzoom");
            al.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleVPSelection.this.window.unzoom();
                }
            });
        }
        if (this.window.getUnzoomAllPossible(ZOOM_LAR)) {
            item = new JMenuItem("Unzoom LAr");
            al.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleVPSelection.this.window.unzoom(ARectangleVPSelection.ZOOM_LAR);
                }
            });
        }
        if (this.window.getUnzoomAllPossible(ZOOM_CALORIMETERS)) {
            item = new JMenuItem("Unzoom Calorimeters");
            al.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleVPSelection.this.window.unzoom(ARectangleVPSelection.ZOOM_CALORIMETERS);
                }
            });
        }
        if (this.window.getUnzoomFullPossible()) {
            item = new JMenuItem("Unzoom Full");
            al.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleVPSelection.this.window.unzoomFull();
                }
            });
        }
        JMenuItem rww = new JMenuItem(RUBBERBAND_WHOLE_WINDOW);
        rww.addActionListener(this);
        JMenuItem toec = new JMenuItem(TURN_OFF_ETAPHI_CUT);
        toec.addActionListener(this);
        al.add(rww);
        al.add(toec);
        JMenuItem[] ret = new JMenuItem[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            ret[i] = (JMenuItem)al.get(i);
        }
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (ZOOM_LAR.equals(action)) {
            this.performZoom(ZOOM_LAR);
        } else if (ZOOM_CALORIMETERS.equals(action)) {
            this.performZoom(ZOOM_CALORIMETERS);
        } else if (CUT_ETAPHI.equals(action)) {
            this.applyCutIn(this.window.getName());
        } else if (RUBBERBAND_WHOLE_WINDOW.equals(action)) {
            this.rubberbandWholeWindow();
        } else if (PRINT_CONTENTS.equals(action)) {
            this.performOperationWithCuts(PRINT_CONTENTS);
        } else if (SHOW_IN_3DBOX.equals(action)) {
            this.tracksTo3DBox();
        } else if (TURN_OFF_ETAPHI_CUT.equals(action)) {
            this.turnOffEtaPhiCuts();
        }
    }

    private void turnOffEtaPhiCuts() {
        APar.get("CutsATLAS", "CutPhi").setStatus(false);
        APar.get("CutsATLAS", "CutEta").setStatus(false);
        String warning = "\n\nCuts -> ATLAS -> Cut \u03b7 deactivated\nCuts -> ATLAS -> Cut \u03a6 deactivated\n\n";
        AOutput.append(warning, "WARNING");
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    private void tracksTo3DBox() {
        Point2D.Double[] corners = this.getCorners();
        double eta = (corners[2].x + corners[0].x) / 2.0;
        double phi = (corners[2].y + corners[0].y) / 2.0;
        A3Vector ray = AMath.getCartFromVP(eta, phi, 1.0);
        APar.get("3D", "xAxis").changeScope(2);
        APar.get("3D", "yAxis").changeScope(2);
        APar.get("3D", "zAxis").changeScope(2);
        APar.get("3D", "xAxis").setD(ray.x);
        APar.get("3D", "yAxis").setD(ray.y);
        APar.get("3D", "zAxis").setD(ray.z);
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    public void dragPerformed(Object from, Object to, int action) {
        if (to instanceof ADnDLabel) {
            this.applyCutIn(((ADnDLabel)to).getText());
        } else if (to instanceof AWindow) {
            this.applyCutIn(((AWindow)to).getName());
        }
    }

    private boolean checkEtaPhiCutValues(double eta, double phi, double cutPhi, double cutEta) {
        if (!(APar.get("CutsATLAS", "PhiMiddle").validateValue(phi) && APar.get("CutsATLAS", "EtaMiddle").validateValue(eta) && APar.get("CutsATLAS", "CutPhi").validateValue(cutPhi) && APar.get("CutsATLAS", "CutEta").validateValue(cutEta))) {
            String etaphi = "\u03b7\u03a6";
            AOutput.append("\nOperation cancelled: " + etaphi + " cut values outside allowed range\n", "WARNING");
            return false;
        }
        return true;
    }

    public void applyCutIn(String zoomWindowName) {
        Point2D.Double[] corners = this.getCorners();
        double eta = (corners[2].x + corners[0].x) / 2.0;
        double cutEta = Math.abs(corners[2].x - corners[0].x) / 2.0;
        double phi = (corners[2].y + corners[0].y) / 2.0;
        double cutPhi = Math.abs(corners[2].y - corners[0].y) / 2.0;
        double rhoVPlot = AProjectionVP.getRhoZoomVPlot();
        double zVPlot = AProjectionVP.getZZoomVPlot();
        double zVtx = APar.get("Event", "ZVtx").getD();
        double zLower = Math.max(Math.min(rhoVPlot * AMath.tanLambda(eta - cutEta) + zVtx, 0.0), -zVPlot);
        double zUpper = Math.min(Math.max(rhoVPlot * AMath.tanLambda(eta + cutEta) + zVtx, 0.0), zVPlot);
        if (!this.checkEtaPhiCutValues(eta, phi, cutPhi, cutEta)) {
            return;
        }
        String currentWindowName = this.window.getName();
        APar.selectWindowParameters(zoomWindowName);
        APar.get("CutsATLAS", "PhiMiddle").setD(phi);
        APar.get("CutsATLAS", "EtaMiddle").setD(eta);
        APar.get("CutsATLAS", "CutPhi").setD(cutPhi);
        APar.get("CutsATLAS", "CutPhi").setStatus(true);
        APar.get("CutsATLAS", "CutEta").setD(cutEta);
        APar.get("CutsATLAS", "CutEta").setStatus(true);
        String warning = "\n\nCuts -> ATLAS -> Cut \u03b7 now active\nCuts -> ATLAS -> Cut \u03a6 now active\n\n";
        AOutput.append(warning, "WARNING");
        AWindow zoomWindow = ACanvas.getCanvas().getWindow(zoomWindowName);
        AProjection zoomProjection = zoomWindow.getProjection();
        if (zoomProjection instanceof AProjectionFR) {
            zoomWindow.setUserCorners(0.0, rhoVPlot, phi - cutPhi, phi + cutPhi);
        } else if (zoomProjection instanceof AProjectionFZ) {
            zoomWindow.setUserCorners(zLower, zUpper, phi - cutPhi, phi + cutPhi);
        } else if (zoomProjection instanceof AProjectionVP) {
            if (!zoomWindowName.equals(currentWindowName)) {
                zoomWindow.setUserCorners(eta - cutEta, eta + cutEta, phi - cutPhi, phi + cutPhi);
            }
        } else if (zoomProjection instanceof AProjectionYX) {
            zoomWindow.setUserCorners(-rhoVPlot, rhoVPlot, -rhoVPlot, rhoVPlot);
        } else if (zoomProjection instanceof AProjectionXZ) {
            double rhoZoom = Math.min(rhoVPlot, 110.0);
            zoomWindow.setUserCorners(zLower, zUpper, 0.0, rhoZoom);
            APar.get("XZ", "Phi").setD(AMath.nearestPhiDegrees(phi));
        } else if (zoomProjection instanceof AProjectionYZ) {
            double rhoZoom = Math.min(rhoVPlot, 110.0);
            zoomWindow.setUserCorners(zLower, zUpper, -rhoZoom, rhoZoom);
            APar.get("YZ", "Phi").setD(AMath.nearestPhiDegrees(phi));
        } else if (zoomProjection instanceof AProjectionRZ) {
            zoomWindow.setUserCorners(zLower, zUpper, 0.0, rhoVPlot);
            APar.get("RZ", "Phi").setD(AMath.nearestPhiDegrees(phi));
        }
        APar.restoreWindowParameters();
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    public void performZoom(String typeOfZoom) {
        int i;
        int numberOfWindows = 0;
        if (ZOOM_LAR.equals(typeOfZoom)) {
            numberOfWindows = 4;
        } else if (ZOOM_CALORIMETERS.equals(typeOfZoom)) {
            numberOfWindows = 8;
        }
        AWindow currentWindow = this.window;
        String name = currentWindow.getName();
        currentWindow.saveLayout();
        boolean scaleStatus = currentWindow.getScaleStatus();
        Point2D.Double[] zoomedCorners = this.getCorners();
        this.layoutChange(typeOfZoom);
        int nameIndex = -1;
        for (i = 0; i < numberOfWindows; ++i) {
            String wName = Integer.toString(i + 1);
            AWindow w = ACanvas.getCanvas().getWindow(wName);
            if (w != null && !name.equals(wName)) {
                w.saveParameters(typeOfZoom);
                ACanvas.getCanvas().copyWindowSettings(currentWindow.getName(), wName);
                w.saveCorners(typeOfZoom);
                w.setUserCorners(zoomedCorners);
                w.setScaleStatus(scaleStatus);
                APar.selectWindowParameters(wName);
                APar.get("VP", "Mode").setI(3 + i);
                APar.restoreWindowParameters();
                ACanvas.getCanvas().moveToFrontWindow(w.getName());
                w.repaintFromScratch();
                continue;
            }
            if (!name.equals(wName)) continue;
            nameIndex = i;
        }
        if (nameIndex > 0) {
            currentWindow.saveParameters(typeOfZoom);
            currentWindow.saveCorners(typeOfZoom);
            currentWindow.setUserCorners(zoomedCorners);
            currentWindow.setScaleStatus(scaleStatus);
            APar.selectWindowParameters(name);
            APar.get("VP", "Mode").setI(3 + nameIndex);
            APar.restoreWindowParameters();
            ACanvas.getCanvas().moveToFrontWindow(name);
            currentWindow.repaintFromScratch();
        }
        for (i = 0; i < numberOfWindows; ++i) {
            if (!name.equals(Integer.toString(i + 1))) continue;
            this.invalidate();
        }
    }

    public void layoutChange(String typeOfZoom) {
        if (!ACanvas.getCanvas().getCurrentLayout().getName().equals("SQUARE")) {
            ACanvas.getCanvas().setCurrentLayout("SQUARE");
        }
        AOutput.append("\nWindows changed to: \n", "TITLE");
        AOutput.append("Window 1: ECAL sampling 0\n", "NORMAL");
        AOutput.append("Window 2: ECAL sampling 1\n", "NORMAL");
        AOutput.append("Window 3: ECAL sampling 2\n", "NORMAL");
        AOutput.append("Window 4: ECAL sampling 3\n", "NORMAL");
        if (ZOOM_CALORIMETERS.equals(typeOfZoom)) {
            AOutput.append("Window 5: HCAL sampling 0\n", "NORMAL");
            AOutput.append("Window 6: HCAL sampling 1\n", "NORMAL");
            AOutput.append("Window 7: HCAL sampling 2\n", "NORMAL");
            AOutput.append("Window 8: HCAL sampling 3\n", "NORMAL");
        }
    }

    private void printContents() {
        AEvent event = Atlantis.getEventManager().getCurrentEvent();
        StringBuffer output = new StringBuffer("Data inside Rubberband selection:");
        List hitsAndTracks = event.getHitsAndTracks(this.window.getProjection());
        for (int i = 0; i < hitsAndTracks.size(); ++i) {
            String info = ((AData)hitsAndTracks.get(i)).getVPHitInfo();
            if ("".equals(info)) continue;
            output.append("\n" + info);
        }
        List cal = event.getCalorimeters();
        for (int i = 0; i < cal.size(); ++i) {
            ACalorimeterData calorimeter = (ACalorimeterData)cal.get(i);
            calorimeter.makeDrawList();
            String info = calorimeter.getVPHitInfo();
            if ("".equals(info)) continue;
            output.append("\n" + info);
        }
        AOutput.alwaysAppend("\n" + output + "\n", "PICK");
    }

    private void performOperationWithCuts(String operation) {
        Point2D.Double[] corners = this.getCorners();
        double eta = (corners[2].x + corners[0].x) / 2.0;
        double cutEta = Math.abs(corners[2].x - corners[0].x) / 2.0;
        double phi = (corners[2].y + corners[0].y) / 2.0;
        double cutPhi = Math.abs(corners[2].y - corners[0].y) / 2.0;
        if (!this.checkEtaPhiCutValues(eta, phi, cutPhi, cutEta)) {
            return;
        }
        AParameter phiPar = APar.get("CutsATLAS", "PhiMiddle");
        AParameter cutPhiPar = APar.get("CutsATLAS", "CutPhi");
        AParameter etaPar = APar.get("CutsATLAS", "EtaMiddle");
        AParameter cutEtaPar = APar.get("CutsATLAS", "CutEta");
        double oldEta = etaPar.getD();
        double oldCutEta = cutEtaPar.getD();
        boolean oldCutEtaStatus = cutEtaPar.getStatus();
        double oldPhi = phiPar.getD();
        double oldCutPhi = cutPhiPar.getD();
        boolean oldCutPhiStatus = cutPhiPar.getStatus();
        phiPar.setD(phi);
        etaPar.setD(eta);
        cutPhiPar.setD(cutPhi);
        cutPhiPar.setStatus(true);
        cutEtaPar.setD(cutEta);
        cutEtaPar.setStatus(true);
        if (PRINT_CONTENTS.equals(operation)) {
            this.printContents();
        }
        phiPar.setD(oldPhi);
        etaPar.setD(oldEta);
        cutPhiPar.setD(oldCutPhi);
        cutPhiPar.setStatus(oldCutPhiStatus);
        cutEtaPar.setD(oldCutEta);
        cutEtaPar.setStatus(oldCutEtaStatus);
    }

    public void rubberbandWholeWindow() {
        Rectangle curr = this.window.getCurrDisp();
        double x = curr.getX();
        double y = curr.getY();
        double w = curr.getWidth();
        double h = curr.getHeight();
        this.setCenter(this.hr[0], x, y);
        this.setCenter(this.hr[1], x + w, y);
        this.setCenter(this.hr[2], x + w, y + h);
        this.setCenter(this.hr[3], x, y + h);
        this.isValid = true;
        this.region = 1;
        this.stop();
        this.window.repaint();
        this.oldAffectedRegion = curr;
        int safetySize = 5;
        this.oldAffectedRegion.x -= safetySize;
        this.oldAffectedRegion.y -= safetySize;
        this.oldAffectedRegion.width += 2 * safetySize;
        this.oldAffectedRegion.height += 2 * safetySize;
    }
}

