/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.gui.ADragListener;
import atlantis.interactions.ARectangleSelection;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionsManager;
import atlantis.utils.AOutput;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JMenuItem;

public class ARectangleYXSelection
extends ARectangleSelection
implements ActionListener,
ADragListener {
    public static final String ZOOM_SUMMED = "summed";
    public static final String ZOOM_LAYERS = "layers";

    public ARectangleYXSelection() {
        this.addActionButton("Zoom Summed Endcaps", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Zoom Summed Endcaps")) {
                    ARectangleYXSelection.this.performZoom(ARectangleYXSelection.ZOOM_SUMMED);
                }
            }
        });
        this.addActionButton("Zoom Endcap Layers -", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Zoom Endcap Layers -")) {
                    ARectangleYXSelection.this.zoomLayersMinus();
                }
            }
        });
        this.addActionButton("Zoom Endcap Layers +", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Zoom Endcap Layers +")) {
                    ARectangleYXSelection.this.zoomLayersPlus();
                }
            }
        });
        this.addActionButton("Zoom Both Endcap Layers", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Zoom Both Endcap Layers")) {
                    ARectangleYXSelection.this.zoomLayersCombined();
                }
            }
        });
    }

    public void zoomLayersMinus() {
        APar.get("CutsCalo", "FCAL").setI(0);
        APar.get("CutsCalo", "LAr").setI(0);
        APar.get("CutsCalo", "HEC").setI(-2);
        this.performZoom(ZOOM_LAYERS);
    }

    public void zoomLayersPlus() {
        APar.get("CutsCalo", "FCAL").setI(1);
        APar.get("CutsCalo", "LAr").setI(1);
        APar.get("CutsCalo", "HEC").setI(2);
        this.performZoom(ZOOM_LAYERS);
    }

    public void zoomLayersCombined() {
        APar.get("CutsCalo", "FCAL").setI(-1);
        APar.get("CutsCalo", "LAr").setI(-1);
        APar.get("CutsCalo", "HEC").setI(-1);
        this.performZoom(ZOOM_LAYERS);
    }

    public void performZoom(String typeOfZoom) {
        int i;
        int numberOfWindows = 0;
        if (typeOfZoom.equals(ZOOM_SUMMED)) {
            numberOfWindows = 4;
        } else if (typeOfZoom.equals(ZOOM_LAYERS)) {
            numberOfWindows = 8;
        }
        AWindow currentWindow = this.window;
        String name = currentWindow.getName();
        currentWindow.saveLayout();
        boolean scaleStatus = currentWindow.getScaleStatus();
        Point2D.Double[] zoomedCorners = this.getCorners();
        this.layoutChange(typeOfZoom);
        int nameIndex = -1;
        for (i = numberOfWindows; i >= 1; --i) {
            String wName = Integer.toString(i);
            AWindow w = ACanvas.getCanvas().getWindow(wName);
            if (w != null && !name.equals(wName)) {
                w.saveParameters(typeOfZoom);
                ACanvas.getCanvas().copyWindowSettings(currentWindow.getName(), wName);
                w.saveCorners(typeOfZoom);
                w.setUserCorners(zoomedCorners);
                w.setScaleStatus(scaleStatus);
                APar.selectWindowParameters(wName);
                if (typeOfZoom.equals(ZOOM_SUMMED)) {
                    this.zoomSummedOptions(i - 1);
                } else if (typeOfZoom.equals(ZOOM_LAYERS)) {
                    APar.get("YX", "Mode").setI(12 + i - 1);
                }
                APar.restoreWindowParameters();
                ACanvas.getCanvas().moveToFrontWindow(w.getName());
                w.repaintFromScratch();
                continue;
            }
            if (!name.equals(wName)) continue;
            nameIndex = i;
        }
        if (nameIndex > 0) {
            currentWindow.saveParameters(typeOfZoom);
            currentWindow.saveCorners(typeOfZoom);
            currentWindow.setUserCorners(zoomedCorners);
            currentWindow.setScaleStatus(scaleStatus);
            APar.selectWindowParameters(name);
            if (typeOfZoom.equals(ZOOM_SUMMED)) {
                this.zoomSummedOptions(nameIndex - 1);
            } else if (typeOfZoom.equals(ZOOM_LAYERS)) {
                APar.get("YX", "Mode").setI(12 + nameIndex - 1);
            }
            APar.restoreWindowParameters();
            ACanvas.getCanvas().moveToFrontWindow(name);
            currentWindow.repaintFromScratch();
        }
        for (i = 1; i <= numberOfWindows; ++i) {
            if (!name.equals(Integer.toString(i))) continue;
            this.invalidate();
        }
        if (typeOfZoom.equals(ZOOM_LAYERS)) {
            this.zoomLastWindow(scaleStatus, name);
        }
    }

    public void layoutChange(String typeOfZoom) {
        if (typeOfZoom.equals(ZOOM_SUMMED)) {
            if (!ACanvas.getCanvas().getCurrentLayout().getName().equals("FOUR SQUARES")) {
                ACanvas.getCanvas().setCurrentLayout("FOUR SQUARES");
            }
            AOutput.append("\nWindows changed to:\n", "TITLE");
            AOutput.append("Window 1: LAr Endcap -\n", "NORMAL");
            AOutput.append("Window 2: LAr Endcap +\n", "NORMAL");
            AOutput.append("Window 3: HEC -\n", "NORMAL");
            AOutput.append("Window 4: HEC +\n", "NORMAL");
        } else if (typeOfZoom.equals(ZOOM_LAYERS)) {
            if (!ACanvas.getCanvas().getCurrentLayout().getName().equals("SQUARE")) {
                ACanvas.getCanvas().setCurrentLayout("SQUARE");
            }
            AOutput.append("\nWindows changed to:\n", "TITLE");
            AOutput.append("Window 1: LAr Endcap Presampler\n", "NORMAL");
            AOutput.append("Window 2: LAr Endcap 1\n", "NORMAL");
            AOutput.append("Window 3: LAr Endcap 2\n", "NORMAL");
            AOutput.append("Window 4: LAr Endcap 3\n", "NORMAL");
            AOutput.append("Window 5: HEC 1\n", "NORMAL");
            AOutput.append("Window 6: HEC 2\n", "NORMAL");
            AOutput.append("Window 7: HEC 3\n", "NORMAL");
            AOutput.append("Window 8: HEC 4\n", "NORMAL");
            AOutput.append("Window 9: rhoZ view showing both endcaps\n", "NORMAL");
        }
    }

    public void zoomSummedOptions(int i) {
        APar.get("CutsCalo", "LAr").changeScope(1);
        APar.get("CutsCalo", "HEC").changeScope(1);
        switch (i) {
            case 0: {
                APar.get("CutsCalo", "LAr").setI(0);
                APar.get("CutsCalo", "HEC").setI(-1);
                break;
            }
            case 1: {
                APar.get("CutsCalo", "LAr").setI(1);
                APar.get("CutsCalo", "HEC").setI(-1);
                break;
            }
            case 2: {
                APar.get("CutsCalo", "LAr").setI(-1);
                APar.get("CutsCalo", "HEC").setI(-2);
                break;
            }
            case 3: {
                APar.get("CutsCalo", "LAr").setI(-1);
                APar.get("CutsCalo", "HEC").setI(2);
            }
        }
        APar.get("YX", "Mode").setI(20 + (int)Math.floor(i / 2));
    }

    public void zoomLastWindow(boolean scaleStatus, String name) {
        String wName = Integer.toString(9);
        AWindow w = ACanvas.getCanvas().getWindow(wName);
        AProjection p = AProjectionsManager.getProjection("RZ");
        w.setProjection(p);
        Point2D.Double[] newCorners = new Point2D.Double[]{new Point2D.Double(-650.0, 225.0), new Point2D.Double(650.0, 225.0), new Point2D.Double(650.0, -225.0)};
        w.setUserCorners(newCorners);
        w.setScaleStatus(scaleStatus);
        APar.selectWindowParameters(wName);
        APar.restoreWindowParameters();
        ACanvas.getCanvas().moveToFrontWindow(w.getName());
        w.repaintFromScratch();
        if (name.equals(wName)) {
            this.invalidate();
        }
    }

    public void dragPerformed(Object from, Object to, int action) {
    }

    public JMenuItem[] getPopupItems() {
        JMenuItem it;
        ArrayList<JMenuItem> al = new ArrayList<JMenuItem>();
        if (this.window.getUnzoomPossible()) {
            it = new JMenuItem("Unzoom");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleYXSelection.this.window.unzoom();
                }
            });
            al.add(it);
        }
        if (this.window.getUnzoomAllPossible(ZOOM_LAYERS)) {
            it = new JMenuItem("Unzoom layers");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleYXSelection.this.window.unzoom(ARectangleYXSelection.ZOOM_LAYERS);
                }
            });
            al.add(it);
        }
        if (this.window.getUnzoomAllPossible(ZOOM_SUMMED)) {
            it = new JMenuItem("Unzoom summed");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleYXSelection.this.window.unzoom(ARectangleYXSelection.ZOOM_SUMMED);
                }
            });
            al.add(it);
        }
        if (this.window.getUnzoomFullPossible()) {
            it = new JMenuItem("Unzoom Full");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ARectangleYXSelection.this.window.unzoomFull();
                }
            });
            al.add(it);
        }
        JMenuItem[] ret = new JMenuItem[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            ret[i] = (JMenuItem)al.get(i);
        }
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("Unzoom")) {
            this.window.unzoom();
        }
        if (action.equals("Unzoom layers")) {
            this.window.unzoom(ZOOM_LAYERS);
        }
        if (action.equals("Unzoom summed")) {
            this.window.unzoom(ZOOM_SUMMED);
        }
        if (action.equals("Unzoom Full")) {
            this.window.unzoomFull();
        }
    }
}

