/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.interactions.ASelection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class ARotatedRectangleSelection
extends ASelection {
    private static final int STARTING_WIDTH = 25;

    public ARotatedRectangleSelection() {
        super(6);
    }

    public int init(Point2D.Double p, int key) {
        this.isValid = false;
        this.setCenter(this.hr[0], p.x - 25.0, p.y);
        this.setCenter(this.hr[1], p.x - 25.0, p.y);
        this.setCenter(this.hr[2], p.x + 25.0, p.y);
        this.setCenter(this.hr[3], p.x + 25.0, p.y);
        this.setCenter(this.hr[4], p.x, p.y);
        this.setCenter(this.hr[5], p.x, p.y);
        this.region = 5;
        return this.region;
    }

    public void drag(Point2D.Double p, int region, int key) {
        this.isValid = true;
        switch (region) {
            case 0: {
                double radius = this.getRadius(p.x, p.y, 4);
                double angle = this.getAngle();
                double deltax = p.x - this.hr[4].getCenterX();
                double deltay = p.y - this.hr[4].getCenterY();
                double dx = -Math.round(radius * Math.sin(angle));
                double dy = Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0.0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.setCenter(this.hr[0], this.hr[4].getCenterX() + dx, this.hr[4].getCenterY() + dy);
                this.setCenter(this.hr[3], this.hr[4].getCenterX() - dx, this.hr[4].getCenterY() - dy);
                this.setCenter(this.hr[1], this.hr[5].getCenterX() + dx, this.hr[5].getCenterY() + dy);
                this.setCenter(this.hr[2], this.hr[5].getCenterX() - dx, this.hr[5].getCenterY() - dy);
                break;
            }
            case 1: {
                double radius = this.getRadius(p.x, p.y, 5);
                double angle = this.getAngle();
                double deltax = p.x - this.hr[5].getCenterX();
                double deltay = p.y - this.hr[5].getCenterY();
                double dx = -Math.round(radius * Math.sin(angle));
                double dy = Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0.0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.setCenter(this.hr[0], this.hr[4].getCenterX() + dx, this.hr[4].getCenterY() + dy);
                this.setCenter(this.hr[3], this.hr[4].getCenterX() - dx, this.hr[4].getCenterY() - dy);
                this.setCenter(this.hr[1], this.hr[5].getCenterX() + dx, this.hr[5].getCenterY() + dy);
                this.setCenter(this.hr[2], this.hr[5].getCenterX() - dx, this.hr[5].getCenterY() - dy);
                break;
            }
            case 2: {
                double radius = this.getRadius(p.x, p.y, 5);
                double angle = this.getAngle();
                double deltax = p.x - this.hr[5].getCenterX();
                double deltay = p.y - this.hr[5].getCenterX();
                double dx = -Math.round(radius * Math.sin(angle));
                double dy = Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0.0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.setCenter(this.hr[0], this.hr[4].getCenterX() - dx, this.hr[4].getCenterY() - dy);
                this.setCenter(this.hr[3], this.hr[4].getCenterX() + dx, this.hr[4].getCenterY() + dy);
                this.setCenter(this.hr[1], this.hr[5].getCenterX() - dx, this.hr[5].getCenterY() - dy);
                this.setCenter(this.hr[2], this.hr[5].getCenterX() + dx, this.hr[5].getCenterY() + dy);
                break;
            }
            case 3: {
                double radius = this.getRadius(p.x, p.y, 4);
                double angle = this.getAngle();
                double deltax = p.x - this.hr[4].getCenterX();
                double deltay = p.y - this.hr[4].getCenterY();
                double dx = -Math.round(radius * Math.sin(angle));
                double dy = Math.round(radius * Math.cos(angle));
                if (deltax * dx + deltay * dy < 0.0) {
                    dx = -dx;
                    dy = -dy;
                }
                this.setCenter(this.hr[0], this.hr[4].getCenterX() - dx, this.hr[4].getCenterY() - dy);
                this.setCenter(this.hr[3], this.hr[4].getCenterX() + dx, this.hr[4].getCenterY() + dy);
                this.setCenter(this.hr[1], this.hr[5].getCenterX() - dx, this.hr[5].getCenterY() - dy);
                this.setCenter(this.hr[2], this.hr[5].getCenterX() + dx, this.hr[5].getCenterY() + dy);
                break;
            }
            case 4: 
            case 5: {
                double radius = this.getRadius(this.hr[0].getCenterX(), this.hr[0].getCenterY(), 4);
                this.setCenter(this.hr[region], p.x, p.y);
                double angle = this.getAngle();
                double dx = -Math.round(radius * Math.sin(angle));
                double dy = Math.round(radius * Math.cos(angle));
                this.setCenter(this.hr[0], this.hr[4].getCenterX() + dx, this.hr[4].getCenterY() + dy);
                this.setCenter(this.hr[3], this.hr[4].getCenterX() - dx, this.hr[4].getCenterY() - dy);
                this.setCenter(this.hr[1], this.hr[5].getCenterX() + dx, this.hr[5].getCenterY() + dy);
                this.setCenter(this.hr[2], this.hr[5].getCenterX() - dx, this.hr[5].getCenterY() - dy);
            }
        }
    }

    private double getAngle() {
        double deltax = this.hr[5].getCenterX() - this.hr[4].getCenterX();
        double deltay = this.hr[5].getCenterY() - this.hr[4].getCenterY();
        if (deltax != 0.0 || deltay != 0.0) {
            return Math.atan2(deltay, deltax);
        }
        return 0.0;
    }

    public void paint(Graphics2D g) {
        this.paintStandard(g);
    }

    public Point2D.Double[] getCorners() {
        int first = this.getUpperLeftRegion();
        int third = (first + 2) % 4;
        int second = (first + 1) % 4;
        double dx0 = this.hr[third].getCenterX() - this.hr[first].getCenterX();
        double dy0 = this.hr[third].getCenterY() - this.hr[first].getCenterY();
        double dx1 = this.hr[second].getCenterX() - this.hr[first].getCenterX();
        double dy1 = this.hr[second].getCenterY() - this.hr[first].getCenterY();
        if (dx0 * dy1 - dy0 * dx1 > 0.0) {
            second = (first + 3) % 4;
        }
        int centerIndex = first == 0 || first == 3 ? 4 : 5;
        double radius = this.getRadius(this.hr[first].getCenterX(), this.hr[first].getCenterY(), centerIndex);
        double angle = this.getAngle();
        double dx = Math.abs(radius * Math.sin(angle));
        double dy = Math.abs(radius * Math.cos(angle));
        centerIndex = first == 0 || first == 3 ? 4 : 5;
        double sdx = this.hr[first].getCenterX() - this.hr[centerIndex].getCenterX() > 0.0 ? 1.0 : -1.0;
        double sdy = this.hr[first].getCenterY() - this.hr[centerIndex].getCenterY() > 0.0 ? 1.0 : -1.0;
        double x0 = this.hr[centerIndex].getCenterX() + sdx * dx;
        double y0 = this.hr[centerIndex].getCenterY() + sdy * dy;
        centerIndex = second == 0 || second == 3 ? 4 : 5;
        sdx = this.hr[second].getCenterX() - this.hr[centerIndex].getCenterX() > 0.0 ? 1.0 : -1.0;
        sdy = this.hr[second].getCenterY() - this.hr[centerIndex].getCenterY() > 0.0 ? 1.0 : -1.0;
        double x1 = this.hr[centerIndex].getCenterX() + sdx * dx;
        double y1 = this.hr[centerIndex].getCenterY() + sdy * dy;
        centerIndex = third == 0 || third == 3 ? 4 : 5;
        sdx = this.hr[third].getCenterX() - this.hr[centerIndex].getCenterX() > 0.0 ? 1.0 : -1.0;
        sdy = this.hr[third].getCenterY() - this.hr[centerIndex].getCenterY() > 0.0 ? 1.0 : -1.0;
        double x2 = this.hr[centerIndex].getCenterX() + sdx * dx;
        double y2 = this.hr[centerIndex].getCenterY() + sdy * dy;
        return this.convert(x0, y0, x1, y1, x2, y2);
    }
}

