/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.gui.AExceptionHandler;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionGroup;
import atlantis.interactions.AInteractionsManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ARubberbandYXGroup
extends AInteractionGroup {
    private static final String[] RUBBERBAND_NAMES = new String[]{"RectangleYX", "RotatedRectangle", "Parallelogram", "Square", "XSkew", "YSkew", "XSlice", "YSlice"};
    private HashMap rubberbands;
    private JComboBox rbComboBox;
    private JPanel additionalControls = new JPanel();

    public ARubberbandYXGroup(AInteractionsManager manager) {
        super(0, manager);
        this.rubberbands = new HashMap();
        this.rbComboBox = new JComboBox();
        for (int i = 0; i < RUBBERBAND_NAMES.length; ++i) {
            this.rbComboBox.addItem(RUBBERBAND_NAMES[i]);
            try {
                Constructor<?>[] c = Class.forName("atlantis.interactions.A" + RUBBERBAND_NAMES[i] + "Selection").getDeclaredConstructors();
                this.rubberbands.put(RUBBERBAND_NAMES[i], c[0].newInstance(new Object[0]));
                continue;
            }
            catch (Exception e) {
                AExceptionHandler.processException("Cannot make selection A" + RUBBERBAND_NAMES[i] + "Selection", e);
            }
        }
        this.rbComboBox.addActionListener(new RuberbandListener());
        this.additionalControls.add(this.rbComboBox);
        this.changeRubberband();
    }

    public boolean hasAdditionalControls() {
        return true;
    }

    public JPanel getAdditionalControls() {
        return this.additionalControls;
    }

    private void changeRubberband() {
        String item = (String)this.rbComboBox.getSelectedItem();
        this.removeAllInteractions();
        this.addInteraction((AInteraction)this.rubberbands.get(item));
        this.iManager.setContext(this);
    }

    public JMenuItem getPopupItem() {
        JMenu menu = new JMenu(this.name);
        PopupListener l = new PopupListener();
        for (int i = 0; i < RUBBERBAND_NAMES.length; ++i) {
            menu.add(RUBBERBAND_NAMES[i]).addActionListener(l);
        }
        return menu;
    }

    public void setGroupState(AInteractionGroup givenGroup) {
        if (givenGroup instanceof ARubberbandYXGroup) {
            ARubberbandYXGroup panel = (ARubberbandYXGroup)givenGroup;
            this.rbComboBox.setSelectedIndex(panel.rbComboBox.getSelectedIndex());
        }
    }

    class PopupListener
    implements ActionListener {
        PopupListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ACanvas.getCanvas().getCurrentWindow().getInteractionToolBar().setSelectedGroup(ARubberbandYXGroup.this.name);
            ARubberbandYXGroup.this.rbComboBox.setSelectedItem(e.getActionCommand());
        }
    }

    class RuberbandListener
    implements ActionListener {
        RuberbandListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ARubberbandYXGroup.this.changeRubberband();
        }
    }
}

