/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.graphics.ACoord;
import atlantis.graphics.ADrawnGraphics2D;
import atlantis.graphics.AGraphics;
import atlantis.gui.ADnDButton;
import atlantis.gui.ADnDLabel;
import atlantis.gui.ADragListener;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionsManager;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.list.AListManager;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public abstract class ASelection
extends AInteraction
implements ASleepMouseDragListener,
ActionListener {
    private static ALogger logger = ALogger.getLogger(ASelection.class);
    private JPanel actionsPanel;
    private GridLayout actionsPanelLayout;
    private int d = 10;
    private boolean[][] map;
    protected static final int radius = 10;
    protected int region;
    protected boolean isValid = false;
    public static final String ZOOM = "Zoom";
    public static final String NEW_LIST = "New List";
    public static final String SUMMARIZE = "Summarize";

    public ASelection(int hotRegionsCount) {
        super(hotRegionsCount, 1, 0, true);
        for (int i = 0; i < this.hr.length; ++i) {
            this.hr[i] = new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0);
        }
        this.actionsPanelLayout = new GridLayout(0, 1);
        this.actionsPanel = new JPanel(this.actionsPanelLayout);
        this.addActionButton(ZOOM, new ADragListener(){

            public void dragPerformed(Object from, Object to, int action) {
                if (to instanceof ADnDLabel) {
                    ASelection.this.zoomIn(((ADnDLabel)to).getText());
                } else if (to instanceof AWindow) {
                    ASelection.this.zoomIn(((AWindow)to).getName());
                }
                ASelection.this.invalidate();
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ASelection.this.window.saveCorners();
                ASelection.this.window.setUserCorners(ASelection.this.getCorners());
                ASelection.this.invalidate();
            }
        });
        this.addActionButton(NEW_LIST, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(ASelection.NEW_LIST)) {
                    Point2D.Double[] zoomedCorners = ASelection.this.getCorners();
                    Point2D.Double[] userCorners = ASelection.this.window.getUserCorners();
                    ASelection.this.window.setUserCornersNoRepaint(zoomedCorners);
                    Rectangle bounds = ASelection.this.window.getBounds();
                    bounds.setLocation(0, 0);
                    ASelection.this.window.paintWindowFromScratch(new ADrawnGraphics2D(bounds));
                    ADrawnGraphics2D.updateLastDrawn();
                    AListManager.getInstance().copyLastDrawn();
                    AListManager.getInstance().showLists();
                    ASelection.this.window.setUserCornersNoRepaint(userCorners);
                }
            }
        });
        this.addActionButton(SUMMARIZE, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(ASelection.SUMMARIZE)) {
                    Point2D.Double[] zoomedCorners = ASelection.this.getCorners();
                    Point2D.Double[] userCorners = ASelection.this.window.getUserCorners();
                    ASelection.this.window.setUserCornersNoRepaint(zoomedCorners);
                    Rectangle bounds = ASelection.this.window.getBounds();
                    bounds.setLocation(0, 0);
                    ASelection.this.window.paintWindowFromScratch(new ADrawnGraphics2D(bounds));
                    ADrawnGraphics2D.updateLastDrawn();
                    AListManager.getInstance().summarize();
                    ASelection.this.window.setUserCornersNoRepaint(userCorners);
                }
            }
        });
    }

    public void invalidate() {
        this.isValid = false;
        this.actionsPanel.setVisible(false);
    }

    public void addActionButton(String buttonName, ADragListener dragList, ActionListener clickList) {
        ADnDButton b = new ADnDButton(buttonName);
        b.setFocusPainted(false);
        b.addActionListener(clickList);
        b.addDragListener(dragList);
        this.actionsPanelLayout.setRows(this.actionsPanelLayout.getRows() + 1);
        this.actionsPanel.add(b);
        this.actionsPanel.setSize(this.actionsPanel.getPreferredSize());
    }

    public void addActionButton(String buttonName, ActionListener clickListener) {
        JButton b = new JButton(buttonName);
        b.setFocusPainted(false);
        b.addActionListener(clickListener);
        this.actionsPanelLayout.setRows(this.actionsPanelLayout.getRows() + 1);
        this.actionsPanel.add(b);
        this.actionsPanel.setSize(this.actionsPanel.getPreferredSize());
    }

    public JMenuItem[] getPopupItems() {
        JMenuItem it;
        ArrayList<JMenuItem> al = new ArrayList<JMenuItem>();
        if (this.window.getUnzoomPossible()) {
            it = new JMenuItem("Unzoom");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ASelection.this.window.unzoom();
                }
            });
            al.add(it);
        }
        if (this.window.getUnzoomFullPossible()) {
            it = new JMenuItem("Unzoom Full");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ASelection.this.window.unzoomFull();
                }
            });
            al.add(it);
        }
        JMenuItem[] ret = new JMenuItem[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            ret[i] = (JMenuItem)al.get(i);
        }
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("Unzoom")) {
            this.window.unzoom();
        }
    }

    public int getPopupType() {
        return 1;
    }

    public void connect(AInteractionsManager manager) {
        super.connect(manager);
        this.window.getView().add(this.actionsPanel);
        if (this.isValid) {
            this.actionsPanel.setVisible(true);
        } else {
            this.actionsPanel.setVisible(false);
        }
        this.window.validate();
    }

    public void disconnect() {
        this.window.getView().remove(this.actionsPanel);
    }

    public int getButton() {
        return 0;
    }

    public void start(Point2D.Double p, int region, int key) {
        this.region = region;
        this.actionsPanel.setVisible(false);
    }

    public void cancel() {
    }

    private boolean canLayout(int i0, int j0) {
        Dimension panelSize = this.actionsPanel.getSize();
        panelSize.width = (int)Math.ceil((double)(panelSize.width + this.d) / (double)this.d);
        panelSize.height = (int)Math.ceil((double)(panelSize.height + this.d) / (double)this.d);
        for (int j = 0; j < panelSize.height; ++j) {
            for (int i = 0; i < panelSize.width; ++i) {
                if (i0 + i > this.map[0].length - 1) {
                    return false;
                }
                if (j0 + j > this.map.length - 1) {
                    return false;
                }
                if (this.map[j0 + j][i0 + i]) continue;
                return false;
            }
        }
        return true;
    }

    private Point calculateBestPosition() {
        int i;
        int j;
        AWindow w = this.window;
        Dimension size = w.getView().getSize();
        int ny = (int)Math.ceil((double)size.height / (double)this.d);
        int nx = (int)Math.ceil((double)size.width / (double)this.d);
        this.map = new boolean[ny][nx];
        Polygon p = new Polygon();
        for (int i2 = 0; i2 < 4; ++i2) {
            p.addPoint((int)this.hr[i2].getCenterX(), (int)this.hr[i2].getCenterY());
        }
        for (j = 0; j < this.map.length; ++j) {
            for (i = 0; i < this.map[0].length; ++i) {
                this.map[j][i] = !p.intersects(i * this.d, j * this.d, this.d, this.d) && !p.contains(i * this.d, j * this.d, this.d, this.d);
            }
        }
        for (j = 0; j < this.map.length; ++j) {
            for (i = 0; i < this.map[0].length; ++i) {
                this.map[j][i] = this.canLayout(i, j);
            }
        }
        int x0 = (int)this.hr[this.region].getMaxX();
        int y0 = (int)this.hr[this.region].getMaxY();
        int i_min = 0;
        int j_min = 0;
        double dist_min = 1.0E10;
        for (int j2 = 0; j2 < this.map.length; ++j2) {
            for (int i3 = 0; i3 < this.map[0].length; ++i3) {
                double dist;
                if (!this.map[j2][i3] || !((dist = AMath.distance(x0, y0, i3 * this.d, j2 * this.d)) < dist_min)) continue;
                i_min = i3;
                j_min = j2;
                dist_min = dist;
            }
        }
        return new Point(i_min * this.d + this.d / 2, j_min * this.d + this.d / 2);
    }

    public void stop() {
        if (this.isValid) {
            Point p = this.calculateBestPosition();
            this.actionsPanel.setLocation(p.x, p.y);
            this.actionsPanel.setVisible(true);
            this.window.revalidate();
        }
    }

    protected int getUpperLeftRegion() {
        int point = 0;
        double savedValue = this.getRadius(this.hr[0]);
        for (int i = 1; i < 4; ++i) {
            double value = this.getRadius(this.hr[i]);
            if (!(value < savedValue)) continue;
            savedValue = value;
            point = i;
        }
        return point;
    }

    protected Point2D.Double[] convert(double x0, double y0, double x1, double y1, double x2, double y2) {
        if (!this.isValid) {
            return this.window.getUserCorners();
        }
        if (Math.abs(this.getAPolygon().getArea()) == 0.0) {
            return this.window.getUserCorners();
        }
        double[][][] hv = new double[2][1][3];
        hv[0][0][0] = x0;
        hv[1][0][0] = y0;
        hv[0][0][1] = x1;
        hv[1][0][1] = y1;
        hv[0][0][2] = x2;
        hv[1][0][2] = y2;
        ACoord d = this.window.calculateUser(new ACoord(hv));
        Point2D.Double[] corners = new Point2D.Double[3];
        for (int i = 0; i < 3; ++i) {
            corners[i] = new Point2D.Double(d.hv[0][0][i], d.hv[1][0][i]);
        }
        return corners;
    }

    protected Point2D.Double[] convert(int region1, int region2, int region3) {
        return this.convert(this.hr[region1].getCenterX(), this.hr[region1].getCenterY(), this.hr[region2].getCenterX(), this.hr[region2].getCenterY(), this.hr[region3].getCenterX(), this.hr[region3].getCenterY());
    }

    public abstract Point2D.Double[] getCorners();

    protected void paintStandard(Graphics2D g) {
        if (this.isValid) {
            AGraphics ag = AGraphics.makeAGraphics(g);
            ag.updateDrawParameters(frameDrawParameters);
            ag.drawPolygon(this.getAPolygon());
            this.drawLine(4, 5, ag);
            ag.updateDrawParameters(drawParameters);
            ag.drawPolygon(this.getAPolygon());
            this.drawLine(4, 5, ag);
            this.drawActivePoint(this.region, ag);
        }
    }

    public void zoomIn(String zoomWindow) {
        String currentWindow = this.window.getName();
        ACanvas.getCanvas().copyWindowSettings(currentWindow, zoomWindow);
        ACanvas.getCanvas().getWindow(zoomWindow).setUserCorners(this.getCorners());
    }
}

