/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.AWindow;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AModifier;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.parameters.APar;
import atlantis.projection.AProjection;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionRZ;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;

public class ASkewInteraction
extends AInteraction
implements ASleepMouseDragListener,
ActionListener {
    private int d = 20;
    private Point2D.Double p0;
    private JMenuItem[] popupItems = new JMenuItem[]{new JMenuItem("Set No Skew")};
    private static final String NO_SKEW = "Set No Skew";

    public ASkewInteraction() {
        super(1, 4, 1, false);
        this.popupItems[0].addActionListener(this);
        this.hr[0] = new Ellipse2D.Double(-this.d / 2, -this.d / 2, this.d, this.d);
    }

    public int init(Point2D.Double p, int key) {
        this.p0 = p;
        return 0;
    }

    public int getButton() {
        return 0;
    }

    public void start(Point2D.Double p, int region, int key) {
    }

    public void drag(Point2D.Double p, int region, int key) {
        AProjection proj = this.window.getProjection();
        if (proj instanceof AProjectionFR) {
            ASkewInteraction.performFRSkew(-(p.y - this.p0.y) / this.p0.x, this.window);
        } else if (proj instanceof AProjectionFZ) {
            ASkewInteraction.performFZSkew(-(p.y - this.p0.y) / this.p0.x, this.window);
        } else if (proj instanceof AProjectionRZ) {
            if (key == 86) {
                ASkewInteraction.performFZSkew(-(p.y - this.p0.y) / this.p0.x, this.window);
            } else {
                ASkewInteraction.performRZSkew(-(p.x - this.p0.x) / this.p0.y, this.window);
            }
        }
    }

    public static void performFRSkew(double f, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        for (int i = 0; i < corners.length; ++i) {
            corners[i].y += f * corners[i].x;
        }
        window.setUserCorners(corners);
    }

    public static void performFZSkew(double f, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        double zVtx = APar.get("Event", "ZVtx").getD();
        for (int i = 0; i < corners.length; ++i) {
            corners[i].y += f * (corners[i].x - zVtx);
        }
        window.setUserCorners(corners);
    }

    public static void performRZSkew(double f, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        for (int i = 0; i < corners.length; ++i) {
            corners[i].x += f * corners[i].y;
        }
        window.setUserCorners(corners);
    }

    public void stop() {
    }

    public void cancel() {
    }

    public void paint(Graphics2D g) {
    }

    public int getPopupType() {
        return 1;
    }

    public JMenuItem[] getPopupItems() {
        return this.popupItems;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public AModifier[] getModifiers() {
        if (this.window.getProjection() instanceof AProjectionRZ) {
            return new AModifier[]{new AModifier(86, false, "Y Skew"), new AModifier(72, false, "X Skew"), new AModifier(0, false, "X Skew")};
        }
        return new AModifier[0];
    }
}

