/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.graphics.AGraphics;
import atlantis.interactions.ASelection;
import atlantis.utils.AMath;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class ASquareSelection
extends ASelection {
    public ASquareSelection() {
        super(5);
    }

    public int init(Point2D.Double p, int key) {
        this.isValid = false;
        for (int i = 0; i < 5; ++i) {
            this.setCenter(this.hr[i], p.x, p.y);
        }
        this.region = 2;
        return this.region;
    }

    public void drag(Point2D.Double p, int region, int key) {
        this.isValid = true;
        if (region == 4) {
            double dx = p.x - this.hr[4].getCenterX();
            double dy = p.y - this.hr[4].getCenterY();
            for (int i = 0; i < 5; ++i) {
                this.setCenter(this.hr[i], this.hr[i].getCenterX() + dx, this.hr[i].getCenterY() + dy);
            }
        } else {
            double sy1;
            double ratio = (double)this.window.getSize().width / (double)this.window.getSize().height;
            double sx1 = AMath.getSign(p.x - this.hr[4].getCenterX());
            double sx2 = sy1 = AMath.getSign(p.y - this.hr[4].getCenterY());
            double sy2 = sx1;
            double dy = this.getRadius(p.x, p.y, 4) / Math.sqrt(1.0 + ratio * ratio);
            double dx = dy * ratio;
            this.setCenter(this.hr[region], this.hr[4].getCenterX() + dx * sx1, this.hr[4].getCenterY() + dy * sy1);
            this.setCenter(this.hr[(region + 2) % 4], this.hr[4].getCenterX() - dx * sx1, this.hr[4].getCenterY() - dy * sy1);
            this.setCenter(this.hr[(region + 1) % 4], this.hr[4].getCenterX() - dx * sx2, this.hr[4].getCenterY() + dy * sy2);
            this.setCenter(this.hr[(region + 3) % 4], this.hr[4].getCenterX() + dx * sx2, this.hr[4].getCenterY() - dy * sy2);
        }
    }

    public void paint(Graphics2D g) {
        if (this.isValid) {
            AGraphics ag = AGraphics.makeAGraphics(g);
            ag.updateDrawParameters(frameDrawParameters);
            ag.drawPolygon(this.getAPolygon());
            this.drawLine(0, 2, ag);
            this.drawLine(1, 3, ag);
            ag.updateDrawParameters(drawParameters);
            ag.drawPolygon(this.getAPolygon());
            this.drawLine(0, 2, ag);
            this.drawLine(1, 3, ag);
            this.drawActivePoint(this.region, ag);
        }
    }

    public Point2D.Double[] getCorners() {
        int first = this.getUpperLeftRegion();
        int second = (first + 1) % 4;
        int third = (first + 2) % 4;
        return this.convert(first, second, third);
    }
}

