/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.graphics.ACoord;
import atlantis.graphics.AGraphics;
import atlantis.gui.ACursorFactory;
import atlantis.interactions.AEnterExitListener;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AModifier;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.parameters.APar;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.projection.AProjectionYX;
import atlantis.projection.AProjectionYZ;
import atlantis.utils.AMath;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class ASynchroCursorsInteraction
extends AInteraction
implements ASleepMouseDragListener,
AEnterExitListener {
    private static double rho;
    private static double phi;
    private static double z;
    private static double sign_rho;
    private static final double NOT_DEFINED = 9999.0;
    private static final double RHO_MAX = 3000.0;
    private static final double PHI_MAX = 400.0;
    private static final double Z_MAX = 3000.0;
    private static final double ETA_MAX = 10.0;
    private static int key;
    protected int radius = 10;

    public ASynchroCursorsInteraction() {
        super(1, 3, 1, true);
        this.hr[0] = new Ellipse2D.Double(0.0, 0.0, this.radius, this.radius);
    }

    public int getButton() {
        return 0;
    }

    public int init(Point2D.Double p, int key) {
        ASynchroCursorsInteraction.key = key;
        this.setCenter(this.hr[0], p.x, p.y);
        return 0;
    }

    public void start(Point2D.Double p, int region, int key) {
        this.drag(p, region, key);
    }

    public void drag(Point2D.Double pInput, int region, int key) {
        double eta;
        ASynchroCursorsInteraction.key = key;
        AProjection2D projection = (AProjection2D)this.window.getProjection();
        Point2D.Double p = projection.inverseNonLinearTransform(pInput);
        this.setCenter(this.hr[0], p.x, p.y);
        rho = 9999.0;
        z = 9999.0;
        phi = 9999.0;
        sign_rho = 1.0;
        if (projection instanceof AProjectionYX) {
            phi = Math.toDegrees(Math.atan2(p.y, p.x));
            if (phi < 0.0) {
                phi += 360.0;
            }
            rho = (double)AMath.getRhoSign(p.x, p.y) * Math.sqrt(p.x * p.x + p.y * p.y);
        } else if (projection instanceof AProjectionFR) {
            phi = p.y;
            rho = p.x;
        } else if (projection instanceof AProjectionFZ) {
            phi = p.y;
            z = p.x;
        } else if (projection instanceof AProjectionRZ) {
            rho = Math.abs(p.y);
            if (p.y < 0.0) {
                sign_rho = -1.0;
            }
            z = p.x;
        } else if (projection instanceof AProjectionYZ) {
            z = p.x;
        } else if (projection instanceof AProjectionXZ) {
            z = p.x;
        } else if (projection instanceof AProjectionVP) {
            phi = p.y;
            rho = APar.get("VP", "RMax").getD();
            eta = p.x;
            z = APar.get("Event", "ZVtx").getD() + 0.5 * rho * (Math.exp(eta) - 1.0 / Math.exp(eta));
        } else if (projection instanceof AProjectionLegoPlot) {
            AProjectionLegoPlot.update();
            p.x = -AProjectionLegoPlot.adjustPhi(this.window, -p.x, p.y);
            if (p.x > -1.0 && p.x < 361.0 && p.y > -5.01 && p.y < 5.01) {
                phi = p.x;
                rho = APar.get("VP", "RMax").getD();
                eta = p.y;
                if (AProjectionLegoPlot.reverse) {
                    eta = -eta;
                }
                z = APar.get("Event", "ZVtx").getD() + 0.5 * rho * (Math.exp(eta) - 1.0 / Math.exp(eta));
            }
        }
        if (key == 80 && phi != 9999.0) {
            double phiRZ = phi + 90.0;
            if (phiRZ < 0.0) {
                phiRZ += 360.0;
            }
            if (phiRZ > 360.0) {
                phiRZ -= 360.0;
            }
            APar.get("RZ", "Phi").setD(phiRZ);
            APar.get("RZ", "Phi").globalize(ACanvas.getCanvas().getCurrentWindow().getIndex());
            ACanvas.getCanvas().repaintAllFromScratch();
        } else {
            ACanvas.getCanvas().repaintOthers(this.window);
        }
    }

    public void cancel() {
    }

    public void stop() {
    }

    public void paint(Graphics2D g) {
        APar.selectWindowParameters(this.window.getName());
        AProjection2D projection = (AProjection2D)this.window.getProjection();
        AGraphics ag = AGraphics.makeAGraphics(g);
        for (int i = 0; i < 2; ++i) {
            double[][][] hv;
            if (i == 0) {
                ag.updateDrawParameters(frameDrawParameters);
            } else {
                ag.updateDrawParameters(drawParameters);
            }
            if (projection instanceof AProjectionYX) {
                if (phi != 9999.0) {
                    double r = rho == 9999.0 ? 3000.0 : Math.abs(rho);
                    double cosPhi = Math.cos(Math.toRadians(phi));
                    double sinPhi = Math.sin(Math.toRadians(phi));
                    Point2D.Double p = this.window.calculateDisplay(projection.nonLinearTransform(0.0, 0.0));
                    Point2D.Double p1 = this.window.calculateDisplay(projection.nonLinearTransform(r * cosPhi, r * sinPhi));
                    Point2D.Double p2 = this.window.calculateDisplay(projection.nonLinearTransform(3000.0 * cosPhi, 3000.0 * sinPhi));
                    Point2D.Double p3 = this.window.calculateDisplay(projection.nonLinearTransform(-3000.0 * cosPhi, -3000.0 * sinPhi));
                    if (key == 80) {
                        ag.drawLine(p2.x, p2.y, p3.x, p3.y);
                        continue;
                    }
                    ag.drawLine(p.x, p.y, p2.x, p2.y);
                    if (rho == 9999.0) continue;
                    ag.drawSymbol(p1.x, p1.y);
                    continue;
                }
                if (rho == 9999.0) continue;
                int numPoints = 48;
                hv = new double[2][1][numPoints];
                for (int j = 0; j < numPoints; ++j) {
                    hv[0][0][j] = rho * Math.cos(Math.PI * 2 * (double)j / 48.0);
                    hv[1][0][j] = rho * Math.sin(Math.PI * 2 * (double)j / 48.0);
                }
                ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                ag.drawPolygon(d.hv[0][0], d.hv[1][0], numPoints);
                continue;
            }
            if (projection instanceof AProjectionFR) {
                int numPoints = 5;
                hv = new double[2][1][numPoints];
                hv[0][0][0] = Math.abs(rho);
                hv[1][0][0] = phi;
                hv[0][0][1] = Math.abs(rho);
                hv[1][0][1] = 0.0;
                hv[0][0][2] = Math.abs(rho);
                hv[1][0][2] = 3000.0;
                hv[0][0][3] = 0.0;
                hv[1][0][3] = phi;
                hv[0][0][4] = 3000.0;
                hv[1][0][4] = phi;
                ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                if (rho != 9999.0) {
                    ag.drawLine(d.hv[0][0][1], d.hv[1][0][1], d.hv[0][0][2], d.hv[1][0][2]);
                }
                if (phi != 9999.0) {
                    ag.drawLine(d.hv[0][0][3], d.hv[1][0][3], d.hv[0][0][4], d.hv[1][0][4]);
                }
                if (rho == 9999.0 || phi == 9999.0) continue;
                ag.drawSymbol(d.hv[0][0][0], d.hv[1][0][0]);
                continue;
            }
            if (projection instanceof AProjectionFZ) {
                int numPoints = 5;
                hv = new double[2][1][numPoints];
                hv[0][0][0] = z;
                hv[1][0][0] = phi;
                hv[0][0][1] = z;
                hv[1][0][1] = 0.0;
                hv[0][0][2] = z;
                hv[1][0][2] = 400.0;
                hv[0][0][3] = -3000.0;
                hv[1][0][3] = phi;
                hv[0][0][4] = 3000.0;
                hv[1][0][4] = phi;
                ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                if (z != 9999.0) {
                    ag.drawLine(d.hv[0][0][1], d.hv[1][0][1], d.hv[0][0][2], d.hv[1][0][2]);
                }
                if (phi != 9999.0) {
                    ag.drawLine(d.hv[0][0][3], d.hv[1][0][3], d.hv[0][0][4], d.hv[1][0][4]);
                }
                if (z == 9999.0 || phi == 9999.0) continue;
                ag.drawSymbol(d.hv[0][0][0], d.hv[1][0][0]);
                continue;
            }
            if (projection instanceof AProjectionRZ) {
                if (rho != 9999.0 && phi != 9999.0 && z != 9999.0 && (rho != 0.0 || z != 0.0)) {
                    double phiDiff;
                    double dz;
                    double dr;
                    int numPoints = 15;
                    hv = new double[2][1][numPoints];
                    if (Math.abs(rho / 3000.0) > Math.abs(z / 3000.0)) {
                        dr = 3000.0 / (double)(numPoints - 1);
                        dz = z * (3000.0 / ((double)(numPoints - 1) * rho));
                    } else {
                        dz = AMath.getSign(z) * 3000.0 / (double)(numPoints - 1);
                        dr = rho * Math.abs(3000.0 / ((double)(numPoints - 1) * z));
                    }
                    double phiMid = Math.toRadians(APar.get("RZ", "Phi").getD());
                    if (phiMid > Math.PI * 2) {
                        phiMid -= Math.PI * 2;
                    }
                    if ((phiDiff = Math.abs(Math.toRadians(phi) - phiMid)) > 1.5707963267948966 && phiDiff < 4.71238898038469) {
                        dr *= -1.0;
                    }
                    for (int j = 0; j < numPoints; ++j) {
                        hv[0][0][j] = (double)j * dz;
                        hv[1][0][j] = (double)j * dr;
                    }
                    ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                    ag.drawSmoothPolyline(d.hv[0][0], d.hv[1][0], numPoints);
                    continue;
                }
                int numPoints = 5;
                hv = new double[2][1][numPoints];
                hv[0][0][0] = z;
                hv[1][0][0] = rho * sign_rho;
                hv[0][0][1] = z;
                hv[1][0][1] = -3000.0;
                hv[0][0][2] = z;
                hv[1][0][2] = 3000.0;
                hv[0][0][3] = -3000.0;
                hv[1][0][3] = rho * sign_rho;
                hv[0][0][4] = 3000.0;
                hv[1][0][4] = rho * sign_rho;
                ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                if (z != 9999.0) {
                    ag.drawLine(d.hv[0][0][1], d.hv[1][0][1], d.hv[0][0][2], d.hv[1][0][2]);
                }
                if (rho != 9999.0) {
                    ag.drawLine(d.hv[0][0][3], d.hv[1][0][3], d.hv[0][0][4], d.hv[1][0][4]);
                }
                if (z == 9999.0 || rho == 9999.0) continue;
                ag.drawSymbol(d.hv[0][0][0], d.hv[1][0][0]);
                continue;
            }
            if (projection instanceof AProjectionYZ) {
                if (rho != 9999.0 && phi != 9999.0 && z != 9999.0) {
                    int numPoints = 2;
                    hv = new double[2][1][numPoints];
                    hv[0][0][0] = 0.0;
                    hv[1][0][0] = 0.0;
                    double phiRot = AProjectionXZ.getPhi();
                    hv[0][0][1] = z;
                    hv[1][0][1] = rho * Math.sin(phiRot);
                    ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                    ag.drawLine(d.hv[0][0][0], d.hv[1][0][0], d.hv[0][0][1], d.hv[1][0][1]);
                    ag.drawSymbol(d.hv[0][0][1], d.hv[1][0][1]);
                    continue;
                }
                if (z == 9999.0) continue;
                int numPoints = 2;
                hv = new double[2][1][numPoints];
                hv[0][0][0] = z;
                hv[1][0][0] = -3000.0;
                hv[0][0][1] = z;
                hv[1][0][1] = 3000.0;
                ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                ag.drawLine(d.hv[0][0][0], d.hv[1][0][0], d.hv[0][0][1], d.hv[1][0][1]);
                continue;
            }
            if (projection instanceof AProjectionXZ) {
                if (rho != 9999.0 && phi != 9999.0 && z != 9999.0) {
                    int numPoints = 2;
                    hv = new double[2][1][numPoints];
                    hv[0][0][0] = 0.0;
                    hv[1][0][0] = 0.0;
                    double phiRot = AProjectionXZ.getPhi();
                    hv[0][0][1] = z;
                    hv[1][0][1] = rho * Math.cos(phiRot);
                    ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                    ag.drawLine(d.hv[0][0][0], d.hv[1][0][0], d.hv[0][0][1], d.hv[1][0][1]);
                    ag.drawSymbol(d.hv[0][0][1], d.hv[1][0][1]);
                    continue;
                }
                if (z == 9999.0) continue;
                int numPoints = 2;
                hv = new double[2][1][numPoints];
                hv[0][0][0] = z;
                hv[1][0][0] = -3000.0;
                hv[0][0][1] = z;
                hv[1][0][1] = 3000.0;
                ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                ag.drawLine(d.hv[0][0][0], d.hv[1][0][0], d.hv[0][0][1], d.hv[1][0][1]);
                continue;
            }
            if (projection instanceof AProjectionVP) {
                int numPoints = 5;
                hv = new double[2][1][numPoints];
                double eta = 1.0;
                if (z != 9999.0 && rho != 9999.0) {
                    eta = AMath.eta(z, rho);
                }
                hv[0][0][0] = eta;
                hv[1][0][0] = phi;
                hv[0][0][1] = eta;
                hv[1][0][1] = 0.0;
                hv[0][0][2] = eta;
                hv[1][0][2] = 400.0;
                hv[0][0][3] = -10.0;
                hv[1][0][3] = phi;
                hv[0][0][4] = 10.0;
                hv[1][0][4] = phi;
                ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv)));
                if (z != 9999.0 && rho != 9999.0) {
                    ag.drawLine(d.hv[0][0][1], d.hv[1][0][1], d.hv[0][0][2], d.hv[1][0][2]);
                }
                if (phi != 9999.0) {
                    ag.drawLine(d.hv[0][0][3], d.hv[1][0][3], d.hv[0][0][4], d.hv[1][0][4]);
                }
                if (z == 9999.0 || phi == 9999.0 || rho == 9999.0) continue;
                ag.drawSymbol(d.hv[0][0][0], d.hv[1][0][0]);
                continue;
            }
            if (!(projection instanceof AProjectionLegoPlot)) continue;
            double eta = 1.0;
            double[][][] hv2 = new double[2][1][3];
            Point2D.Double[] userCorners = this.window.getUserCorners();
            Point2D.Double[] displayCorners = this.window.getDisplayCorners();
            AProjectionLegoPlot.update();
            if (z != 9999.0 && rho != 9999.0) {
                eta = AMath.eta(z, rho);
            }
            if (AProjectionLegoPlot.reverse) {
                eta = -eta;
            }
            hv2[0][0][0] = AProjectionLegoPlot.adjustPhi(this.window, phi, eta);
            hv2[1][0][0] = eta;
            hv2[0][0][1] = AProjectionLegoPlot.adjustPhi(this.window, phi, userCorners[0].y);
            hv2[1][0][1] = userCorners[0].y;
            hv2[0][0][2] = AProjectionLegoPlot.adjustPhi(this.window, phi, userCorners[2].y);
            hv2[1][0][2] = userCorners[2].y;
            ACoord d = this.window.calculateDisplay(projection.nonLinearTransform(new ACoord(hv2)));
            if (z != 9999.0 && rho != 9999.0) {
                ag.drawLine(0.0, d.hv[1][0][0], displayCorners[1].x, d.hv[1][0][0]);
            }
            if (phi != 9999.0) {
                ag.drawLine(d.hv[0][0][1], d.hv[1][0][1], d.hv[0][0][2], d.hv[1][0][2]);
            }
            if (z == 9999.0 || phi == 9999.0 || rho == 9999.0) continue;
            ag.drawSymbol(d.hv[0][0][0], d.hv[1][0][0]);
        }
        APar.restoreWindowParameters();
    }

    public void entered() {
        this.window.setCursor(ACursorFactory.getInstance().getSyncCursor());
    }

    public void exited() {
        this.window.setCursor(ACursorFactory.getInstance().getSyncCursor());
    }

    public AModifier[] getModifiers() {
        return new AModifier[]{new AModifier(80, false, "Copy phi to RZ projection")};
    }

    static {
        key = 0;
    }
}

