/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.interactions.ASelection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class AXSkewSelection
extends ASelection {
    private static final int STARTING_WIDTH = 25;

    public AXSkewSelection() {
        super(6);
    }

    public int init(Point2D.Double p, int key) {
        this.isValid = false;
        this.setCenter(this.hr[0], p.x - 25.0, p.y);
        this.setCenter(this.hr[1], p.x - 25.0, p.y);
        this.setCenter(this.hr[2], p.x + 25.0, p.y);
        this.setCenter(this.hr[3], p.x + 25.0, p.y);
        this.setCenter(this.hr[4], p.x, p.y);
        this.setCenter(this.hr[5], p.x, p.y);
        this.region = 5;
        return this.region;
    }

    public void drag(Point2D.Double p, int region, int key) {
        this.isValid = true;
        switch (region) {
            case 0: {
                double width = p.x - this.hr[4].getCenterX();
                this.setCenterX(this.hr[0], this.hr[4].getCenterX() + width);
                this.setCenterX(this.hr[1], this.hr[5].getCenterX() + width);
                this.setCenterX(this.hr[2], this.hr[5].getCenterX() - width);
                this.setCenterX(this.hr[3], this.hr[4].getCenterX() - width);
                break;
            }
            case 1: {
                double width = p.x - this.hr[5].getCenterX();
                this.setCenterX(this.hr[0], this.hr[4].getCenterX() + width);
                this.setCenterX(this.hr[1], this.hr[5].getCenterX() + width);
                this.setCenterX(this.hr[2], this.hr[5].getCenterX() - width);
                this.setCenterX(this.hr[3], this.hr[4].getCenterX() - width);
                break;
            }
            case 2: {
                double width = p.x - this.hr[5].getCenterX();
                this.setCenterX(this.hr[0], this.hr[4].getCenterX() - width);
                this.setCenterX(this.hr[1], this.hr[5].getCenterX() - width);
                this.setCenterX(this.hr[2], this.hr[5].getCenterX() + width);
                this.setCenterX(this.hr[3], this.hr[4].getCenterX() + width);
                break;
            }
            case 3: {
                double width = p.x - this.hr[4].getCenterX();
                this.setCenterX(this.hr[0], this.hr[4].getCenterX() - width);
                this.setCenterX(this.hr[1], this.hr[5].getCenterX() - width);
                this.setCenterX(this.hr[2], this.hr[5].getCenterX() + width);
                this.setCenterX(this.hr[3], this.hr[4].getCenterX() + width);
                break;
            }
            case 4: {
                double width = this.hr[4].getCenterX() - this.hr[0].getCenterX();
                this.setCenter(this.hr[region], p.x, p.y);
                this.setCenter(this.hr[0], p.x - width, p.y);
                this.setCenter(this.hr[3], p.x + width, p.y);
                break;
            }
            case 5: {
                double width = this.hr[4].getCenterX() - this.hr[0].getCenterX();
                this.setCenter(this.hr[region], p.x, p.y);
                this.setCenter(this.hr[1], p.x - width, p.y);
                this.setCenter(this.hr[2], p.x + width, p.y);
            }
        }
    }

    public void paint(Graphics2D g) {
        this.paintStandard(g);
    }

    public Point2D.Double[] getCorners() {
        int first = this.getUpperLeftRegion();
        int third = (first + 2) % 4;
        int second = (first + 1) % 4;
        double dx0 = this.hr[third].getCenterX() - this.hr[first].getCenterX();
        double dy0 = this.hr[third].getCenterY() - this.hr[first].getCenterY();
        double dx1 = this.hr[second].getCenterX() - this.hr[first].getCenterX();
        double dy1 = this.hr[second].getCenterY() - this.hr[first].getCenterY();
        if (dx0 * dy1 - dy0 * dx1 > 0.0) {
            second = (first + 3) % 4;
        }
        return this.convert(first, second, third);
    }
}

