/*
 * Decompiled with CFR 0.152.
 */
package atlantis.interactions;

import atlantis.canvas.ACanvas;
import atlantis.canvas.AWindow;
import atlantis.gui.ACursorFactory;
import atlantis.interactions.AEnterExitListener;
import atlantis.interactions.AInteraction;
import atlantis.interactions.AInteractionsManager;
import atlantis.interactions.AModifier;
import atlantis.interactions.AMousePressListener;
import atlantis.interactions.ASleepMouseDragListener;
import atlantis.parameters.APar;
import atlantis.parameters.AParameter;
import atlantis.projection.AProjection;
import atlantis.projection.AProjection2D;
import atlantis.projection.AProjection3D;
import atlantis.projection.AProjectionFR;
import atlantis.projection.AProjectionFZ;
import atlantis.projection.AProjectionLegoPlot;
import atlantis.projection.AProjectionRZ;
import atlantis.projection.AProjectionVP;
import atlantis.projection.AProjectionXZ;
import atlantis.projection.AProjectionYX;
import atlantis.projection.AProjectionYZ;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.AVector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;

public class AZMRInteraction
extends AInteraction
implements ASleepMouseDragListener,
AMousePressListener,
AEnterExitListener,
ActionListener {
    private static final double MINIMAL_ZOOM_LIMIT = 0.001;
    private static final double MAXIMAL_ZOOM_LIMIT = 100000.0;
    private static final int ZOOM_MODE = 0;
    private static final int HORIZONTAL_ZOOM_MODE = 1;
    private static final int VERTICAL_ZOOM_MODE = 2;
    private static final int ROTATE_MODE = 3;
    private static final int MOVE_MODE = 5;
    private int centerMarkRadius = 6;
    private Point2D.Double p0;
    private int previousKey = 0;
    private int mode;
    private JMenuItem[] popupItems = new JMenuItem[]{new JMenuItem("To Center Of Detector"), new JMenuItem("Center The Picture"), new JMenuItem("Unzoom Full")};
    private static final String TO_CENTER_OF_DETECTOR = "To Center Of Detector";
    private static final String CENTER_PICTURE = "Center The Picture";
    private static final String ASPECT_RATIO_1 = "Aspect Ratio 1";
    private static final String UNZOOM_FULL = "Unzoom Full";
    private static boolean paintCenterDot = true;

    public AZMRInteraction() {
        super(1, 1, 1, false);
        for (int i = 0; i < this.popupItems.length; ++i) {
            this.popupItems[i].addActionListener(this);
        }
        this.hr[0] = new Ellipse2D.Double(-this.centerMarkRadius / 2, -this.centerMarkRadius / 2, this.centerMarkRadius, this.centerMarkRadius);
        this.mode = 0;
    }

    public static void setPaintCenterDot(boolean state) {
        paintCenterDot = state;
    }

    public void connect(AInteractionsManager manager) {
        super.connect(manager);
        Point2D.Double c = ((AProjection2D)this.window.getProjection()).getCenter();
        this.setCenter(this.hr[0], c.x, c.y);
    }

    public int getPressButton() {
        return 0;
    }

    public int init(Point2D.Double p, int key) {
        this.keyChange(p, key);
        return -1;
    }

    public void pressed(Point2D.Double p, int button, int key) {
        if (key == 67) {
            this.setCenter(this.hr[0], p.x, p.y);
        }
    }

    public int getButton() {
        return 0;
    }

    public void start(Point2D.Double p, int region, int key) {
    }

    private double getHd0(Point2D.Double p) {
        Point2D.Double[] c = this.window.getUserCorners();
        AVector v21 = new AVector(c[2].x, c[2].y, c[1].x, c[1].y);
        AVector v10 = new AVector(c[1].x, c[1].y, c[0].x, c[0].y);
        Point2D.Double center = this.getCenter(this.hr[0]);
        return p.distance(AMath.intersectionPoint(center, v21, p, v10));
    }

    private double getVd0(Point2D.Double p) {
        Point2D.Double[] c = this.window.getUserCorners();
        AVector v01 = new AVector(c[0].x, c[0].y, c[1].x, c[1].y);
        AVector v12 = new AVector(c[1].x, c[1].y, c[2].x, c[2].y);
        Point2D.Double center = this.getCenter(this.hr[0]);
        return p.distance(AMath.intersectionPoint(center, v01, p, v12));
    }

    private void keyChange(Point2D.Double p, int key) {
        this.p0 = p;
        switch (key) {
            case 0: {
                this.mode = 0;
                break;
            }
            case 72: {
                this.mode = 1;
                break;
            }
            case 86: {
                this.mode = 2;
                break;
            }
            case 82: {
                this.mode = 3;
                break;
            }
            case 77: {
                this.mode = 5;
                break;
            }
            case 90: {
                this.mode = 0;
            }
        }
        this.setCursorMode();
    }

    public void drag(Point2D.Double p, int region, int key) {
        if (key != this.previousKey) {
            this.keyChange(p, key);
            this.previousKey = key;
        }
        Point2D.Double center = this.getCenter(this.hr[0]);
        AProjection proj = this.window.getProjection();
        switch (this.mode) {
            case 0: {
                double zf = this.p0.distance(center.x, center.y) / p.distance(center.x, center.y);
                AZMRInteraction.performZoom(this.getCenter(this.hr[0]), zf, this.window);
                break;
            }
            case 1: {
                double zf = this.getHd0(this.p0) / this.getHd0(p);
                AZMRInteraction.performHorizontalZoom(center, zf, this.window);
                break;
            }
            case 2: {
                double zf = this.getVd0(this.p0) / this.getVd0(p);
                AZMRInteraction.performVerticalZoom(center, zf, this.window);
                break;
            }
            case 3: {
                if (proj instanceof AProjectionFR || proj instanceof AProjectionFZ || proj instanceof AProjectionVP) {
                    AZMRInteraction.performPhiRotation(p.y - this.p0.y, this.window);
                    break;
                }
                if (proj instanceof AProjectionLegoPlot) {
                    this.performLegoRotation(center, p.x - this.p0.x, p.y - this.p0.y, this.window);
                    break;
                }
                if (proj instanceof AProjectionRZ || proj instanceof AProjectionXZ || proj instanceof AProjectionYZ || proj instanceof AProjection3D) {
                    AParameter phiPar = APar.get(proj.getName(), "Phi");
                    if (proj instanceof AProjection3D) {
                        Point2D.Double pDisp = this.window.calculateDisplay(p);
                        Point2D.Double p0Disp = this.window.calculateDisplay(this.p0);
                        double height = this.window.getCurrDisp().getHeight();
                        double deltaV = pDisp.getY() - p0Disp.getY();
                        phiPar.setD(this.adjustPhi(phiPar.getD() + 360.0 * deltaV / height));
                    } else {
                        phiPar.setD(this.adjustPhi(phiPar.getD() + (p.y - this.p0.y)));
                    }
                    this.p0 = p;
                    ACanvas.getCanvas().repaintAllFromScratch();
                    break;
                }
                double alpha = AMath.getAngle(p, center) - AMath.getAngle(this.p0, center);
                AZMRInteraction.performRotation(alpha, center, this.window);
                if (!(proj instanceof AProjectionYX)) break;
                AParameter phiPar = APar.get(proj.getName(), "Phi");
                phiPar.setD(this.adjustPhi(phiPar.getD() + Math.toDegrees(alpha)));
                break;
            }
            case 5: {
                if (proj instanceof AProjectionFR || proj instanceof AProjectionFZ || proj instanceof AProjectionVP) {
                    AZMRInteraction.performMove(p.x - this.p0.x, 0.0, this.window);
                    AZMRInteraction.performPhiRotation(p.y - this.p0.y, this.window);
                    break;
                }
                AZMRInteraction.performMove(p.x - this.p0.x, p.y - this.p0.y, this.window);
            }
        }
    }

    private double adjustPhi(double phi) {
        while (phi < 0.0) {
            phi += 360.0;
        }
        while (phi > 360.0) {
            phi -= 360.0;
        }
        return phi;
    }

    public void stop() {
    }

    public void cancel() {
    }

    public void paint(Graphics2D g) {
        Point2D.Double p = this.window.calculateDisplay(this.getCenter(this.hr[0]));
        boolean paintingJustLegoLegend = false;
        if (this.window.getProjection().getName().equals("LegoPlot")) {
            APar.selectWindowParameters(this.window.getName());
            if (!APar.get("LegoPlot", "DrawPlot").getStatus()) {
                paintingJustLegoLegend = true;
            }
            APar.restoreWindowParameters();
        }
        if (paintCenterDot && !paintingJustLegoLegend) {
            g.setColor(Color.red);
            g.fillOval((int)(p.x - (double)(this.centerMarkRadius / 2)), (int)(p.y - (double)(this.centerMarkRadius / 2)), this.centerMarkRadius, this.centerMarkRadius);
        }
    }

    private static boolean checkCornerLimits(Point2D.Double[] corners) {
        for (int i = 0; i < corners.length; ++i) {
            double dY;
            double dX = Math.abs(corners[i].x - corners[(i + 1) % (corners.length - 1)].x);
            double dMax = Math.max(dX, dY = Math.abs(corners[i].y - corners[(i + 1) % (corners.length - 1)].y));
            if (!(dMax < 0.001) && !(dMax > 100000.0)) continue;
            AOutput.alwaysAppend("zoom / unzoom limit reached\n", "NORMAL");
            return false;
        }
        return true;
    }

    public static void performZoom(Point2D.Double center, double zf, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        for (int i = 0; i < corners.length; ++i) {
            corners[i].x = center.x + (corners[i].x - center.x) * zf;
            corners[i].y = center.y + (corners[i].y - center.y) * zf;
        }
        if (!AZMRInteraction.checkCornerLimits(corners)) {
            return;
        }
        window.setUserCorners(corners);
    }

    public static void performRotation(double angle, Point2D.Double center, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        for (int i = 0; i < corners.length; ++i) {
            double dx = corners[i].x - center.x;
            double dy = corners[i].y - center.y;
            corners[i].x = center.x + dx * cos - dy * sin;
            corners[i].y = center.y + dx * sin + dy * cos;
        }
        window.setUserCorners(corners);
    }

    public static void performMinus90Rotation(AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        AVector v12 = new AVector(corners[1], corners[2]);
        double x3 = corners[0].x + v12.dx;
        double y3 = corners[0].y + v12.dy;
        corners[0].setLocation(corners[1]);
        corners[1].setLocation(corners[2]);
        corners[2].setLocation(x3, y3);
        window.setUserCorners(corners);
    }

    public static void performPlus90Rotation(AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        AVector v12 = new AVector(corners[1], corners[2]);
        double x3 = corners[0].x + v12.dx;
        double y3 = corners[0].y + v12.dy;
        corners[2].setLocation(corners[1].x, corners[1].y);
        corners[1].setLocation(corners[0].x, corners[0].y);
        corners[0].setLocation(x3, y3);
        window.setUserCorners(corners);
    }

    public static void performPhiRotation(double dPhi, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        for (int i = 0; i < corners.length; ++i) {
            corners[i].y -= dPhi;
        }
        window.setUserCorners(corners);
    }

    public void performLegoRotation(Point2D.Double center, double dPhi, double dEta, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        if (dPhi != 0.0 || dEta != 0.0) {
            double centerX = -AProjectionLegoPlot.adjustPhi(window, -center.x, center.y);
            corners[0].x -= dPhi;
            AProjectionLegoPlot.setxz(window.getIndex(), AProjectionLegoPlot.getxz(window.getIndex()) + dPhi / 360.0);
            if (AProjectionLegoPlot.getyz(window.getIndex()) < 1.0 || dEta > 0.0) {
                corners[0].y -= dEta;
                corners[1].y -= dEta;
                AProjectionLegoPlot.setyz(window.getIndex(), AProjectionLegoPlot.getyz(window.getIndex()) - dEta / 50.0);
            }
            center.x = AProjectionLegoPlot.adjustPhi(window, centerX, center.y);
            this.setCenter(this.hr[0], center.x, center.y);
            window.setUserCorners(corners);
        }
    }

    public static void performHorizontalZoom(Point2D.Double center, double f, AWindow window) {
        Point2D.Double[] c = window.getUserCorners();
        AVector v21 = new AVector(c[2].x, c[2].y, c[1].x, c[1].y);
        Point2D.Double center1 = new Point2D.Double(center.x + v21.dx, center.y + v21.dy);
        Point2D.Double p0 = AMath.intersectionPoint(c[0], c[1], center, center1);
        AVector v0 = new AVector(p0, c[0]).scale(f);
        AVector v1 = new AVector(p0, c[1]).scale(f);
        c[0].x = p0.x + v0.dx;
        c[0].y = p0.y + v0.dy;
        c[1].x = p0.x + v1.dx;
        c[1].y = p0.y + v1.dy;
        v21.invert();
        p0.setLocation(p0.x + v21.dx, p0.y + v21.dy);
        c[2].x = p0.x + v1.dx;
        c[2].y = p0.y + v1.dy;
        if (!AZMRInteraction.checkCornerLimits(c)) {
            return;
        }
        window.setUserCorners(c);
    }

    public static void performVerticalZoom(Point2D.Double center, double f, AWindow window) {
        Point2D.Double[] c = window.getUserCorners();
        AVector v01 = new AVector(c[0].x, c[0].y, c[1].x, c[1].y);
        Point2D.Double center1 = new Point2D.Double(center.x + v01.dx, center.y + v01.dy);
        Point2D.Double p0 = AMath.intersectionPoint(c[1], c[2], center, center1);
        AVector v1 = new AVector(p0, c[1]).scale(f);
        AVector v2 = new AVector(p0, c[2]).scale(f);
        c[1].x = p0.x + v1.dx;
        c[1].y = p0.y + v1.dy;
        c[2].x = p0.x + v2.dx;
        c[2].y = p0.y + v2.dy;
        v01.invert();
        p0.setLocation(p0.x + v01.dx, p0.y + v01.dy);
        c[0].x = p0.x + v1.dx;
        c[0].y = p0.y + v1.dy;
        if (!AZMRInteraction.checkCornerLimits(c)) {
            return;
        }
        window.setUserCorners(c);
    }

    public static void performMove(double dx, double dy, AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        for (int i = 0; i < corners.length; ++i) {
            corners[i].x -= dx;
            corners[i].y -= dy;
        }
        window.setUserCorners(corners);
    }

    public static Line2D.Double getMiddleHorizontalLine(AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        AVector v12 = new AVector(corners[1], corners[2]).scale(0.5);
        return new Line2D.Double(corners[0].x + v12.dx, corners[0].y + v12.dy, corners[1].x + v12.dx, corners[1].y + v12.dy);
    }

    public static Line2D.Double getMiddleVerticalLine(AWindow window) {
        Point2D.Double[] corners = window.getUserCorners();
        AVector v10 = new AVector(corners[1], corners[0]).scale(0.5);
        return new Line2D.Double(corners[1].x + v10.dx, corners[1].y + v10.dy, corners[2].x + v10.dx, corners[2].y + v10.dy);
    }

    public static void performFlip(Line2D.Double line, AWindow window) {
        if (line == null) {
            return;
        }
        Point2D.Double[] corners = window.getUserCorners();
        double dSquare = AMath.squareDistance(line.x1, line.y1, line.x2, line.y2);
        for (int i = 0; i < corners.length; ++i) {
            double u = 1.0 / dSquare * ((corners[i].x - line.x1) * (line.x2 - line.x1) + (corners[i].y - line.y1) * (line.y2 - line.y1));
            double x0 = line.x1 + u * (line.x2 - line.x1);
            double y0 = line.y1 + u * (line.y2 - line.y1);
            corners[i].x = 2.0 * x0 - corners[i].x;
            corners[i].y = 2.0 * y0 - corners[i].y;
        }
        window.setUserCorners(corners);
    }

    public void setCursorMode() {
        switch (this.mode) {
            case 0: {
                this.window.setCursor(ACursorFactory.getInstance().getZoomCursor());
                break;
            }
            case 1: {
                this.window.setCursor(ACursorFactory.getInstance().getZoomCursor());
                break;
            }
            case 2: {
                this.window.setCursor(ACursorFactory.getInstance().getZoomCursor());
                break;
            }
            case 3: {
                this.window.setCursor(ACursorFactory.getInstance().getRotateCursor());
                break;
            }
            case 5: {
                this.window.setCursor(ACursorFactory.getInstance().getMoveCursor());
            }
        }
    }

    public void entered() {
        this.setCursorMode();
    }

    public void exited() {
        this.window.setCursor(ACursorFactory.getInstance().getDefaultCursor());
    }

    public int getPopupType() {
        return 1;
    }

    public JMenuItem[] getPopupItems() {
        return this.popupItems;
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(TO_CENTER_OF_DETECTOR)) {
            Point2D.Double c = ((AProjection2D)this.window.getProjection()).getCenter();
            this.setCenter(this.hr[0], c.x, c.y);
            this.window.repaint();
        } else if (action.equals(CENTER_PICTURE)) {
            Point2D.Double[] c = this.window.getUserCorners();
            AVector v02 = new AVector(c[0].x, c[0].y, c[2].x, c[2].y).scale(0.5);
            double xc = c[0].x + v02.dx;
            double yc = c[0].y + v02.dy;
            AVector vC0 = new AVector(xc, yc, 0.0, 0.0);
            AProjection proj = this.window.getProjection();
            if (proj instanceof AProjectionLegoPlot) {
                vC0 = new AVector(xc, yc, 180.0 * (1.0 - AProjectionLegoPlot.getxz(this.window.getIndex())), -5.0);
            }
            for (int i = 0; i < c.length; ++i) {
                c[i].x += vC0.dx;
                c[i].y += vC0.dy;
            }
            this.window.setUserCorners(c);
        } else if (action.equals(ASPECT_RATIO_1)) {
            ((AProjection2D)this.window.getProjection()).setAspectRatio1(this.window);
        } else if (action.equals(UNZOOM_FULL)) {
            this.window.setUserCorners(((AProjection2D)this.window.getProjection()).calculateNoZoomCorners(this.window.getSize()));
        }
    }

    public AModifier[] getModifiers() {
        return new AModifier[]{new AModifier(0, false, "Zoom"), new AModifier(90, false, "Zoom"), new AModifier(72, false, "Horizonatal Zoom"), new AModifier(86, false, "Vertical Zoom"), new AModifier(82, false, "Rotate"), new AModifier(70, false, "Fast Zoom"), new AModifier(77, false, "Move (pan)"), new AModifier(67, false, "Modify Central Point")};
    }
}

