/*
 * Decompiled with CFR 0.152.
 */
package atlantis.list;

import atlantis.gui.AColorMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

class AColorIcon
implements Icon {
    private int w;
    private int h;
    private int colorIndex;

    public AColorIcon() {
        this(0, 50, 15);
    }

    public AColorIcon(Dimension d) {
        this.w = d.width;
        this.h = d.height;
    }

    public AColorIcon(int colorIndex, int w, int h) {
        this.colorIndex = colorIndex;
        this.w = w;
        this.h = h;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(Color.black);
        g.drawRect(x, y, this.w - 1, this.h - 1);
        if (this.colorIndex == -2) {
            g.setColor(AColorMap.getColors()[0]);
            g.fillRect(x + 1, y + 1, this.w - 2, this.h - 2);
            g.setColor(Color.black);
            g.drawLine(x, y, x + this.w - 1, y + this.h - 1);
            g.drawLine(x, y + this.h - 1, x + this.w - 1, y);
        } else if (this.colorIndex == -1) {
            g.setColor(AColorMap.getColors()[0]);
            g.fillRect(x + 1, y + 1, this.w - 2, this.h - 2);
            g.setColor(Color.black);
            int xc = x + this.w / 2;
            int yc = y + this.h / 2;
            g.drawLine(xc, yc - 2, xc, yc + 2);
            g.drawLine(xc - 2, yc, xc + 2, yc);
        } else {
            g.setColor(AColorMap.getColors()[this.colorIndex]);
            g.fillRect(x + 1, y + 1, this.w - 2, this.h - 2);
        }
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public int getIconWidth() {
        return this.w;
    }

    public int getIconHeight() {
        return this.h;
    }
}

