/*
 * Decompiled with CFR 0.152.
 */
package atlantis.list;

import atlantis.Atlantis;
import atlantis.canvas.ACanvas;
import atlantis.data.AHelix;
import atlantis.data.ARVxData;
import atlantis.data.ATrackData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.graphics.APickingGraphics2D;
import atlantis.gui.AColorMap;
import atlantis.gui.ACursorFactory;
import atlantis.hypatia.HInvariantMassWindow;
import atlantis.hypatia.HTrackMomentaWindow;
import atlantis.list.AColorIcon;
import atlantis.list.AList;
import atlantis.list.Summarizer;
import atlantis.parameters.APar;
import atlantis.utils.A4Vector;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import atlantis.utils.AOutput;
import atlantis.utils.AUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AListManager
extends JTree
implements MouseListener,
MouseMotionListener {
    private static ALogger logger = ALogger.getLogger(AListManager.class);
    private static JFrame dialog;
    private static final DefaultMutableTreeNode root;
    private static final DefaultMutableTreeNode highlight;
    private static final DefaultMutableTreeNode lastDrawn;
    private static final DefaultMutableTreeNode others;
    private static final DefaultMutableTreeNode invisible;
    private static final DefaultMutableTreeNode mass;
    private static final DefaultMutableTreeNode V0mass;
    private static final AListManager listManager;
    private static DefaultTreeModel dtm;
    private static int numLists;
    private static DefaultMutableTreeNode source;
    private static boolean draging;
    private static HashMapSet nodeColors;
    private static int V0vx;
    private static int V0tracks;
    private static int V0charge;
    private static final Cursor DROP_VALID_COPY;

    private AListManager() {
        super(root, true);
        dtm = (DefaultTreeModel)this.getModel();
        nodeColors = new HashMapSet();
        this.reset();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setSelectionRow(1);
        this.setPreferredSize(new Dimension(200, 300));
        this.setRootVisible(true);
        this.setScrollsOnExpand(true);
        this.setShowsRootHandles(false);
        this.setCellRenderer(new ColorRenderer());
        if (!Atlantis.isAtlantisHeadless()) {
            dialog = new JFrame("List manager");
            AUtilities.setIconImage(dialog);
            Box b = Box.createHorizontalBox();
            b.add(new JScrollPane(this));
            b.add(new ColorPanel());
            dialog.getContentPane().add(b);
            dialog.pack();
            dialog.setDefaultCloseOperation(1);
        }
    }

    public static AListManager getInstance() {
        return listManager;
    }

    public void showLists() {
        if (HTrackMomentaWindow.getGUI() != null) {
            dialog.setLocation(HTrackMomentaWindow.getGUI().getLocation());
        }
        dialog.setVisible(true);
    }

    private boolean isAlreadyInTheList(AList list, DefaultMutableTreeNode destination) {
        boolean already = false;
        for (int i = 0; i < destination.getChildCount(); ++i) {
            AList a;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)destination.getChildAt(i);
            if (child.getAllowsChildren() || (a = (AList)child.getUserObject()).getSource() != list.getSource()) continue;
            int[] items = a.getItems();
            int newItem = list.getItems()[0];
            for (int j = 0; j < items.length; ++j) {
                if (items[j] != newItem) continue;
                already = true;
            }
        }
        return already;
    }

    public void add(AList list) {
        if (!dialog.isVisible()) {
            dialog.setVisible(true);
        }
        DefaultMutableTreeNode destination = root;
        TreePath tp = this.getSelectionPath();
        if (tp != null) {
            destination = (DefaultMutableTreeNode)tp.getLastPathComponent();
        }
        if (destination != null && destination.getAllowsChildren()) {
            if (destination == others || destination == lastDrawn || destination == highlight || destination == invisible || destination == mass || destination == V0mass) {
                AOutput.alwaysAppend("Can't add to " + destination, "WARNING");
                return;
            }
            boolean already = this.isAlreadyInTheList(list, destination);
            if (already) {
                logger.info(list + " is already in this list, not added");
            } else {
                dtm.insertNodeInto(new DefaultMutableTreeNode(list, false), destination, destination.getChildCount());
                this.expandPath(new TreePath(dtm.getPathToRoot(destination)));
                ACanvas.getCanvas().repaintAllFromScratch();
            }
        }
    }

    public void massCalc(AList list) {
        DefaultMutableTreeNode destination = mass;
        TreePath tp = this.getSelectionPath();
        if (destination != null && destination.getAllowsChildren()) {
            boolean already = this.isAlreadyInTheList(list, destination);
            if (already) {
                logger.info(list + " is already in this list, not added");
            } else {
                dtm.insertNodeInto(new DefaultMutableTreeNode(list, false), destination, destination.getChildCount());
                this.expandPath(new TreePath(dtm.getPathToRoot(destination)));
                ACanvas.getCanvas().repaintAllFromScratch();
            }
        }
        if (tp != null) {
            this.setSelectionPath(tp);
        }
        Summarizer summ = new Summarizer();
        AOutput.alwaysAppend(summ.getHeader(), "NORMAL");
        AList[] children = this.getChildren(mass);
        int chiLength = children.length;
        for (int i = 0; i < chiLength; ++i) {
            int num = children[i].getItems().length;
            A4Vector v = children[i].getSource().get4Vector(num, children[i].getItems(), 0.14);
            if (v == null || num <= 0) continue;
            String info = summ.addAndGetInfo(v, children[i].toString());
            AOutput.alwaysAppend(info, "NORMAL");
        }
        String msg = summ.getTotalInfo();
        AOutput.alwaysAppend(msg, "NORMAL_BOLD");
        summ = null;
    }

    public void massCalcV0(AList list) {
        DefaultMutableTreeNode destination = V0mass;
        TreePath tp = this.getSelectionPath();
        if (this.getChildren(V0mass).length == 0) {
            V0vx = 0;
            V0tracks = 0;
            V0charge = 0;
        }
        if (destination != null && destination.getAllowsChildren()) {
            boolean already = this.isAlreadyInTheList(list, destination);
            if (this.getChildren(V0mass).length < 3) {
                if (already) {
                    logger.info(list + " is already in this list, not added");
                } else {
                    if (!(list.getSource() instanceof ARVxData) && !(list.getSource() instanceof ATrackData)) {
                        logger.info("not selected a track or vertex");
                        AOutput.alwaysAppend("\n\n not selected a track or vertex\n\n", "PICK");
                        return;
                    }
                    if (list.getSource() instanceof ARVxData && V0vx >= 1 || list.getSource() instanceof ATrackData && V0tracks >= 2) {
                        logger.info("already a vertex or two tracks selected");
                        AOutput.alwaysAppend("\n\n Already a vertex or two tracks selected\n", "PICK");
                        return;
                    }
                    if (list.getSource() instanceof ATrackData) {
                        ATrackData track = (ATrackData)list.getSource();
                        AHelix h = track.getModifiableHelix(list.getItemsID()[0]);
                        if (V0charge != 0 && (double)V0charge * AMath.getSign(h.pT) > 0.0) {
                            logger.info("2nd track is same charge as 1st track");
                            AOutput.alwaysAppend("\n\nPlease pick an oppositely charged track\n", "PICK");
                            return;
                        }
                    }
                    if (list.getSource() instanceof ATrackData) {
                        ++V0tracks;
                        AOutput.alwaysAppend("\nSelected a Track\n", "PICK");
                    } else if (list.getSource() instanceof ARVxData) {
                        ++V0vx;
                        AOutput.alwaysAppend("\nSelected a Vertex\n", "PICK");
                    }
                    dtm.insertNodeInto(new DefaultMutableTreeNode(list, false), destination, destination.getChildCount());
                    this.expandPath(new TreePath(dtm.getPathToRoot(destination)));
                    ACanvas.getCanvas().repaintAllFromScratch();
                }
            } else {
                logger.info("list full (max 2 tracks + 1 vertex)");
                AOutput.alwaysAppend("\n\n List full (max 2 tracks + 1 vertex)\n", "PICK");
                return;
            }
        }
        if (tp != null) {
            this.setSelectionPath(tp);
        }
        Summarizer summK = new Summarizer();
        Summarizer summL = new Summarizer();
        Summarizer summAL = new Summarizer();
        Summarizer summG = new Summarizer();
        double[] secVx = new double[]{APar.get("Event", "XVtx").getD(), APar.get("Event", "YVtx").getD(), APar.get("Event", "ZVtx").getD()};
        AList[] children = this.getChildren(V0mass);
        int chiLength = children.length;
        if (chiLength <= 3) {
            for (int i = 0; i < chiLength; ++i) {
                AData source = children[i].getSource();
                if (source instanceof ARVxData) {
                    ARVxData rvx = (ARVxData)source;
                    secVx = rvx.getVertex(i);
                    continue;
                }
                if (!(source instanceof ATrackData)) continue;
                ATrackData track = (ATrackData)source;
                AHelix h = track.getModifiableHelix(children[i].getItemsID()[0]);
                V0charge = (int)AMath.getSign(h.pT);
                int num = children[i].getItems().length;
                A4Vector vK = source.get4Vector(num, children[i].getItems(), 0.0);
                A4Vector vL = source.get4Vector(num, children[i].getItems(), 0.0);
                A4Vector vAL = source.get4Vector(num, children[i].getItems(), 0.0);
                A4Vector vG = source.get4Vector(num, children[i].getItems(), 0.0);
                if (V0vx > 0) {
                    double R = AMath.getCurvature() * Math.abs(h.pT);
                    double S = AMath.getSign(h.pT);
                    double xC = (S * h.d0 - R) * Math.cos(Math.toRadians(h.phi0) + S * Math.PI / 2.0);
                    double yC = (S * h.d0 - R) * Math.sin(Math.toRadians(h.phi0) + S * Math.PI / 2.0);
                    double phiPrime = Math.atan2(yC - secVx[1], xC - secVx[0]) + (double)V0charge * 1.5707963267948966;
                    double px = Math.abs(h.pT) * Math.cos(h.phi0);
                    double py = Math.abs(h.pT) * Math.sin(h.phi0);
                    double pz = Math.abs(h.pT) * Math.sinh(h.eta);
                    double pxPrime = Math.sqrt(px * px + py * py) * Math.cos(phiPrime);
                    double pyPrime = Math.sqrt(px * px + py * py) * Math.sin(phiPrime);
                    px = pxPrime;
                    py = pyPrime;
                    logger.info("recalculating tracks");
                    AOutput.alwaysAppend("\n\nRecalculated track values:\n", "PICK");
                    AOutput.alwaysAppend(source.getNameScreenName() + " index: " + children[i].getItemsID()[0] + "\n" + "PT=" + AMath.d2s(h.pT, 3) + " GeV\n" + "\u03b7" + " = " + AMath.d2s(h.eta, 3) + "\n" + "\u03a6" + " = " + AMath.d2s(AMath.radiansToDegrees(phiPrime), 3) + "\u00b0" + "\n" + "Px=" + AMath.d2s(px, 3) + " GeV\n" + "Py=" + AMath.d2s(py, 3) + " GeV\n" + "Pz=" + AMath.d2s(pz, 3) + " GeV\n" + "Charge = " + V0charge, "PICK");
                    if (V0charge < 0) {
                        vK.set(px, py, pz, 0.1396);
                        vL.set(px, py, pz, 0.1396);
                        vAL.set(px, py, pz, 0.938);
                        vG.set(px, py, pz, 5.11E-4);
                    } else if (V0charge > 0) {
                        vK.set(px, py, pz, 0.1396);
                        vL.set(px, py, pz, 0.938);
                        vAL.set(px, py, pz, 0.1396);
                        vG.set(px, py, pz, 5.11E-4);
                    }
                }
                if (vK == null || vL == null || vAL == null || vG == null || num <= 0) continue;
                String info = summK.addAndGetInfo(vK, children[i].toString());
                info = summL.addAndGetInfo(vL, children[i].toString());
                info = summAL.addAndGetInfo(vAL, children[i].toString());
                info = summG.addAndGetInfo(vG, children[i].toString());
            }
            if (chiLength == 3 && !APar.get("Minerva", "hideV0massoutput").getStatus()) {
                String msgK = summK.getTotalInfo();
                String msgL = summL.getTotalInfo();
                String msgAL = summAL.getTotalInfo();
                String msgG = summG.getTotalInfo();
                AOutput.alwaysAppend("\n V0 Decay Scenarios", "NORMAL_BOLD");
                AOutput.alwaysAppend(summK.getHeader(), "NORMAL");
                AOutput.alwaysAppend("K\u279d\u03c0\u207a\u03c0\u207b\n", "NORMAL");
                AOutput.alwaysAppend(msgK, "NORMAL_BOLD");
                AOutput.alwaysAppend("\n\u039b\u279dp\u03c0\u207b\n", "NORMAL");
                AOutput.alwaysAppend(msgL, "NORMAL_BOLD");
                AOutput.alwaysAppend("\n\u039b\u0305\u279dp\u0305\u03c0\u207a\n", "NORMAL");
                AOutput.alwaysAppend(msgAL, "NORMAL_BOLD");
                AOutput.alwaysAppend("\n\u03b3\u279de\u207ae\u207b\n", "NORMAL");
                AOutput.alwaysAppend(msgG, "NORMAL_BOLD");
                AOutput.alwaysAppend("\n", "NORMAL");
            }
        } else {
            AOutput.alwaysAppend("Too many tracks selected", "NORMAL");
        }
        summK = null;
        summL = null;
        summAL = null;
        summG = null;
    }

    public void highlight(AList list) {
        highlight.removeAllChildren();
        dtm.insertNodeInto(new DefaultMutableTreeNode(list, false), highlight, 0);
        dtm.reload(highlight);
        this.expandPath(new TreePath(dtm.getPathToRoot(highlight)));
        HInvariantMassWindow.findTrack();
        HTrackMomentaWindow.findTrack();
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    public void addLastDrawn(AList list) {
        dtm.insertNodeInto(new DefaultMutableTreeNode(list, false), lastDrawn, 0);
        dtm.reload(lastDrawn);
    }

    public void addInvisible(AList list) {
        boolean already;
        if (!dialog.isVisible()) {
            dialog.setVisible(true);
        }
        if (already = this.isAlreadyInTheList(list, invisible)) {
            logger.info(list + " is already in the Invisible list, not added");
        } else {
            dtm.insertNodeInto(new DefaultMutableTreeNode(list, false), invisible, invisible.getChildCount());
            this.expandPath(new TreePath(dtm.getPathToRoot(invisible)));
            ACanvas.getCanvas().repaintAllFromScratch();
        }
    }

    private Action expand(final Collection s) {
        if (s.contains(root) || s.size() != 1) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)s.iterator().next();
        if (node.getUserObject() instanceof AList) {
            AList a = (AList)node.getUserObject();
            if (a.getItems().length < 1) {
                return null;
            }
        } else {
            return null;
        }
        return new AbstractAction("Expand items"){

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)s.iterator().next();
                AList a = (AList)node.getUserObject();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex(node);
                for (int i = 0; i < a.getItems().length; ++i) {
                    AList list = new AList(a.getSource(), a.getItems()[i]);
                    dtm.insertNodeInto(new DefaultMutableTreeNode(list, false), parent, index);
                }
                dtm.removeNodeFromParent(node);
            }
        };
    }

    private Action remove(final Collection s) {
        if (s.contains(root)) {
            return null;
        }
        return new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                for (DefaultMutableTreeNode node : s) {
                    if (node.getUserObject() instanceof AList) {
                        AList a = (AList)node.getUserObject();
                        a.getSource().remove(a.getItems());
                    }
                    dtm.removeNodeFromParent(node);
                    ACanvas.getCanvas().repaintAllFromScratch();
                }
            }
        };
    }

    private Action newSummarize(final Collection s) {
        if (s.contains(root) || s.size() != 1) {
            return null;
        }
        return new AbstractAction("Summarize"){

            public void actionPerformed(ActionEvent e) {
                Summarizer summ = new Summarizer();
                AOutput.alwaysAppend(summ.getHeader(), "NORMAL");
                for (DefaultMutableTreeNode node : s) {
                    AList[] children = AListManager.this.getChildren(node);
                    for (int i = 0; i < children.length; ++i) {
                        int num = children[i].getItems().length;
                        A4Vector v = children[i].getSource().get4Vector(num, children[i].getItems());
                        if (v == null || num <= 0) continue;
                        String info = summ.addAndGetInfo(v, children[i].toString());
                        AOutput.alwaysAppend(info, "NORMAL");
                    }
                }
                String msg = summ.getTotalInfo();
                AOutput.alwaysAppend(msg, "NORMAL_BOLD");
                summ = null;
            }
        };
    }

    public void summarize() {
        if (lastDrawn == null) {
            return;
        }
        Summarizer summ = new Summarizer();
        AList[] children = this.getChildren(lastDrawn);
        AOutput.alwaysAppend(summ.getHeader(), "NORMAL");
        for (int i = 0; i < children.length; ++i) {
            int num = children[i].getItems().length;
            A4Vector v = children[i].getSource().get4Vector(num, children[i].getItems());
            if (v == null || num <= 0) continue;
            String msg = summ.addAndGetInfo(v, children[i].toString());
            AOutput.alwaysAppend(msg, "NORMAL");
        }
        String msg = summ.getTotalInfo();
        AOutput.alwaysAppend(msg, "NORMAL_BOLD");
        summ = null;
    }

    private Action reset(Collection s) {
        if (s.size() == 1 && s.contains(root)) {
            return new AbstractAction("Reset"){

                public void actionPerformed(ActionEvent e) {
                    AListManager.this.reset();
                    ACanvas.getCanvas().repaintAllFromScratch();
                }
            };
        }
        return null;
    }

    public void clearHighlight() {
        highlight.removeAllChildren();
        dtm.reload(highlight);
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    public void clearHighlightAndMassCalculation() {
        highlight.removeAllChildren();
        dtm.reload(highlight);
        mass.removeAllChildren();
        V0mass.removeAllChildren();
        dtm.reload(mass);
        dtm.reload(V0mass);
        ACanvas.getCanvas().repaintAllFromScratch();
    }

    public void clearLastDrawn() {
        lastDrawn.removeAllChildren();
        dtm.reload(lastDrawn);
    }

    private boolean checkAndAddIntoInvisible(int[] id, int[] indexCheck, String key) {
        boolean result = false;
        AEvent e = Atlantis.getEventManager().getCurrentEvent();
        AData toMask = e.get(key);
        if (toMask != null) {
            for (int i = 0; i < id.length; ++i) {
                int index = toMask.getIndexFromId(id[i]);
                if (index == -1) continue;
                AList l = new AList(toMask, index);
                this.addInvisible(l);
                AOutput.alwaysAppend("  " + l.toString() + "\n", "NORMAL");
                result = true;
                if (index == indexCheck[i]) continue;
                logger.warn("AListManager: problem, indices not equal!");
            }
        }
        return result;
    }

    private void restoreInvisible(AList[] backup) {
        if (backup.length > 0) {
            AOutput.alwaysAppend("\nPrevious Invisible list not empty, masked items:\n", "WARNING");
            boolean somethingInvisible = false;
            for (int i = 0; i < backup.length; ++i) {
                AData d = backup[i].getSource();
                String sg = d.getStoreGateKey();
                String accessKey = d.getName() + (sg != null ? sg : "");
                if (backup[i].getItems().length > 1) {
                    somethingInvisible = this.checkAndAddIntoInvisible(backup[i].getItemsID(), backup[i].getItems(), accessKey);
                    continue;
                }
                int id = backup[i].getItemsID()[0];
                int index = backup[i].getItems()[0];
                somethingInvisible = this.checkAndAddIntoInvisible(new int[]{id}, new int[]{index}, accessKey);
            }
            if (!somethingInvisible) {
                AOutput.alwaysAppend("  none\n", "NORMAL");
            }
        }
    }

    public void resetAndPreserveInvisible() {
        AList[] invisibleBackup = this.getChildren(invisible);
        this.reset();
        this.restoreInvisible(invisibleBackup);
    }

    public void reset() {
        root.removeAllChildren();
        highlight.removeAllChildren();
        lastDrawn.removeAllChildren();
        invisible.removeAllChildren();
        mass.removeAllChildren();
        V0mass.removeAllChildren();
        root.add(highlight);
        root.add(lastDrawn);
        root.add(others);
        root.add(invisible);
        root.add(mass);
        root.add(V0mass);
        numLists = 0;
        root.add(new DefaultMutableTreeNode("List " + numLists++));
        nodeColors.clear();
        nodeColors.put(highlight, new Integer(0));
        nodeColors.put(invisible, new Integer(-2));
        nodeColors.put(mass, new Integer(0));
        nodeColors.put(V0mass, new Integer(0));
        dtm.reload();
    }

    private Action rename(Collection s) {
        if (s.size() != 1) {
            return null;
        }
        final DefaultMutableTreeNode selected = (DefaultMutableTreeNode)s.iterator().next();
        if (!selected.getAllowsChildren() || selected == root || selected == others || selected == highlight || selected == lastDrawn || selected == invisible || selected == mass || selected == V0mass) {
            return null;
        }
        return new AbstractAction("Rename"){

            public void actionPerformed(ActionEvent h) {
                String name = JOptionPane.showInputDialog(listManager, (Object)"Enter new name");
                selected.setUserObject(name);
            }
        };
    }

    private Action newParent(final Collection s) {
        if (s.contains(root)) {
            return null;
        }
        HashSet<TreeNode> parents = new HashSet<TreeNode>();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            parents.add(((TreeNode)i.next()).getParent());
        }
        if (parents.size() != 1) {
            return null;
        }
        final DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)parents.iterator().next();
        return new AbstractAction("New Parent"){

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode newParent = new DefaultMutableTreeNode("List " + numLists++);
                int index = 0;
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    index = Math.min(oldParent.getIndex((TreeNode)i.next()), index);
                }
                i = s.iterator();
                while (i.hasNext()) {
                    dtm.removeNodeFromParent((MutableTreeNode)i.next());
                }
                dtm.insertNodeInto(newParent, oldParent, index);
                i = s.iterator();
                while (i.hasNext()) {
                    dtm.insertNodeInto((MutableTreeNode)i.next(), newParent, 0);
                }
                AListManager.this.expandPath(new TreePath(dtm.getPathToRoot(newParent)));
            }
        };
    }

    private Action newChild(Collection s) {
        if (s.size() != 1) {
            return null;
        }
        final DefaultMutableTreeNode selected = (DefaultMutableTreeNode)s.iterator().next();
        if (!selected.getAllowsChildren()) {
            return null;
        }
        return new AbstractAction("New Child"){

            public void actionPerformed(ActionEvent h) {
                dtm.insertNodeInto(new DefaultMutableTreeNode("List " + numLists++), selected, 0);
                AListManager.this.expandPath(new TreePath(dtm.getPathToRoot(selected)));
            }
        };
    }

    private DefaultMutableTreeNode getNode(Point m) {
        TreeNode tn;
        TreePath p = this.getPathForLocation(m.x, m.y);
        if (p != null && (tn = (TreeNode)p.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)tn;
        }
        return null;
    }

    private int getColor(TreeNode node) {
        TreeNode[] parents = dtm.getPathToRoot(node);
        int color = -1;
        for (int i = 0; i < parents.length; ++i) {
            Object o = nodeColors.get(parents[i]);
            if (o == null) continue;
            color = (Integer)o;
        }
        return color;
    }

    private DefaultMutableTreeNode[] getLeafs() {
        ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            if (node == lastDrawn) continue;
            if (node.getAllowsChildren()) {
                Enumeration<TreeNode> descendents = node.breadthFirstEnumeration();
                while (descendents.hasMoreElements()) {
                    DefaultMutableTreeNode descendent = (DefaultMutableTreeNode)descendents.nextElement();
                    if (descendent.getAllowsChildren()) continue;
                    list.add(descendent);
                }
                continue;
            }
            list.add(node);
        }
        return list.toArray(new DefaultMutableTreeNode[list.size()]);
    }

    public int[][] getColorMapping(AData data) {
        DefaultMutableTreeNode[] leafs = this.getLeafs();
        int num = 0;
        for (int i = 0; i < leafs.length; ++i) {
            if (((AList)leafs[i].getUserObject()).getSource() != data) continue;
            num += ((AList)leafs[i].getUserObject()).getItems().length;
        }
        int[] index = new int[num];
        int[] color = new int[num];
        num = 0;
        for (int i = 0; i < leafs.length; ++i) {
            if (((AList)leafs[i].getUserObject()).getSource() != data) continue;
            int[] items = ((AList)leafs[i].getUserObject()).getItems();
            int c = this.getColor(leafs[i]);
            for (int j = 0; j < items.length; ++j) {
                index[num] = items[j];
                color[num] = c;
                ++num;
            }
        }
        int[][] temp = new int[][]{index, color};
        return temp;
    }

    public int getColorOfOthers() {
        return this.getColor(others);
    }

    public boolean[] getSelection(AData data) {
        boolean[] selected = new boolean[data.getNumData()];
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).breadthFirstEnumeration();
                while (nodes.hasMoreElements()) {
                    AList a;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                    if (node.getAllowsChildren() || (a = (AList)node.getUserObject()).getSource() != data) continue;
                    int[] items = a.getItems();
                    for (int j = 0; j < items.length; ++j) {
                        selected[items[j]] = true;
                    }
                }
            }
        }
        return selected;
    }

    public AList[] getChildren(DefaultMutableTreeNode node) {
        ArrayList<Object> children = new ArrayList<Object>();
        Object o = node.getUserObject();
        if (o instanceof AList) {
            children.add(o);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                AList[] grandChildren = this.getChildren((DefaultMutableTreeNode)node.getChildAt(i));
                for (int j = 0; j < grandChildren.length; ++j) {
                    children.add(grandChildren[j]);
                }
            }
        }
        return children.toArray(new AList[children.size()]);
    }

    public static Collection uniqueExpansion(Collection s) {
        HashSet<TreeNode> c = new HashSet<TreeNode>();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Enumeration<TreeNode> en = ((DefaultMutableTreeNode)i.next()).depthFirstEnumeration();
            while (en.hasMoreElements()) {
                c.add(en.nextElement());
            }
        }
        return c;
    }

    public ArrayList getLastDrawn() {
        ArrayList<Object> result = new ArrayList<Object>();
        Enumeration<TreeNode> myenum = lastDrawn.children();
        while (myenum.hasMoreElements()) {
            Object o = ((DefaultMutableTreeNode)myenum.nextElement()).getUserObject();
            if (!(o instanceof AList) || ((AList)o).getItems().length <= 0) continue;
            result.add(o);
        }
        return result;
    }

    public void copyLastDrawn() {
        DefaultMutableTreeNode copy = new DefaultMutableTreeNode("List " + numLists++);
        Enumeration<TreeNode> myenum = lastDrawn.children();
        while (myenum.hasMoreElements()) {
            Object o = ((DefaultMutableTreeNode)myenum.nextElement()).getUserObject();
            if (!(o instanceof AList) || ((AList)o).getItems().length <= 0) continue;
            copy.add(new DefaultMutableTreeNode(o, false));
        }
        dtm.insertNodeInto(copy, root, 0);
        this.setSelectionPath(new TreePath(dtm.getPathToRoot(copy)));
    }

    public void mouseExited(MouseEvent e) {
        this.update(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.update(e);
    }

    public void mousePressed(MouseEvent e) {
        AList a;
        DefaultMutableTreeNode node;
        source = this.getNode(e.getPoint());
        TreePath tp = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (tp != null && !(node = (DefaultMutableTreeNode)tp.getLastPathComponent()).getAllowsChildren() && (a = (AList)node.getUserObject()).getItems().length == 1) {
            APickingGraphics2D.setPicked(a.getSource(), a.getItems()[0]);
        }
        if (!AUtilities.isRightMouseButton(e)) {
            return;
        }
        if (tp != null) {
            if (e.isControlDown()) {
                this.addSelectionPath(tp);
            } else {
                this.setSelectionPath(tp);
            }
        }
        TreePath[] sel = this.getSelectionPaths();
        ArrayList<Object> selection = new ArrayList<Object>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            selection.add(sel[i].getLastPathComponent());
        }
        JPopupMenu popup = new JPopupMenu();
        Action temp = this.expand(selection);
        if (temp != null) {
            popup.add(temp);
        }
        if ((temp = this.remove(selection)) != null) {
            popup.add(temp);
        }
        if ((temp = this.reset(selection)) != null) {
            popup.add(temp);
        }
        if ((temp = this.rename(selection)) != null) {
            popup.add(temp);
        }
        if ((temp = this.newParent(selection)) != null) {
            popup.add(temp);
        }
        if ((temp = this.newChild(selection)) != null) {
            popup.add(temp);
        }
        if ((temp = this.newSummarize(selection)) != null) {
            popup.add(temp);
        }
        AData[] listProcessors = Atlantis.getEventManager().getCurrentEvent().getData();
        for (int i = 0; i < listProcessors.length; ++i) {
            Action[] actions = listProcessors[i].getActions(selection);
            for (int j = 0; j < actions.length; ++j) {
                popup.add(actions[j]);
            }
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!draging && source != null && this.isDragSource(source)) {
            draging = true;
        }
        this.update(e);
    }

    public void mouseReleased(MouseEvent e) {
        DefaultMutableTreeNode destination;
        if (draging && source != null && (destination = this.getNode(e.getPoint())) != null && source != destination && destination.getAllowsChildren() && this.isValidDrag(source, destination)) {
            if (!e.isControlDown() && source != lastDrawn) {
                dtm.removeNodeFromParent(source);
            }
            if (source == lastDrawn) {
                DefaultMutableTreeNode copy = new DefaultMutableTreeNode("List " + numLists++);
                Enumeration<TreeNode> myenum = source.children();
                while (myenum.hasMoreElements()) {
                    Object o = ((DefaultMutableTreeNode)myenum.nextElement()).getUserObject();
                    copy.add(new DefaultMutableTreeNode(o, false));
                }
                dtm.insertNodeInto(copy, destination, 0);
            } else {
                dtm.insertNodeInto(source, destination, 0);
            }
            this.expandPath(this.getPathForLocation(e.getX(), e.getY()));
            ACanvas.getCanvas().repaintAllFromScratch();
        }
        draging = false;
        source = null;
        this.setCursor(ACursorFactory.getInstance().getDefaultCursor());
    }

    private boolean isDragSource(DefaultMutableTreeNode source) {
        return source != null && source != root && source != highlight && source != others && source != mass && source != V0mass;
    }

    private boolean isValidDrag(DefaultMutableTreeNode source, DefaultMutableTreeNode destination) {
        if (source == null || destination == null) {
            return false;
        }
        if (source == root || source == highlight || source == others || source == mass || source == V0mass) {
            return false;
        }
        if (destination == others) {
            return false;
        }
        if (destination == lastDrawn) {
            return false;
        }
        if (destination == highlight) {
            if (source.getAllowsChildren()) {
                return false;
            }
            if (((AList)source.getUserObject()).getItems().length != 1) {
                return false;
            }
            if (highlight.getChildCount() != 0) {
                return false;
            }
        }
        return true;
    }

    private void update(MouseEvent e) {
        if (!draging) {
            return;
        }
        Point point = e.getPoint();
        DefaultMutableTreeNode current = this.getNode(point);
        if (current != null && current.getAllowsChildren() && this.isValidDrag(source, current)) {
            TreePath p = this.getPathForLocation(point.x, point.y);
            this.setSelectionPath(p);
            if (e.isControlDown()) {
                this.setCursor(DROP_VALID_COPY);
            } else {
                this.setCursor(ACursorFactory.getInstance().getDragValidCursor());
            }
        } else {
            this.setCursor(ACursorFactory.getInstance().getDragInvalidCursor());
        }
    }

    static {
        root = new DefaultMutableTreeNode("Lists");
        highlight = new DefaultMutableTreeNode("Highlight");
        lastDrawn = new DefaultMutableTreeNode("Last Drawn");
        others = new DefaultMutableTreeNode("Others");
        invisible = new DefaultMutableTreeNode("Invisible");
        mass = new DefaultMutableTreeNode("Mass calculation");
        V0mass = new DefaultMutableTreeNode("Neutral Decay Mass Calculation");
        listManager = new AListManager();
        numLists = 0;
        source = null;
        draging = false;
        V0vx = 0;
        V0tracks = 0;
        V0charge = 0;
        DROP_VALID_COPY = DragSource.DefaultCopyDrop;
    }

    class ColorPanel
    extends JPanel {
        ColorPanel() {
            Color[] colorMap = AColorMap.getColors();
            ActionListener a = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int colorIndex = ((AColorIcon)((JButton)e.getSource()).getIcon()).getColorIndex();
                    TreePath[] sel = AListManager.this.getSelectionPaths();
                    if (sel != null) {
                        for (int i = 0; i < sel.length; ++i) {
                            nodeColors.put(sel[i].getLastPathComponent(), new Integer(colorIndex));
                        }
                    }
                    listManager.repaint();
                    ACanvas.getCanvas().repaintAllFromScratch();
                }
            };
            Box b = Box.createVerticalBox();
            for (int i = 0; i < colorMap.length; ++i) {
                JButton l = new JButton(new AColorIcon(i, 13, 13));
                l.setMargin(new Insets(0, 0, 0, 0));
                l.setBorder(null);
                b.add(l);
                b.add(Box.createVerticalStrut(3));
                l.addActionListener(a);
            }
            b.add(Box.createVerticalStrut(6));
            JButton l = new JButton(new AColorIcon(-1, 13, 13));
            l.setMargin(new Insets(0, 0, 0, 0));
            l.setBorder(null);
            l.setToolTipText("No specified color");
            b.add(l);
            b.add(Box.createVerticalStrut(3));
            l.addActionListener(a);
            l = new JButton(new AColorIcon(-2, 13, 13));
            l.setMargin(new Insets(0, 0, 0, 0));
            l.setBorder(null);
            l.setToolTipText("Invisible");
            b.add(l);
            l.addActionListener(a);
            super.add(b);
        }
    }

    class ColorRenderer
    extends DefaultTreeCellRenderer {
        AColorIcon folderIcon = new AColorIcon(0, 15, 11);
        AColorIcon leafIcon = new AColorIcon(0, 11, 11);

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            int c = AListManager.this.getColor((TreeNode)value);
            if (c == -1) {
                this.setToolTipText("No Color");
            } else if (c == -2) {
                this.setToolTipText("Invisible");
            } else {
                this.setToolTipText("");
            }
            if (leaf) {
                this.leafIcon.setColorIndex(c);
                this.setIcon(this.leafIcon);
            } else {
                this.folderIcon.setColorIndex(c);
                this.setIcon(this.folderIcon);
            }
            return this;
        }
    }

    private static class HashMapSet
    extends HashMap {
        private HashMapSet() {
        }

        public Object put(Object key, Object value) {
            if (this.containsKey(key)) {
                this.remove(key);
            }
            if (value != null) {
                return super.put(key, value);
            }
            return null;
        }
    }
}

