/*
 * Decompiled with CFR 0.152.
 */
package atlantis.list;

import atlantis.utils.A4Vector;
import atlantis.utils.AMath;

class Summarizer {
    private A4Vector vector = new A4Vector();

    public String getHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nSummary output:\n");
        sb.append(AMath.ensureWidth(" ", 20));
        sb.append(AMath.pad("  ET  ", 8));
        sb.append(AMath.pad("  E   ", 8));
        sb.append(AMath.pad("  M   ", 8));
        sb.append("\n");
        return sb.toString();
    }

    public String getMass(A4Vector item, int length) {
        double mass = item.getMass();
        String stringMass = null;
        stringMass = Double.isNaN(mass) ? "NaN" : AMath.d2s(mass, length);
        return stringMass;
    }

    public String addAndGetInfo(A4Vector item, String description) {
        this.vector.add(item);
        StringBuffer sb = new StringBuffer();
        sb.append(description);
        sb.append("\n");
        sb.append(AMath.ensureWidth(" ", 20));
        sb.append(AMath.pad(AMath.d2s(item.getPt(), 1), 7));
        sb.append(AMath.pad(AMath.d2s(item.getE(), 1), 7));
        sb.append(AMath.pad(this.getMass(item, 3), 8));
        sb.append("\n");
        return sb.toString();
    }

    public String getTotalInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(AMath.ensureWidth("Total", 20));
        sb.append(AMath.pad(AMath.d2s(this.vector.getPt(), 1), 7));
        sb.append(AMath.pad(AMath.d2s(this.vector.getE(), 1), 7));
        sb.append(AMath.pad(this.getMass(this.vector, 3), 8));
        sb.append("\n");
        return sb.toString();
    }
}

