/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.canvas.AWindow;
import atlantis.nge.ANAnimInterpolate;
import atlantis.nge.ANAnimSegment;
import atlantis.nge.ANAnimSetProjection;
import atlantis.nge.ANAnimThread;
import atlantis.nge.ANAnimVar;
import atlantis.nge.ANFrameManager;
import atlantis.nge.ANProjection;
import java.util.ArrayList;
import java.util.ListIterator;

public class ANAnimationManager {
    public static final int INTERP_LINEAR = 1;
    private ArrayList<ANAnimSegment> m_segs = new ArrayList();
    private double m_now;
    private ANAnimThread m_at;

    public ANAnimationManager(AWindow w) {
        this.updateNow();
        this.m_at = new ANAnimThread(this, w);
        new Thread(this.m_at).start();
    }

    public void updateNow() {
        this.m_now = (double)System.currentTimeMillis() / 1000.0;
    }

    public void scheduleAnimationAbsolute(ANAnimVar v, double t1, double t2, double v1, double v2) {
        this.m_segs.add(new ANAnimInterpolate(v, t1, t2, v1, v2, 1));
        this.m_at.reschedule();
    }

    public void scheduleAnimation(ANAnimVar v, double t1, double t2, double v1, double v2) {
        this.updateNow();
        this.scheduleAnimationAbsolute(v, t1 + this.m_now, t2 + this.m_now, v1, v2);
    }

    public void scheduleProjectionChange(ANFrameManager fm, ANProjection p, double t) {
        this.updateNow();
        this.m_segs.add(new ANAnimSetProjection(fm, p, t + this.m_now));
        this.m_at.reschedule();
    }

    public void animate() {
        this.updateNow();
        ListIterator<ANAnimSegment> it = this.m_segs.listIterator();
        while (it.hasNext()) {
            ANAnimSegment seg = (ANAnimSegment)it.next();
            if (seg.getStart() < this.m_now) {
                seg.evaluate(this.m_now);
            }
            if (!(seg.getEnd() < this.m_now)) continue;
            it.remove();
        }
    }

    public double timeToWait() {
        double next = -1.0;
        this.updateNow();
        ListIterator<ANAnimSegment> it = this.m_segs.listIterator();
        while (it.hasNext()) {
            double wait;
            ANAnimSegment seg = (ANAnimSegment)it.next();
            if (seg.getStart() <= next && seg.getEnd() >= next) {
                return 0.0;
            }
            if (!(seg.getStart() >= next) || !((wait = seg.getStart() - this.m_now) < next) && next != -1.0) continue;
            if (wait < 0.0) {
                wait = 0.0;
            }
            next = wait;
        }
        return next;
    }
}

