/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.gui.AColorMap;
import java.awt.Color;

public class ANColor {
    public float r;
    public float g;
    public float b;
    public float a;

    public ANColor(Color c) {
        this.r = (float)c.getRed() / 255.0f;
        this.g = (float)c.getGreen() / 255.0f;
        this.b = (float)c.getBlue() / 255.0f;
        this.a = (float)c.getAlpha() / 255.0f;
    }

    public ANColor(float _r, float _g, float _b, float _a) {
        this.r = _r;
        this.g = _g;
        this.b = _b;
        this.a = _a;
    }

    public ANColor(float _r, float _g, float _b) {
        this.r = _r;
        this.g = _g;
        this.b = _b;
        this.a = 1.0f;
    }

    public static ANColor getBGColor() {
        return ANColor.getMapColor(8);
    }

    public static ANColor getMapColor(int index) {
        Color bg = AColorMap.getColors()[index];
        float r = (float)bg.getRed() / 255.0f;
        float g = (float)bg.getGreen() / 255.0f;
        float b = (float)bg.getBlue() / 255.0f;
        return new ANColor(r, g, b);
    }

    public static ANColor getMapColor(int index, float trans) {
        Color bg = AColorMap.getColors()[index];
        float r = (float)bg.getRed() / 255.0f;
        float g = (float)bg.getGreen() / 255.0f;
        float b = (float)bg.getBlue() / 255.0f;
        return new ANColor(r, g, b, trans);
    }

    public void mult(float c) {
        this.r *= c;
        this.g *= c;
        this.b *= c;
        if (this.r < 0.0f) {
            this.r = 0.0f;
        }
        if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        }
        if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        }
        if (this.b > 1.0f) {
            this.b = 1.0f;
        }
    }

    public void lighten(float c) {
        this.r = 1.0f - (1.0f - this.r) * c;
        this.g = 1.0f - (1.0f - this.g) * c;
        this.b = 1.0f - (1.0f - this.b) * c;
        if (this.r < 0.0f) {
            this.r = 0.0f;
        }
        if (this.r > 1.0f) {
            this.r = 1.0f;
        }
        if (this.g < 0.0f) {
            this.g = 0.0f;
        }
        if (this.g > 1.0f) {
            this.g = 1.0f;
        }
        if (this.b < 0.0f) {
            this.b = 0.0f;
        }
        if (this.b > 1.0f) {
            this.b = 1.0f;
        }
    }
}

