/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.canvas.AWindow;
import atlantis.nge.ANAnimationManager;
import atlantis.nge.ANLinearProjection;
import atlantis.nge.ANLinearTransition;
import atlantis.nge.ANPickHandler;
import atlantis.nge.ANPickHelper;
import atlantis.nge.ANPickResult;
import atlantis.nge.ANProjection;
import atlantis.nge.ANProjection3D;
import atlantis.nge.ANProjectionPhysics;
import atlantis.nge.ANProjectionYX;
import atlantis.nge.ANRenderHints;
import atlantis.nge.ANSelectionList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

public class ANFrameManager {
    private ANProjection m_targ;
    private ANProjection m_proj = null;
    private ANAnimationManager m_am;

    public ANFrameManager(AWindow w) {
        this.m_am = new ANAnimationManager(w);
    }

    public ANPickResult pick(GLAutoDrawable drawable, int w, int h, int x, int y) {
        if (this.m_proj == null) {
            return null;
        }
        long before = System.nanoTime();
        GL gl = drawable.getGL();
        gl.glViewport(0, 0, w, h);
        GLU glu = new GLU();
        int maxsize = 100000;
        ByteBuffer bb = ByteBuffer.allocateDirect(4 * maxsize);
        bb.order(ByteOrder.nativeOrder());
        IntBuffer ib = bb.asIntBuffer();
        gl.glSelectBuffer(maxsize, ib);
        gl.glRenderMode(7170);
        gl.glMatrixMode(5889);
        int[] viewport = new int[4];
        gl.glLoadIdentity();
        gl.glGetIntegerv(2978, viewport, 0);
        y = h - y;
        glu.gluPickMatrix((double)(x - 1), (double)(y - 1), 3.0, 3.0, viewport, 0);
        ANRenderHints rh = new ANRenderHints();
        rh.setPick(true);
        rh.setPickHelper(new ANPickHelper(gl));
        this.m_proj.display(drawable, w, h, rh);
        int hits = gl.glRenderMode(7168);
        System.out.println("HITS: " + hits);
        ANSelectionList sl = new ANSelectionList(ib);
        int[] front = sl.getFrontID();
        ANPickResult ret = null;
        if (front != null) {
            int id = front[0];
            System.out.println(id);
            int data = front[1];
            System.out.println(data);
            ANPickHandler ph = rh.getPickHelper().getPickHandler(id);
            System.out.println(ph);
            if (ph != null) {
                ret = ph.getHitInfo(data);
            }
        }
        long after = System.nanoTime();
        System.out.println("Pick took: " + (after - before) / 1000L);
        System.out.println(ret);
        return ret;
    }

    public void display(GLAutoDrawable drawable, int w, int h) {
        System.out.println("Asked to display!");
        if (this.m_proj == null) {
            return;
        }
        long before = System.nanoTime();
        DebugGL gl = new DebugGL(drawable.getGL());
        gl.glViewport(0, 0, w, h);
        this.m_am.animate();
        this.m_proj.display(drawable, w, h, new ANRenderHints());
        long after = System.nanoTime();
        System.out.println("Frame took: " + (after - before) / 1000L);
    }

    public double timeToWait() {
        return this.m_am.timeToWait();
    }

    public ANProjection getTargetProjection() {
        return this.m_targ;
    }

    public ANProjection getCurrentProjection() {
        return this.m_proj;
    }

    public void setCurrentProjection(ANProjection proj) {
        this.m_proj = proj;
    }

    public void scheduleTransition(ANProjection p) {
        this.m_targ = p;
        if (this.m_proj == null || this.m_proj == p) {
            this.m_proj = p;
            return;
        }
        if (this.m_proj instanceof ANLinearProjection && p instanceof ANLinearProjection) {
            ANLinearTransition trans = new ANLinearTransition((ANLinearProjection)this.m_proj, (ANLinearProjection)p);
            this.setCurrentProjection(trans);
            double length = 1.0;
            this.m_am.scheduleAnimation(trans.getTransformTimeVar(), 0.0, length, 0.0, 1.0);
            this.m_am.scheduleAnimation(trans.getFadeTimeVar(), 0.0, length, 0.0, 1.0);
            this.m_am.scheduleProjectionChange(this, p, length);
        } else {
            this.m_proj = p;
        }
    }

    public void checkProjectionYX() {
        if (!(this.m_targ instanceof ANProjectionYX)) {
            this.scheduleTransition(new ANProjectionYX());
        }
    }

    public void checkProjection3D() {
        if (!(this.m_targ instanceof ANProjection3D)) {
            this.scheduleTransition(new ANProjection3D());
        }
    }

    public ANProjectionPhysics checkProjectionPhysics() {
        if (!(this.m_targ instanceof ANProjectionPhysics)) {
            ANProjectionPhysics pp = new ANProjectionPhysics();
            this.scheduleTransition(pp);
            return pp;
        }
        return (ANProjectionPhysics)this.m_targ;
    }

    public ANAnimationManager getAnimationManager() {
        return this.m_am;
    }
}

