/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.Atlantis;
import atlantis.data.AJetData;
import atlantis.data.ALArData;
import atlantis.event.AEvent;
import atlantis.geometry.ABarrelCalorimeterDetector;
import atlantis.geometry.ABoxDetector;
import atlantis.geometry.ACalorimeterDetector;
import atlantis.geometry.ADetector;
import atlantis.geometry.ADetectors;
import atlantis.geometry.AEndcapCalorimeterDetector;
import atlantis.geometry.AEndcapCryostatDetector;
import atlantis.nge.ANColor;
import atlantis.nge.ANProjection;
import atlantis.nge.ANRenderHints;
import atlantis.nge.object.data.ANObjectDataCell;
import atlantis.nge.object.data.ANObjectDataJet;
import atlantis.nge.object.geometry.ANObjectGeomCalo;
import atlantis.nge.object.geometry.ANObjectGeomMuon;
import atlantis.utils.AMath;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public abstract class ANLinearProjection
extends ANProjection {
    public ANObjectGeomMuon m_ogm;
    public ANObjectGeomCalo m_ogc;
    public ANObjectGeomCalo m_ogetp;
    public ANObjectGeomCalo m_ogtsp;
    public ANObjectGeomCalo m_ogecp;
    public ANObjectGeomCalo m_ogetm;
    public ANObjectGeomCalo m_ogtsm;
    public ANObjectGeomCalo m_ogecm;
    public ANObjectDataJet m_jet;
    public ANObjectDataCell m_lar;

    public abstract void applyLinearTransform(GLAutoDrawable var1, int var2, int var3);

    public abstract void drawScene(GLAutoDrawable var1, ANRenderHints var2);

    public final void display(GLAutoDrawable drawable, int w, int h, ANRenderHints hint) {
        GL gl = drawable.getGL();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        if (!hint.getPick()) {
            gl.glLoadIdentity();
        }
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glEnable(2929);
        gl.glPolygonOffset(2.0f, 1.0f);
        gl.glEnable(32823);
        this.applyLinearTransform(drawable, w, h);
        ANColor bg = ANColor.getBGColor();
        gl.glClearColor(bg.r, bg.g, bg.b, 1.0f);
        gl.glClear(0x4000 | 0x100);
        this.drawScene(drawable, hint);
    }

    public final void createGeometry() {
        ArrayList<ABoxDetector> m_boxes = new ArrayList<ABoxDetector>();
        ArrayList<ACalorimeterDetector> m_calo = new ArrayList<ACalorimeterDetector>();
        ArrayList<ACalorimeterDetector> m_extt = new ArrayList<ACalorimeterDetector>();
        ArrayList<ACalorimeterDetector> m_mbts = new ArrayList<ACalorimeterDetector>();
        ArrayList<ACalorimeterDetector> m_endc = new ArrayList<ACalorimeterDetector>();
        ADetectors[] ds = Atlantis.getDetector().getDetectors();
        for (int i = 0; i < ds.length; ++i) {
            ADetector[] d = ds[i].getDetectors();
            for (int j = 0; j < d.length; ++j) {
                ACalorimeterDetector ecd;
                if (d[j] instanceof ABoxDetector) {
                    ABoxDetector bd = (ABoxDetector)d[j];
                    m_boxes.add(bd);
                    continue;
                }
                if (d[j] instanceof ABarrelCalorimeterDetector) {
                    ACalorimeterDetector cd = (ACalorimeterDetector)d[j];
                    if (d[j].getName().equals("Extended TILE")) {
                        m_extt.add(cd);
                        continue;
                    }
                    m_calo.add(cd);
                    continue;
                }
                if (d[j] instanceof AEndcapCryostatDetector) {
                    ecd = (AEndcapCryostatDetector)d[j];
                    m_mbts.add(ecd);
                    continue;
                }
                if (!(d[j] instanceof AEndcapCalorimeterDetector)) continue;
                ecd = (AEndcapCalorimeterDetector)d[j];
                m_endc.add(ecd);
            }
        }
        this.m_ogm = new ANObjectGeomMuon(m_boxes);
        this.m_ogc = new ANObjectGeomCalo(m_calo, 4, false);
        this.m_ogetp = new ANObjectGeomCalo(m_extt, 4, false);
        this.m_ogtsp = new ANObjectGeomCalo(m_mbts, 1, false);
        this.m_ogecp = new ANObjectGeomCalo(m_endc, 1, false);
        this.m_ogetm = new ANObjectGeomCalo(m_extt, 4, true);
        this.m_ogtsm = new ANObjectGeomCalo(m_mbts, 1, true);
        this.m_ogecm = new ANObjectGeomCalo(m_endc, 1, true);
    }

    public final void createData() {
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        AJetData ajd = ev.getJetData();
        ajd.makeDrawList();
        this.m_jet = new ANObjectDataJet(ajd);
        ALArData ald = ev.getLArData();
        ald.makeDrawList();
        this.m_lar = new ANObjectDataCell(ald);
    }

    public final void createGeometry(float phi, float eta, float dr) {
        ArrayList<ABoxDetector> m_boxes = new ArrayList<ABoxDetector>();
        ArrayList<ACalorimeterDetector> m_calo = new ArrayList<ACalorimeterDetector>();
        ArrayList<ACalorimeterDetector> m_extt = new ArrayList<ACalorimeterDetector>();
        ArrayList<ACalorimeterDetector> m_mbts = new ArrayList<ACalorimeterDetector>();
        ArrayList<ACalorimeterDetector> m_endc = new ArrayList<ACalorimeterDetector>();
        ADetectors[] ds = Atlantis.getDetector().getDetectors();
        for (int i = 0; i < ds.length; ++i) {
            ADetector[] d = ds[i].getDetectors();
            for (int j = 0; j < d.length; ++j) {
                ACalorimeterDetector ecd;
                if (d[j] instanceof ABoxDetector) {
                    ABoxDetector bd = (ABoxDetector)d[j];
                    float etabd = (float)AMath.etaAbs(bd.getZMin(), bd.getRMin());
                    if (!(AMath.deltaR(phi, eta, (float)bd.getPhi(), etabd) < dr)) continue;
                    m_boxes.add(bd);
                    continue;
                }
                if (d[j] instanceof ABarrelCalorimeterDetector) {
                    ACalorimeterDetector cd = (ACalorimeterDetector)d[j];
                    if (d[j].getName().equals("Extended TILE")) {
                        m_extt.add(cd);
                        continue;
                    }
                    m_calo.add(cd);
                    continue;
                }
                if (d[j] instanceof AEndcapCryostatDetector) {
                    ecd = (AEndcapCryostatDetector)d[j];
                    m_mbts.add(ecd);
                    continue;
                }
                if (!(d[j] instanceof AEndcapCalorimeterDetector)) continue;
                ecd = (AEndcapCalorimeterDetector)d[j];
                m_endc.add(ecd);
            }
        }
        this.m_ogm = new ANObjectGeomMuon(m_boxes);
        this.m_ogc = new ANObjectGeomCalo(m_calo, 4, false);
        this.m_ogetp = new ANObjectGeomCalo(m_extt, 4, false);
        this.m_ogtsp = new ANObjectGeomCalo(m_mbts, 1, false);
        this.m_ogecp = new ANObjectGeomCalo(m_endc, 1, false);
        this.m_ogetm = new ANObjectGeomCalo(m_extt, 4, true);
        this.m_ogtsm = new ANObjectGeomCalo(m_mbts, 1, true);
        this.m_ogecm = new ANObjectGeomCalo(m_endc, 1, true);
    }

    public final void createData(float phi, float eta, float dr) {
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        AJetData ajd = ev.getJetData();
        ajd.makeDrawList();
        this.m_jet = new ANObjectDataJet(ajd, phi, eta, dr);
        ALArData ald = ev.getLArData();
        ald.makeDrawList();
        this.m_lar = new ANObjectDataCell(ald, phi, eta, dr);
    }
}

