/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.nge.ANAnimVar;
import atlantis.nge.ANColor;
import atlantis.nge.ANLinearProjection;
import atlantis.nge.ANRenderHints;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public class ANLinearTransition
extends ANLinearProjection {
    private ANLinearProjection m_a;
    private ANLinearProjection m_b;
    private ANAnimVar m_vtttime = new ANAnimVar();
    private ANAnimVar m_fadetime = new ANAnimVar();

    public ANLinearTransition(ANLinearProjection a, ANLinearProjection b) {
        this.m_a = a;
        this.m_b = b;
    }

    public ANAnimVar getTransformTimeVar() {
        return this.m_vtttime;
    }

    public ANAnimVar getFadeTimeVar() {
        return this.m_fadetime;
    }

    public void applyLinearTransform(GLAutoDrawable drawable, int w, int h) {
        GL gl = drawable.getGL();
        double vtttime = this.m_vtttime.getValue();
        if (vtttime < 0.0) {
            vtttime = 0.0;
        }
        if (vtttime <= 0.0) {
            this.m_a.applyLinearTransform(drawable, w, h);
        } else if (vtttime >= 1.0) {
            this.m_b.applyLinearTransform(drawable, w, h);
        } else {
            float[] ma = new float[16];
            float[] mb = new float[16];
            gl.glMatrixMode(5889);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            this.m_a.applyLinearTransform(drawable, w, h);
            gl.glGetFloatv(2983, ma, 0);
            gl.glLoadIdentity();
            this.m_b.applyLinearTransform(drawable, w, h);
            gl.glGetFloatv(2983, mb, 0);
            gl.glPopMatrix();
            float[] matrix = new float[16];
            double[] zerosums = new double[4];
            double[] gradsums = new double[4];
            for (int y = 0; y < 4; ++y) {
                zerosums[y] = 0.0;
                gradsums[y] = 0.0;
                for (int x = 0; x < 4; ++x) {
                    int n = y;
                    zerosums[n] = zerosums[n] + (double)ma[4 * x + y];
                    int n2 = y;
                    gradsums[n2] = gradsums[n2] + (double)(mb[4 * x + y] - ma[4 * x + y]);
                }
            }
            double w0 = ma[3] + ma[7] + ma[11] + ma[15];
            double wT = mb[3] + mb[7] + mb[11] + mb[15];
            double[] timeest = new double[3];
            for (int i = 0; i < 3; ++i) {
                double c0w = (double)(ma[0 + i] + ma[4 + i] + ma[8 + i] + ma[12 + i]) / w0;
                double cTw = (double)(mb[0 + i] + mb[4 + i] + mb[8 + i] + mb[12 + i]) / wT;
                double beta = c0w + (cTw - c0w) * vtttime;
                timeest[i] = (zerosums[i] - zerosums[3] * beta) / (gradsums[3] * beta - gradsums[i]);
            }
            double meantime = (timeest[0] + timeest[1] + timeest[2]) / 3.0;
            for (int i = 0; i < 16; ++i) {
                matrix[i] = (float)((double)ma[i] + (double)(mb[i] - ma[i]) * meantime);
            }
            gl.glMultMatrixf(matrix, 0);
        }
    }

    public void drawScene(GLAutoDrawable drawable, ANRenderHints hint) {
        GL gl = drawable.getGL();
        if (this.m_fadetime.getValue() > 0.0) {
            this.m_a.drawScene(drawable, hint);
            gl.glMatrixMode(5889);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
            ANColor bgc = ANColor.getBGColor();
            gl.glColor4f(bgc.r, bgc.g, bgc.b, (float)this.m_fadetime.getValue());
            gl.glDisable(2929);
            gl.glBegin(7);
            gl.glVertex3f(-1.0f, -1.0f, 0.0f);
            gl.glVertex3f(1.0f, -1.0f, 0.0f);
            gl.glVertex3f(1.0f, 1.0f, 0.0f);
            gl.glVertex3f(-1.0f, 1.0f, 0.0f);
            gl.glEnd();
            gl.glEnable(2929);
            gl.glPopMatrix();
            gl.glClear(256);
        }
        this.m_b.drawScene(drawable, hint);
    }
}

