/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.canvas.AWindow;
import atlantis.nge.ANFrameManager;
import atlantis.utils.ALogger;
import java.util.Hashtable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPbuffer;

public class ANManager
implements GLEventListener {
    private static ALogger logger = ALogger.getLogger(ANManager.class);
    private static ANManager manager = new ANManager();
    private Hashtable<AWindow, ANFrameManager> m_fms = new Hashtable();
    private GLPbuffer m_buf = null;
    private GLEventListener m_gll;

    public static ANManager getManager() {
        return manager;
    }

    public ANFrameManager getFrameManager(AWindow w) {
        if (w == null) {
            return null;
        }
        ANFrameManager fm = this.m_fms.get(w);
        if (fm == null) {
            fm = new ANFrameManager(w);
            this.m_fms.put(w, fm);
        }
        return fm;
    }

    public static int getNextPower2(int v) {
        int p = 1;
        for (int i = 0; i < 16; ++i) {
            if ((p *= 2) < v) continue;
            return p;
        }
        logger.warn("Returning non power of 2 buffer size!");
        return v;
    }

    public void requestBufferDraw(int w, int h, GLEventListener gll) {
        if (this.m_buf == null || this.m_buf.getWidth() < w || this.m_buf.getHeight() < h) {
            if (this.m_buf != null) {
                this.m_buf.destroy();
            }
            GLCapabilities pbcap = new GLCapabilities();
            pbcap.setHardwareAccelerated(true);
            pbcap.setSampleBuffers(true);
            pbcap.setNumSamples(4);
            this.m_buf = GLDrawableFactory.getFactory().createGLPbuffer(pbcap, null, ANManager.getNextPower2(w), ANManager.getNextPower2(h), null);
            if (this.m_buf == null) {
                logger.error("Got null when trying to create pbuffer!");
                return;
            }
            this.m_buf.addGLEventListener((GLEventListener)this);
            logger.info("Created pbuffer w: " + this.m_buf.getWidth() + " h: " + this.m_buf.getHeight());
            if (this.m_buf.getChosenGLCapabilities() == null) {
                logger.warn("Your implementation returns null for pbuffer capabilities...");
            } else {
                logger.info("Pbuffer hardware accelleration: " + this.m_buf.getChosenGLCapabilities().getHardwareAccelerated());
            }
        }
        this.m_gll = gll;
        this.m_buf.display();
    }

    public void init(GLAutoDrawable arg0) {
        this.m_gll.init(arg0);
    }

    public void display(GLAutoDrawable arg0) {
        this.m_gll.display(arg0);
    }

    public void reshape(GLAutoDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
        this.m_gll.reshape(arg0, arg1, arg2, arg3, arg4);
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
        this.m_gll.displayChanged(arg0, arg1, arg2);
    }
}

