/*
 * Decompiled with CFR 0.152.
 */
package atlantis.nge;

import atlantis.Atlantis;
import atlantis.data.ACalorimeterData;
import atlantis.data.AJetData;
import atlantis.data.ATrackData;
import atlantis.event.AData;
import atlantis.event.AEvent;
import atlantis.geometry.ABoxDetector;
import atlantis.nge.ANTerribleHacks;
import atlantis.nge.object.ANObject;
import atlantis.nge.object.ANObjectList;
import atlantis.nge.object.data.ANObjectPointing;
import atlantis.nge.object.data.ANObjectTracks;
import atlantis.nge.object.geometry.ANObjectGeomMuon;
import atlantis.utils.ALogger;
import atlantis.utils.AMath;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public class ANObjectGenerator {
    private static ALogger logger = ALogger.getLogger(ANObjectGenerator.class);
    private static ANObjectGenerator thegenerator = new ANObjectGenerator();

    private ANObjectGenerator() {
    }

    public static ANObjectGenerator getGenerator() {
        return thegenerator;
    }

    public ANObject getGeometryMuon() {
        return new ANObjectGeomMuon(ANTerribleHacks.getMuonDetectors());
    }

    public ANObject getGeometryMuon(float phi, float eta, float dr) {
        ArrayList<ABoxDetector> boxes = ANTerribleHacks.getMuonDetectors();
        ArrayList<ABoxDetector> hits = new ArrayList<ABoxDetector>();
        for (int i = 0; i < boxes.size(); ++i) {
            ABoxDetector bd = boxes.get(i);
            float etabd = (float)AMath.etaAbs(bd.getZMin(), bd.getRMin());
            if (!(AMath.deltaR(phi, eta, (float)bd.getPhi(), etabd) < dr)) continue;
            hits.add(bd);
        }
        return new ANObjectGeomMuon(hits);
    }

    public ANObject getDataCaloForJet(int j, String key) {
        ANObjectList ol = new ANObjectList();
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        AJetData jd = ev.getJetData();
        String assockey = jd.getName() + jd.getStoreGateKey();
        int[][] assoc = ev.getAssociationManager().get(assockey, key);
        if (assoc == null) {
            return ol;
        }
        if (assoc[j] == null) {
            return ol;
        }
        int[] dl = new int[assoc[j].length];
        List calolist = ev.getCalorimeters();
        AData calo = null;
        for (int i = 0; i < calolist.size(); ++i) {
            ACalorimeterData tc = (ACalorimeterData)calolist.get(i);
            if (!tc.getName().equals(key)) continue;
            calo = tc;
        }
        if (calo == null) {
            logger.error("Requested unavailable calo key!");
            return ol;
        }
        calo.makeDrawList();
        int[] calodl = calo.getDrawList();
        IntBuffer ib = IntBuffer.allocate(assoc[j].length);
        for (int i = 0; i < assoc[j].length; ++i) {
            int id = assoc[j][i];
            int index = calo.getIndexFromId(id);
            boolean found = false;
            for (int d = 0; d < calo.getNumDraw(); ++d) {
                if (calodl[d] != index) continue;
                found = true;
            }
            if (!found) continue;
            ib.put(index);
        }
        ol.addObject(new ANObjectPointing((ACalorimeterData)calo, ib.array(), ib.position(), true));
        ol.addObject(new ANObjectPointing((ACalorimeterData)calo, ib.array(), ib.position(), false));
        return ol;
    }

    public ANObject getInDetTracksForJet(int j) {
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        AJetData jd = ev.getJetData();
        int jetid = jd.getIdFromIndex(j);
        ATrackData tracks = ev.getTrackData("InDetTrack");
        int[] trackdl = tracks.getDrawList();
        String jetassockey = jd.getName() + jd.getStoreGateKey();
        String trackassockey = tracks.getName() + tracks.getStoreGateKey();
        int[][] assoc = ev.getAssociationManager().get(trackassockey, jetassockey);
        IntBuffer ib = IntBuffer.allocate(assoc.length);
        for (int i = 0; i < assoc.length; ++i) {
            for (int s = 0; s < assoc[i].length; ++s) {
                if (assoc[i][s] != jetid) continue;
                boolean display = false;
                for (int d = 0; d < trackdl.length; ++d) {
                    if (trackdl[d] != i) continue;
                    display = true;
                }
                if (!display) continue;
                ib.put(i);
            }
        }
        return new ANObjectTracks(tracks, ib.array());
    }

    public ANObject getInDetTracks() {
        AEvent ev = Atlantis.getEventManager().getCurrentEvent();
        ATrackData td = ev.getTrackData("InDetTrack");
        return new ANObjectTracks(td);
    }
}

